/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.constants;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Locale;

public final class Instructions {
    public static final int UNREACHABLE = 0;
    public static final int NOP = 1;
    public static final int BLOCK = 2;
    public static final int LOOP = 3;
    public static final int IF = 4;
    public static final int ELSE = 5;
    public static final int END = 11;
    public static final int BR = 12;
    public static final int BR_IF = 13;
    public static final int BR_TABLE = 14;
    public static final int RETURN = 15;
    public static final int CALL = 16;
    public static final int CALL_INDIRECT = 17;
    public static final int DROP = 26;
    public static final int SELECT = 27;
    public static final int SELECT_T = 28;
    public static final int LOCAL_GET = 32;
    public static final int LOCAL_SET = 33;
    public static final int LOCAL_TEE = 34;
    public static final int GLOBAL_GET = 35;
    public static final int GLOBAL_SET = 36;
    public static final int TABLE_GET = 37;
    public static final int TABLE_SET = 38;
    public static final int I32_LOAD = 40;
    public static final int I64_LOAD = 41;
    public static final int F32_LOAD = 42;
    public static final int F64_LOAD = 43;
    public static final int I32_LOAD8_S = 44;
    public static final int I32_LOAD8_U = 45;
    public static final int I32_LOAD16_S = 46;
    public static final int I32_LOAD16_U = 47;
    public static final int I64_LOAD8_S = 48;
    public static final int I64_LOAD8_U = 49;
    public static final int I64_LOAD16_S = 50;
    public static final int I64_LOAD16_U = 51;
    public static final int I64_LOAD32_S = 52;
    public static final int I64_LOAD32_U = 53;
    public static final int I32_STORE = 54;
    public static final int I64_STORE = 55;
    public static final int F32_STORE = 56;
    public static final int F64_STORE = 57;
    public static final int I32_STORE_8 = 58;
    public static final int I32_STORE_16 = 59;
    public static final int I64_STORE_8 = 60;
    public static final int I64_STORE_16 = 61;
    public static final int I64_STORE_32 = 62;
    public static final int MEMORY_SIZE = 63;
    public static final int MEMORY_GROW = 64;
    public static final int I32_CONST = 65;
    public static final int I64_CONST = 66;
    public static final int F32_CONST = 67;
    public static final int F64_CONST = 68;
    public static final int I32_EQZ = 69;
    public static final int I32_EQ = 70;
    public static final int I32_NE = 71;
    public static final int I32_LT_S = 72;
    public static final int I32_LT_U = 73;
    public static final int I32_GT_S = 74;
    public static final int I32_GT_U = 75;
    public static final int I32_LE_S = 76;
    public static final int I32_LE_U = 77;
    public static final int I32_GE_S = 78;
    public static final int I32_GE_U = 79;
    public static final int I64_EQZ = 80;
    public static final int I64_EQ = 81;
    public static final int I64_NE = 82;
    public static final int I64_LT_S = 83;
    public static final int I64_LT_U = 84;
    public static final int I64_GT_S = 85;
    public static final int I64_GT_U = 86;
    public static final int I64_LE_S = 87;
    public static final int I64_LE_U = 88;
    public static final int I64_GE_S = 89;
    public static final int I64_GE_U = 90;
    public static final int F32_EQ = 91;
    public static final int F32_NE = 92;
    public static final int F32_LT = 93;
    public static final int F32_GT = 94;
    public static final int F32_LE = 95;
    public static final int F32_GE = 96;
    public static final int F64_EQ = 97;
    public static final int F64_NE = 98;
    public static final int F64_LT = 99;
    public static final int F64_GT = 100;
    public static final int F64_LE = 101;
    public static final int F64_GE = 102;
    public static final int I32_CLZ = 103;
    public static final int I32_CTZ = 104;
    public static final int I32_POPCNT = 105;
    public static final int I32_ADD = 106;
    public static final int I32_SUB = 107;
    public static final int I32_MUL = 108;
    public static final int I32_DIV_S = 109;
    public static final int I32_DIV_U = 110;
    public static final int I32_REM_S = 111;
    public static final int I32_REM_U = 112;
    public static final int I32_AND = 113;
    public static final int I32_OR = 114;
    public static final int I32_XOR = 115;
    public static final int I32_SHL = 116;
    public static final int I32_SHR_S = 117;
    public static final int I32_SHR_U = 118;
    public static final int I32_ROTL = 119;
    public static final int I32_ROTR = 120;
    public static final int I64_CLZ = 121;
    public static final int I64_CTZ = 122;
    public static final int I64_POPCNT = 123;
    public static final int I64_ADD = 124;
    public static final int I64_SUB = 125;
    public static final int I64_MUL = 126;
    public static final int I64_DIV_S = 127;
    public static final int I64_DIV_U = 128;
    public static final int I64_REM_S = 129;
    public static final int I64_REM_U = 130;
    public static final int I64_AND = 131;
    public static final int I64_OR = 132;
    public static final int I64_XOR = 133;
    public static final int I64_SHL = 134;
    public static final int I64_SHR_S = 135;
    public static final int I64_SHR_U = 136;
    public static final int I64_ROTL = 137;
    public static final int I64_ROTR = 138;
    public static final int F32_ABS = 139;
    public static final int F32_NEG = 140;
    public static final int F32_CEIL = 141;
    public static final int F32_FLOOR = 142;
    public static final int F32_TRUNC = 143;
    public static final int F32_NEAREST = 144;
    public static final int F32_SQRT = 145;
    public static final int F32_ADD = 146;
    public static final int F32_SUB = 147;
    public static final int F32_MUL = 148;
    public static final int F32_DIV = 149;
    public static final int F32_MIN = 150;
    public static final int F32_MAX = 151;
    public static final int F32_COPYSIGN = 152;
    public static final int F64_ABS = 153;
    public static final int F64_NEG = 154;
    public static final int F64_CEIL = 155;
    public static final int F64_FLOOR = 156;
    public static final int F64_TRUNC = 157;
    public static final int F64_NEAREST = 158;
    public static final int F64_SQRT = 159;
    public static final int F64_ADD = 160;
    public static final int F64_SUB = 161;
    public static final int F64_MUL = 162;
    public static final int F64_DIV = 163;
    public static final int F64_MIN = 164;
    public static final int F64_MAX = 165;
    public static final int F64_COPYSIGN = 166;
    public static final int I32_WRAP_I64 = 167;
    public static final int I32_TRUNC_F32_S = 168;
    public static final int I32_TRUNC_F32_U = 169;
    public static final int I32_TRUNC_F64_S = 170;
    public static final int I32_TRUNC_F64_U = 171;
    public static final int I64_EXTEND_I32_S = 172;
    public static final int I64_EXTEND_I32_U = 173;
    public static final int I64_TRUNC_F32_S = 174;
    public static final int I64_TRUNC_F32_U = 175;
    public static final int I64_TRUNC_F64_S = 176;
    public static final int I64_TRUNC_F64_U = 177;
    public static final int F32_CONVERT_I32_S = 178;
    public static final int F32_CONVERT_I32_U = 179;
    public static final int F32_CONVERT_I64_S = 180;
    public static final int F32_CONVERT_I64_U = 181;
    public static final int F32_DEMOTE_F64 = 182;
    public static final int F64_CONVERT_I32_S = 183;
    public static final int F64_CONVERT_I32_U = 184;
    public static final int F64_CONVERT_I64_S = 185;
    public static final int F64_CONVERT_I64_U = 186;
    public static final int F64_PROMOTE_F32 = 187;
    public static final int I32_REINTERPRET_F32 = 188;
    public static final int I64_REINTERPRET_F64 = 189;
    public static final int F32_REINTERPRET_I32 = 190;
    public static final int F64_REINTERPRET_I64 = 191;
    public static final int MISC = 252;
    public static final int I32_TRUNC_SAT_F32_S = 0;
    public static final int I32_TRUNC_SAT_F32_U = 1;
    public static final int I32_TRUNC_SAT_F64_S = 2;
    public static final int I32_TRUNC_SAT_F64_U = 3;
    public static final int I64_TRUNC_SAT_F32_S = 4;
    public static final int I64_TRUNC_SAT_F32_U = 5;
    public static final int I64_TRUNC_SAT_F64_S = 6;
    public static final int I64_TRUNC_SAT_F64_U = 7;
    public static final int I32_EXTEND8_S = 192;
    public static final int I32_EXTEND16_S = 193;
    public static final int I64_EXTEND8_S = 194;
    public static final int I64_EXTEND16_S = 195;
    public static final int I64_EXTEND32_S = 196;
    public static final int REF_NULL = 208;
    public static final int REF_IS_NULL = 209;
    public static final int REF_FUNC = 210;
    public static final int MEMORY_INIT = 8;
    public static final int DATA_DROP = 9;
    public static final int MEMORY_COPY = 10;
    public static final int MEMORY_FILL = 11;
    public static final int TABLE_INIT = 12;
    public static final int ELEM_DROP = 13;
    public static final int TABLE_COPY = 14;
    public static final int TABLE_GROW = 15;
    public static final int TABLE_SIZE = 16;
    public static final int TABLE_FILL = 17;
    public static final int ATOMIC = 254;
    public static final int ATOMIC_NOTIFY = 0;
    public static final int ATOMIC_WAIT32 = 1;
    public static final int ATOMIC_WAIT64 = 2;
    public static final int ATOMIC_FENCE = 3;
    public static final int ATOMIC_I32_LOAD = 16;
    public static final int ATOMIC_I64_LOAD = 17;
    public static final int ATOMIC_I32_LOAD8_U = 18;
    public static final int ATOMIC_I32_LOAD16_U = 19;
    public static final int ATOMIC_I64_LOAD8_U = 20;
    public static final int ATOMIC_I64_LOAD16_U = 21;
    public static final int ATOMIC_I64_LOAD32_U = 22;
    public static final int ATOMIC_I32_STORE = 23;
    public static final int ATOMIC_I64_STORE = 24;
    public static final int ATOMIC_I32_STORE8 = 25;
    public static final int ATOMIC_I32_STORE16 = 26;
    public static final int ATOMIC_I64_STORE8 = 27;
    public static final int ATOMIC_I64_STORE16 = 28;
    public static final int ATOMIC_I64_STORE32 = 29;
    public static final int ATOMIC_I32_RMW_ADD = 30;
    public static final int ATOMIC_I64_RMW_ADD = 31;
    public static final int ATOMIC_I32_RMW8_U_ADD = 32;
    public static final int ATOMIC_I32_RMW16_U_ADD = 33;
    public static final int ATOMIC_I64_RMW8_U_ADD = 34;
    public static final int ATOMIC_I64_RMW16_U_ADD = 35;
    public static final int ATOMIC_I64_RMW32_U_ADD = 36;
    public static final int ATOMIC_I32_RMW_SUB = 37;
    public static final int ATOMIC_I64_RMW_SUB = 38;
    public static final int ATOMIC_I32_RMW8_U_SUB = 39;
    public static final int ATOMIC_I32_RMW16_U_SUB = 40;
    public static final int ATOMIC_I64_RMW8_U_SUB = 41;
    public static final int ATOMIC_I64_RMW16_U_SUB = 42;
    public static final int ATOMIC_I64_RMW32_U_SUB = 43;
    public static final int ATOMIC_I32_RMW_AND = 44;
    public static final int ATOMIC_I64_RMW_AND = 45;
    public static final int ATOMIC_I32_RMW8_U_AND = 46;
    public static final int ATOMIC_I32_RMW16_U_AND = 47;
    public static final int ATOMIC_I64_RMW8_U_AND = 48;
    public static final int ATOMIC_I64_RMW16_U_AND = 49;
    public static final int ATOMIC_I64_RMW32_U_AND = 50;
    public static final int ATOMIC_I32_RMW_OR = 51;
    public static final int ATOMIC_I64_RMW_OR = 52;
    public static final int ATOMIC_I32_RMW8_U_OR = 53;
    public static final int ATOMIC_I32_RMW16_U_OR = 54;
    public static final int ATOMIC_I64_RMW8_U_OR = 55;
    public static final int ATOMIC_I64_RMW16_U_OR = 56;
    public static final int ATOMIC_I64_RMW32_U_OR = 57;
    public static final int ATOMIC_I32_RMW_XOR = 58;
    public static final int ATOMIC_I64_RMW_XOR = 59;
    public static final int ATOMIC_I32_RMW8_U_XOR = 60;
    public static final int ATOMIC_I32_RMW16_U_XOR = 61;
    public static final int ATOMIC_I64_RMW8_U_XOR = 62;
    public static final int ATOMIC_I64_RMW16_U_XOR = 63;
    public static final int ATOMIC_I64_RMW32_U_XOR = 64;
    public static final int ATOMIC_I32_RMW_XCHG = 65;
    public static final int ATOMIC_I64_RMW_XCHG = 66;
    public static final int ATOMIC_I32_RMW8_U_XCHG = 67;
    public static final int ATOMIC_I32_RMW16_U_XCHG = 68;
    public static final int ATOMIC_I64_RMW8_U_XCHG = 69;
    public static final int ATOMIC_I64_RMW16_U_XCHG = 70;
    public static final int ATOMIC_I64_RMW32_U_XCHG = 71;
    public static final int ATOMIC_I32_RMW_CMPXCHG = 72;
    public static final int ATOMIC_I64_RMW_CMPXCHG = 73;
    public static final int ATOMIC_I32_RMW8_U_CMPXCHG = 74;
    public static final int ATOMIC_I32_RMW16_U_CMPXCHG = 75;
    public static final int ATOMIC_I64_RMW8_U_CMPXCHG = 76;
    public static final int ATOMIC_I64_RMW16_U_CMPXCHG = 77;
    public static final int ATOMIC_I64_RMW32_U_CMPXCHG = 78;
    public static final int VECTOR = 253;
    public static final int VECTOR_V128_LOAD = 0;
    public static final int VECTOR_V128_LOAD8X8_S = 1;
    public static final int VECTOR_V128_LOAD8X8_U = 2;
    public static final int VECTOR_V128_LOAD16X4_S = 3;
    public static final int VECTOR_V128_LOAD16X4_U = 4;
    public static final int VECTOR_V128_LOAD32X2_S = 5;
    public static final int VECTOR_V128_LOAD32X2_U = 6;
    public static final int VECTOR_V128_LOAD8_SPLAT = 7;
    public static final int VECTOR_V128_LOAD16_SPLAT = 8;
    public static final int VECTOR_V128_LOAD32_SPLAT = 9;
    public static final int VECTOR_V128_LOAD64_SPLAT = 10;
    public static final int VECTOR_V128_LOAD32_ZERO = 92;
    public static final int VECTOR_V128_LOAD64_ZERO = 93;
    public static final int VECTOR_V128_STORE = 11;
    public static final int VECTOR_V128_LOAD8_LANE = 84;
    public static final int VECTOR_V128_LOAD16_LANE = 85;
    public static final int VECTOR_V128_LOAD32_LANE = 86;
    public static final int VECTOR_V128_LOAD64_LANE = 87;
    public static final int VECTOR_V128_STORE8_LANE = 88;
    public static final int VECTOR_V128_STORE16_LANE = 89;
    public static final int VECTOR_V128_STORE32_LANE = 90;
    public static final int VECTOR_V128_STORE64_LANE = 91;
    public static final int VECTOR_V128_CONST = 12;
    public static final int VECTOR_I8X16_SHUFFLE = 13;
    public static final int VECTOR_I8X16_EXTRACT_LANE_S = 21;
    public static final int VECTOR_I8X16_EXTRACT_LANE_U = 22;
    public static final int VECTOR_I8X16_REPLACE_LANE = 23;
    public static final int VECTOR_I16X8_EXTRACT_LANE_S = 24;
    public static final int VECTOR_I16X8_EXTRACT_LANE_U = 25;
    public static final int VECTOR_I16X8_REPLACE_LANE = 26;
    public static final int VECTOR_I32X4_EXTRACT_LANE = 27;
    public static final int VECTOR_I32X4_REPLACE_LANE = 28;
    public static final int VECTOR_I64X2_EXTRACT_LANE = 29;
    public static final int VECTOR_I64X2_REPLACE_LANE = 30;
    public static final int VECTOR_F32X4_EXTRACT_LANE = 31;
    public static final int VECTOR_F32X4_REPLACE_LANE = 32;
    public static final int VECTOR_F64X2_EXTRACT_LANE = 33;
    public static final int VECTOR_F64X2_REPLACE_LANE = 34;
    public static final int VECTOR_I8X16_SWIZZLE = 14;
    public static final int VECTOR_I8X16_SPLAT = 15;
    public static final int VECTOR_I16X8_SPLAT = 16;
    public static final int VECTOR_I32X4_SPLAT = 17;
    public static final int VECTOR_I64X2_SPLAT = 18;
    public static final int VECTOR_F32X4_SPLAT = 19;
    public static final int VECTOR_F64X2_SPLAT = 20;
    public static final int VECTOR_I8X16_EQ = 35;
    public static final int VECTOR_I8X16_NE = 36;
    public static final int VECTOR_I8X16_LT_S = 37;
    public static final int VECTOR_I8X16_LT_U = 38;
    public static final int VECTOR_I8X16_GT_S = 39;
    public static final int VECTOR_I8X16_GT_U = 40;
    public static final int VECTOR_I8X16_LE_S = 41;
    public static final int VECTOR_I8X16_LE_U = 42;
    public static final int VECTOR_I8X16_GE_S = 43;
    public static final int VECTOR_I8X16_GE_U = 44;
    public static final int VECTOR_I16X8_EQ = 45;
    public static final int VECTOR_I16X8_NE = 46;
    public static final int VECTOR_I16X8_LT_S = 47;
    public static final int VECTOR_I16X8_LT_U = 48;
    public static final int VECTOR_I16X8_GT_S = 49;
    public static final int VECTOR_I16X8_GT_U = 50;
    public static final int VECTOR_I16X8_LE_S = 51;
    public static final int VECTOR_I16X8_LE_U = 52;
    public static final int VECTOR_I16X8_GE_S = 53;
    public static final int VECTOR_I16X8_GE_U = 54;
    public static final int VECTOR_I32X4_EQ = 55;
    public static final int VECTOR_I32X4_NE = 56;
    public static final int VECTOR_I32X4_LT_S = 57;
    public static final int VECTOR_I32X4_LT_U = 58;
    public static final int VECTOR_I32X4_GT_S = 59;
    public static final int VECTOR_I32X4_GT_U = 60;
    public static final int VECTOR_I32X4_LE_S = 61;
    public static final int VECTOR_I32X4_LE_U = 62;
    public static final int VECTOR_I32X4_GE_S = 63;
    public static final int VECTOR_I32X4_GE_U = 64;
    public static final int VECTOR_I64X2_EQ = 214;
    public static final int VECTOR_I64X2_NE = 215;
    public static final int VECTOR_I64X2_LT_S = 216;
    public static final int VECTOR_I64X2_GT_S = 217;
    public static final int VECTOR_I64X2_LE_S = 218;
    public static final int VECTOR_I64X2_GE_S = 219;
    public static final int VECTOR_F32X4_EQ = 65;
    public static final int VECTOR_F32X4_NE = 66;
    public static final int VECTOR_F32X4_LT = 67;
    public static final int VECTOR_F32X4_GT = 68;
    public static final int VECTOR_F32X4_LE = 69;
    public static final int VECTOR_F32X4_GE = 70;
    public static final int VECTOR_F64X2_EQ = 71;
    public static final int VECTOR_F64X2_NE = 72;
    public static final int VECTOR_F64X2_LT = 73;
    public static final int VECTOR_F64X2_GT = 74;
    public static final int VECTOR_F64X2_LE = 75;
    public static final int VECTOR_F64X2_GE = 76;
    public static final int VECTOR_V128_NOT = 77;
    public static final int VECTOR_V128_AND = 78;
    public static final int VECTOR_V128_ANDNOT = 79;
    public static final int VECTOR_V128_OR = 80;
    public static final int VECTOR_V128_XOR = 81;
    public static final int VECTOR_V128_BITSELECT = 82;
    public static final int VECTOR_V128_ANY_TRUE = 83;
    public static final int VECTOR_I8X16_ABS = 96;
    public static final int VECTOR_I8X16_NEG = 97;
    public static final int VECTOR_I8X16_POPCNT = 98;
    public static final int VECTOR_I8X16_ALL_TRUE = 99;
    public static final int VECTOR_I8X16_BITMASK = 100;
    public static final int VECTOR_I8X16_NARROW_I16X8_S = 101;
    public static final int VECTOR_I8X16_NARROW_I16X8_U = 102;
    public static final int VECTOR_I8X16_SHL = 107;
    public static final int VECTOR_I8X16_SHR_S = 108;
    public static final int VECTOR_I8X16_SHR_U = 109;
    public static final int VECTOR_I8X16_ADD = 110;
    public static final int VECTOR_I8X16_ADD_SAT_S = 111;
    public static final int VECTOR_I8X16_ADD_SAT_U = 112;
    public static final int VECTOR_I8X16_SUB = 113;
    public static final int VECTOR_I8X16_SUB_SAT_S = 114;
    public static final int VECTOR_I8X16_SUB_SAT_U = 115;
    public static final int VECTOR_I8X16_MIN_S = 118;
    public static final int VECTOR_I8X16_MIN_U = 119;
    public static final int VECTOR_I8X16_MAX_S = 120;
    public static final int VECTOR_I8X16_MAX_U = 121;
    public static final int VECTOR_I8X16_AVGR_U = 123;
    public static final int VECTOR_I16X8_EXTADD_PAIRWISE_I8X16_S = 124;
    public static final int VECTOR_I16X8_EXTADD_PAIRWISE_I8X16_U = 125;
    public static final int VECTOR_I16X8_ABS = 128;
    public static final int VECTOR_I16X8_NEG = 129;
    public static final int VECTOR_I16X8_Q15MULR_SAT_S = 130;
    public static final int VECTOR_I16X8_ALL_TRUE = 131;
    public static final int VECTOR_I16X8_BITMASK = 132;
    public static final int VECTOR_I16X8_NARROW_I32X4_S = 133;
    public static final int VECTOR_I16X8_NARROW_I32X4_U = 134;
    public static final int VECTOR_I16X8_EXTEND_LOW_I8X16_S = 135;
    public static final int VECTOR_I16X8_EXTEND_HIGH_I8X16_S = 136;
    public static final int VECTOR_I16X8_EXTEND_LOW_I8X16_U = 137;
    public static final int VECTOR_I16X8_EXTEND_HIGH_I8X16_U = 138;
    public static final int VECTOR_I16X8_SHL = 139;
    public static final int VECTOR_I16X8_SHR_S = 140;
    public static final int VECTOR_I16X8_SHR_U = 141;
    public static final int VECTOR_I16X8_ADD = 142;
    public static final int VECTOR_I16X8_ADD_SAT_S = 143;
    public static final int VECTOR_I16X8_ADD_SAT_U = 144;
    public static final int VECTOR_I16X8_SUB = 145;
    public static final int VECTOR_I16X8_SUB_SAT_S = 146;
    public static final int VECTOR_I16X8_SUB_SAT_U = 147;
    public static final int VECTOR_I16X8_MUL = 149;
    public static final int VECTOR_I16X8_MIN_S = 150;
    public static final int VECTOR_I16X8_MIN_U = 151;
    public static final int VECTOR_I16X8_MAX_S = 152;
    public static final int VECTOR_I16X8_MAX_U = 153;
    public static final int VECTOR_I16X8_AVGR_U = 155;
    public static final int VECTOR_I16X8_EXTMUL_LOW_I8X16_S = 156;
    public static final int VECTOR_I16X8_EXTMUL_HIGH_I8X16_S = 157;
    public static final int VECTOR_I16X8_EXTMUL_LOW_I8X16_U = 158;
    public static final int VECTOR_I16X8_EXTMUL_HIGH_I8X16_U = 159;
    public static final int VECTOR_I32X4_EXTADD_PAIRWISE_I16X8_S = 126;
    public static final int VECTOR_I32X4_EXTADD_PAIRWISE_I16X8_U = 127;
    public static final int VECTOR_I32X4_ABS = 160;
    public static final int VECTOR_I32X4_NEG = 161;
    public static final int VECTOR_I32X4_ALL_TRUE = 163;
    public static final int VECTOR_I32X4_BITMASK = 164;
    public static final int VECTOR_I32X4_EXTEND_LOW_I16X8_S = 167;
    public static final int VECTOR_I32X4_EXTEND_HIGH_I16X8_S = 168;
    public static final int VECTOR_I32X4_EXTEND_LOW_I16X8_U = 169;
    public static final int VECTOR_I32X4_EXTEND_HIGH_I16X8_U = 170;
    public static final int VECTOR_I32X4_SHL = 171;
    public static final int VECTOR_I32X4_SHR_S = 172;
    public static final int VECTOR_I32X4_SHR_U = 173;
    public static final int VECTOR_I32X4_ADD = 174;
    public static final int VECTOR_I32X4_SUB = 177;
    public static final int VECTOR_I32X4_MUL = 181;
    public static final int VECTOR_I32X4_MIN_S = 182;
    public static final int VECTOR_I32X4_MIN_U = 183;
    public static final int VECTOR_I32X4_MAX_S = 184;
    public static final int VECTOR_I32X4_MAX_U = 185;
    public static final int VECTOR_I32X4_DOT_I16X8_S = 186;
    public static final int VECTOR_I32X4_EXTMUL_LOW_I16X8_S = 188;
    public static final int VECTOR_I32X4_EXTMUL_HIGH_I16X8_S = 189;
    public static final int VECTOR_I32X4_EXTMUL_LOW_I16X8_U = 190;
    public static final int VECTOR_I32X4_EXTMUL_HIGH_I16X8_U = 191;
    public static final int VECTOR_I64X2_ABS = 192;
    public static final int VECTOR_I64X2_NEG = 193;
    public static final int VECTOR_I64X2_ALL_TRUE = 195;
    public static final int VECTOR_I64X2_BITMASK = 196;
    public static final int VECTOR_I64X2_EXTEND_LOW_I32X4_S = 199;
    public static final int VECTOR_I64X2_EXTEND_HIGH_I32X4_S = 200;
    public static final int VECTOR_I64X2_EXTEND_LOW_I32X4_U = 201;
    public static final int VECTOR_I64X2_EXTEND_HIGH_I32X4_U = 202;
    public static final int VECTOR_I64X2_SHL = 203;
    public static final int VECTOR_I64X2_SHR_S = 204;
    public static final int VECTOR_I64X2_SHR_U = 205;
    public static final int VECTOR_I64X2_ADD = 206;
    public static final int VECTOR_I64X2_SUB = 209;
    public static final int VECTOR_I64X2_MUL = 213;
    public static final int VECTOR_I64X2_EXTMUL_LOW_I32X4_S = 220;
    public static final int VECTOR_I64X2_EXTMUL_HIGH_I32X4_S = 221;
    public static final int VECTOR_I64X2_EXTMUL_LOW_I32X4_U = 222;
    public static final int VECTOR_I64X2_EXTMUL_HIGH_I32X4_U = 223;
    public static final int VECTOR_F32X4_CEIL = 103;
    public static final int VECTOR_F32X4_FLOOR = 104;
    public static final int VECTOR_F32X4_TRUNC = 105;
    public static final int VECTOR_F32X4_NEAREST = 106;
    public static final int VECTOR_F32X4_ABS = 224;
    public static final int VECTOR_F32X4_NEG = 225;
    public static final int VECTOR_F32X4_SQRT = 227;
    public static final int VECTOR_F32X4_ADD = 228;
    public static final int VECTOR_F32X4_SUB = 229;
    public static final int VECTOR_F32X4_MUL = 230;
    public static final int VECTOR_F32X4_DIV = 231;
    public static final int VECTOR_F32X4_MIN = 232;
    public static final int VECTOR_F32X4_MAX = 233;
    public static final int VECTOR_F32X4_PMIN = 234;
    public static final int VECTOR_F32X4_PMAX = 235;
    public static final int VECTOR_F64X2_CEIL = 116;
    public static final int VECTOR_F64X2_FLOOR = 117;
    public static final int VECTOR_F64X2_TRUNC = 122;
    public static final int VECTOR_F64X2_NEAREST = 148;
    public static final int VECTOR_F64X2_ABS = 236;
    public static final int VECTOR_F64X2_NEG = 237;
    public static final int VECTOR_F64X2_SQRT = 239;
    public static final int VECTOR_F64X2_ADD = 240;
    public static final int VECTOR_F64X2_SUB = 241;
    public static final int VECTOR_F64X2_MUL = 242;
    public static final int VECTOR_F64X2_DIV = 243;
    public static final int VECTOR_F64X2_MIN = 244;
    public static final int VECTOR_F64X2_MAX = 245;
    public static final int VECTOR_F64X2_PMIN = 246;
    public static final int VECTOR_F64X2_PMAX = 247;
    public static final int VECTOR_I32X4_TRUNC_SAT_F32X4_S = 248;
    public static final int VECTOR_I32X4_TRUNC_SAT_F32X4_U = 249;
    public static final int VECTOR_F32X4_CONVERT_I32X4_S = 250;
    public static final int VECTOR_F32X4_CONVERT_I32X4_U = 251;
    public static final int VECTOR_I32X4_TRUNC_SAT_F64X2_S_ZERO = 252;
    public static final int VECTOR_I32X4_TRUNC_SAT_F64X2_U_ZERO = 253;
    public static final int VECTOR_F64X2_CONVERT_LOW_I32X4_S = 254;
    public static final int VECTOR_F64X2_CONVERT_LOW_I32X4_U = 255;
    public static final int VECTOR_F32X4_DEMOTE_F64X2_ZERO = 94;
    public static final int VECTOR_F64X2_PROMOTE_LOW_F32X4 = 95;
    private static String[] decodingTable = new String[256];

    private Instructions() {
    }

    static String rawDecode(byte[] instructions, int offset, int before, int after) {
        StringBuilder result = new StringBuilder();
        for (int i = offset - before; i <= offset + after; ++i) {
            if (i == offset) {
                result.append("-> ");
            } else {
                result.append("   ");
            }
            int opcode = Byte.toUnsignedInt(instructions[i]);
            String representation = decodingTable[opcode];
            result.append(String.format("%03d", opcode)).append(" ").append(representation).append("\n");
        }
        return result.toString();
    }

    static {
        try {
            for (Field f : Instructions.class.getDeclaredFields()) {
                if (!Modifier.isStatic(f.getModifiers()) || !f.getType().isPrimitive()) continue;
                int code = f.getInt(null);
                String representation = f.getName().toLowerCase(Locale.ENGLISH);
                if (representation.startsWith("i32") || representation.startsWith("i64") || representation.startsWith("f32") || representation.startsWith("f64") || representation.startsWith("local") || representation.startsWith("global")) {
                    representation = representation.replaceFirst("_", ".");
                }
                Instructions.decodingTable[code] = representation;
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

