/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.memory;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.memory.ByteArraySupport;
import com.oracle.truffle.api.nodes.Node;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.graalvm.wasm.api.Vector128;
import org.graalvm.wasm.exception.Failure;
import org.graalvm.wasm.exception.WasmException;
import org.graalvm.wasm.memory.WasmMemory;

final class ByteArrayWasmMemory
extends WasmMemory {
    private final WasmByteArrayBuffer byteArrayBuffer = new WasmByteArrayBuffer();

    private ByteArrayWasmMemory(long declaredMinSize, long declaredMaxSize, long initialSize, long maxAllowedSize, boolean indexType64, boolean shared) {
        super(declaredMinSize, declaredMaxSize, initialSize, maxAllowedSize, indexType64, shared);
        this.byteArrayBuffer.allocate(initialSize * 65536L);
    }

    ByteArrayWasmMemory(long declaredMinSize, long declaredMaxSize, long maxAllowedSize, boolean indexType64, boolean shared) {
        this(declaredMinSize, declaredMaxSize, declaredMinSize, maxAllowedSize, indexType64, shared);
    }

    @Override
    public long size() {
        return this.byteArrayBuffer.size();
    }

    @Override
    public long byteSize() {
        return this.byteArrayBuffer.byteSize();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public synchronized long grow(long extraPageSize) {
        long previousSize = this.size();
        if (extraPageSize == 0L) {
            this.invokeGrowCallback();
            return previousSize;
        }
        if (Long.compareUnsigned(extraPageSize, this.maxAllowedSize) <= 0 && Long.compareUnsigned(this.size() + extraPageSize, this.maxAllowedSize) <= 0) {
            long targetByteSize = StrictMath.multiplyExact(StrictMath.addExact(this.size(), extraPageSize), 65536);
            this.byteArrayBuffer.grow(targetByteSize);
            this.currentMinSize = this.size() + extraPageSize;
            this.invokeGrowCallback();
            return previousSize;
        }
        return -1L;
    }

    @Override
    public void reset() {
        this.byteArrayBuffer.reset(this.declaredMinSize * 65536L);
        this.currentMinSize = this.declaredMinSize;
    }

    @Override
    public int load_i32(Node node, long address) {
        try {
            return ByteArraySupport.littleEndian().getInt(this.byteArrayBuffer.buffer(), address);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 4);
        }
    }

    @Override
    public long load_i64(Node node, long address) {
        try {
            return ByteArraySupport.littleEndian().getLong(this.byteArrayBuffer.buffer(), address);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 8);
        }
    }

    @Override
    public float load_f32(Node node, long address) {
        try {
            return ByteArraySupport.littleEndian().getFloat(this.byteArrayBuffer.buffer(), address);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 4);
        }
    }

    @Override
    public double load_f64(Node node, long address) {
        try {
            return ByteArraySupport.littleEndian().getDouble(this.byteArrayBuffer.buffer(), address);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 8);
        }
    }

    @Override
    public int load_i32_8s(Node node, long address) {
        try {
            return ByteArraySupport.littleEndian().getByte(this.byteArrayBuffer.buffer(), address);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 1);
        }
    }

    @Override
    public int load_i32_8u(Node node, long address) {
        try {
            return 0xFF & ByteArraySupport.littleEndian().getByte(this.byteArrayBuffer.buffer(), address);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 1);
        }
    }

    @Override
    public int load_i32_16s(Node node, long address) {
        try {
            return ByteArraySupport.littleEndian().getShort(this.byteArrayBuffer.buffer(), address);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 2);
        }
    }

    @Override
    public int load_i32_16u(Node node, long address) {
        try {
            return 0xFFFF & ByteArraySupport.littleEndian().getShort(this.byteArrayBuffer.buffer(), address);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 2);
        }
    }

    @Override
    public long load_i64_8s(Node node, long address) {
        try {
            return ByteArraySupport.littleEndian().getByte(this.byteArrayBuffer.buffer(), address);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 1);
        }
    }

    @Override
    public long load_i64_8u(Node node, long address) {
        try {
            return 0xFFL & (long)ByteArraySupport.littleEndian().getByte(this.byteArrayBuffer.buffer(), address);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 1);
        }
    }

    @Override
    public long load_i64_16s(Node node, long address) {
        try {
            return ByteArraySupport.littleEndian().getShort(this.byteArrayBuffer.buffer(), address);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 2);
        }
    }

    @Override
    public long load_i64_16u(Node node, long address) {
        try {
            return 0xFFFFL & (long)ByteArraySupport.littleEndian().getShort(this.byteArrayBuffer.buffer(), address);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 2);
        }
    }

    @Override
    public long load_i64_32s(Node node, long address) {
        try {
            return ByteArraySupport.littleEndian().getInt(this.byteArrayBuffer.buffer(), address);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 4);
        }
    }

    @Override
    public long load_i64_32u(Node node, long address) {
        try {
            return 0xFFFFFFFFL & (long)ByteArraySupport.littleEndian().getInt(this.byteArrayBuffer.buffer(), address);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 4);
        }
    }

    @Override
    public Vector128 load_i128(Node node, long address) {
        if (ByteArraySupport.littleEndian().inBounds(this.byteArrayBuffer.buffer(), address, 16L)) {
            return new Vector128(Arrays.copyOfRange(this.byteArrayBuffer.buffer(), (int)address, (int)address + 16));
        }
        throw this.trapOutOfBounds(node, address, 16);
    }

    @Override
    public void store_i32(Node node, long address, int value) {
        try {
            ByteArraySupport.littleEndian().putInt(this.byteArrayBuffer.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 4);
        }
    }

    @Override
    public void store_i64(Node node, long address, long value) {
        try {
            ByteArraySupport.littleEndian().putLong(this.byteArrayBuffer.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 8);
        }
    }

    @Override
    public void store_f32(Node node, long address, float value) {
        try {
            ByteArraySupport.littleEndian().putFloat(this.byteArrayBuffer.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 4);
        }
    }

    @Override
    public void store_f64(Node node, long address, double value) {
        try {
            ByteArraySupport.littleEndian().putDouble(this.byteArrayBuffer.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 8);
        }
    }

    @Override
    public void store_i32_8(Node node, long address, byte value) {
        try {
            ByteArraySupport.littleEndian().putByte(this.byteArrayBuffer.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 1);
        }
    }

    @Override
    public void store_i32_16(Node node, long address, short value) {
        try {
            ByteArraySupport.littleEndian().putShort(this.byteArrayBuffer.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 2);
        }
    }

    @Override
    public void store_i64_8(Node node, long address, byte value) {
        try {
            ByteArraySupport.littleEndian().putByte(this.byteArrayBuffer.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 1);
        }
    }

    @Override
    public void store_i64_16(Node node, long address, short value) {
        try {
            ByteArraySupport.littleEndian().putShort(this.byteArrayBuffer.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 2);
        }
    }

    @Override
    public void store_i64_32(Node node, long address, int value) {
        try {
            ByteArraySupport.littleEndian().putInt(this.byteArrayBuffer.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 4);
        }
    }

    @Override
    public void store_i128(Node node, long address, Vector128 value) {
        if (!ByteArraySupport.littleEndian().inBounds(this.byteArrayBuffer.buffer(), address, 16L)) {
            throw this.trapOutOfBounds(node, address, 16);
        }
        System.arraycopy(value.getBytes(), 0, this.byteArrayBuffer.buffer(), (int)address, 16);
    }

    private static void validateAtomicAddress(Node node, long address, int length) {
        if ((address & (long)(length - 1)) != 0L) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw ByteArrayWasmMemory.trapUnalignedAtomic(node, address, length);
        }
    }

    @Override
    public int atomic_load_i32(Node node, long address) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 4);
        try {
            return ByteArraySupport.littleEndian().getIntVolatile(this.byteArrayBuffer.buffer(), address);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 4);
        }
    }

    @Override
    public long atomic_load_i64(Node node, long address) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 8);
        try {
            return ByteArraySupport.littleEndian().getLongVolatile(this.byteArrayBuffer.buffer(), address);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 8);
        }
    }

    @Override
    public int atomic_load_i32_8u(Node node, long address) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 1);
        try {
            return 0xFF & ByteArraySupport.littleEndian().getByteVolatile(this.byteArrayBuffer.buffer(), address);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 1);
        }
    }

    @Override
    public int atomic_load_i32_16u(Node node, long address) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 2);
        try {
            return 0xFFFF & ByteArraySupport.littleEndian().getShortVolatile(this.byteArrayBuffer.buffer(), address);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 2);
        }
    }

    @Override
    public long atomic_load_i64_8u(Node node, long address) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 1);
        try {
            return 0xFFL & (long)ByteArraySupport.littleEndian().getByteVolatile(this.byteArrayBuffer.buffer(), address);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 1);
        }
    }

    @Override
    public long atomic_load_i64_16u(Node node, long address) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 2);
        try {
            return 0xFFFFL & (long)ByteArraySupport.littleEndian().getShortVolatile(this.byteArrayBuffer.buffer(), address);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 2);
        }
    }

    @Override
    public long atomic_load_i64_32u(Node node, long address) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 4);
        try {
            return 0xFFFFFFFFL & (long)ByteArraySupport.littleEndian().getIntVolatile(this.byteArrayBuffer.buffer(), address);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 4);
        }
    }

    @Override
    public void atomic_store_i32(Node node, long address, int value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 4);
        try {
            ByteArraySupport.littleEndian().putIntVolatile(this.byteArrayBuffer.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 4);
        }
    }

    @Override
    public void atomic_store_i64(Node node, long address, long value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 8);
        try {
            ByteArraySupport.littleEndian().putLongVolatile(this.byteArrayBuffer.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 8);
        }
    }

    @Override
    public void atomic_store_i32_8(Node node, long address, byte value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 1);
        try {
            ByteArraySupport.littleEndian().putByteVolatile(this.byteArrayBuffer.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 1);
        }
    }

    @Override
    public void atomic_store_i32_16(Node node, long address, short value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 2);
        try {
            ByteArraySupport.littleEndian().putShortVolatile(this.byteArrayBuffer.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 2);
        }
    }

    @Override
    public void atomic_store_i64_8(Node node, long address, byte value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 1);
        try {
            ByteArraySupport.littleEndian().putByteVolatile(this.byteArrayBuffer.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 1);
        }
    }

    @Override
    public void atomic_store_i64_16(Node node, long address, short value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 2);
        try {
            ByteArraySupport.littleEndian().putShortVolatile(this.byteArrayBuffer.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 2);
        }
    }

    @Override
    public void atomic_store_i64_32(Node node, long address, int value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 4);
        try {
            ByteArraySupport.littleEndian().putIntVolatile(this.byteArrayBuffer.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 4);
        }
    }

    @Override
    public int atomic_rmw_add_i32_8u(Node node, long address, byte value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 1);
        try {
            return 0xFF & ByteArraySupport.littleEndian().getAndAddByte(this.byteArrayBuffer.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 1);
        }
    }

    @Override
    public int atomic_rmw_add_i32_16u(Node node, long address, short value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 2);
        try {
            return 0xFFFF & ByteArraySupport.littleEndian().getAndAddShort(this.byteArrayBuffer.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 2);
        }
    }

    @Override
    public int atomic_rmw_add_i32(Node node, long address, int value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 4);
        try {
            return ByteArraySupport.littleEndian().getAndAddInt(this.byteArrayBuffer.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 4);
        }
    }

    @Override
    public long atomic_rmw_add_i64_8u(Node node, long address, byte value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 1);
        try {
            return 0xFFL & (long)ByteArraySupport.littleEndian().getAndAddByte(this.byteArrayBuffer.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 1);
        }
    }

    @Override
    public long atomic_rmw_add_i64_16u(Node node, long address, short value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 2);
        try {
            return 0xFFFFL & (long)ByteArraySupport.littleEndian().getAndAddShort(this.byteArrayBuffer.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 2);
        }
    }

    @Override
    public long atomic_rmw_add_i64_32u(Node node, long address, int value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 4);
        try {
            return 0xFFFFFFFFL & (long)ByteArraySupport.littleEndian().getAndAddInt(this.byteArrayBuffer.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 4);
        }
    }

    @Override
    public long atomic_rmw_add_i64(Node node, long address, long value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 8);
        try {
            return ByteArraySupport.littleEndian().getAndAddLong(this.byteArrayBuffer.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 8);
        }
    }

    @Override
    public int atomic_rmw_sub_i32_8u(Node node, long address, byte value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 1);
        try {
            return 0xFF & ByteArraySupport.littleEndian().getAndAddByte(this.byteArrayBuffer.buffer(), address, -value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 1);
        }
    }

    @Override
    public int atomic_rmw_sub_i32_16u(Node node, long address, short value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 2);
        try {
            return 0xFFFF & ByteArraySupport.littleEndian().getAndAddShort(this.byteArrayBuffer.buffer(), address, -value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 2);
        }
    }

    @Override
    public int atomic_rmw_sub_i32(Node node, long address, int value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 4);
        try {
            return ByteArraySupport.littleEndian().getAndAddInt(this.byteArrayBuffer.buffer(), address, -value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 4);
        }
    }

    @Override
    public long atomic_rmw_sub_i64_8u(Node node, long address, byte value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 1);
        try {
            return 0xFFL & (long)ByteArraySupport.littleEndian().getAndAddByte(this.byteArrayBuffer.buffer(), address, -value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 1);
        }
    }

    @Override
    public long atomic_rmw_sub_i64_16u(Node node, long address, short value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 2);
        try {
            return 0xFFFFL & (long)ByteArraySupport.littleEndian().getAndAddShort(this.byteArrayBuffer.buffer(), address, -value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 2);
        }
    }

    @Override
    public long atomic_rmw_sub_i64_32u(Node node, long address, int value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 4);
        try {
            return 0xFFFFFFFFL & (long)ByteArraySupport.littleEndian().getAndAddInt(this.byteArrayBuffer.buffer(), address, -value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 4);
        }
    }

    @Override
    public long atomic_rmw_sub_i64(Node node, long address, long value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 8);
        try {
            return ByteArraySupport.littleEndian().getAndAddLong(this.byteArrayBuffer.buffer(), address, -value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 8);
        }
    }

    @Override
    public int atomic_rmw_and_i32_8u(Node node, long address, byte value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 1);
        try {
            return 0xFF & ByteArraySupport.littleEndian().getAndBitwiseAndByte(this.byteArrayBuffer.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 1);
        }
    }

    @Override
    public int atomic_rmw_and_i32_16u(Node node, long address, short value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 2);
        try {
            return 0xFFFF & ByteArraySupport.littleEndian().getAndBitwiseAndShort(this.byteArrayBuffer.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 2);
        }
    }

    @Override
    public int atomic_rmw_and_i32(Node node, long address, int value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 4);
        try {
            return ByteArraySupport.littleEndian().getAndBitwiseAndInt(this.byteArrayBuffer.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 4);
        }
    }

    @Override
    public long atomic_rmw_and_i64_8u(Node node, long address, byte value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 1);
        try {
            return 0xFFL & (long)ByteArraySupport.littleEndian().getAndBitwiseAndByte(this.byteArrayBuffer.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 1);
        }
    }

    @Override
    public long atomic_rmw_and_i64_16u(Node node, long address, short value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 2);
        try {
            return 0xFFFFL & (long)ByteArraySupport.littleEndian().getAndBitwiseAndShort(this.byteArrayBuffer.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 2);
        }
    }

    @Override
    public long atomic_rmw_and_i64_32u(Node node, long address, int value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 4);
        try {
            return 0xFFFFFFFFL & (long)ByteArraySupport.littleEndian().getAndBitwiseAndInt(this.byteArrayBuffer.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 4);
        }
    }

    @Override
    public long atomic_rmw_and_i64(Node node, long address, long value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 8);
        try {
            return ByteArraySupport.littleEndian().getAndBitwiseAndLong(this.byteArrayBuffer.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 8);
        }
    }

    @Override
    public int atomic_rmw_or_i32_8u(Node node, long address, byte value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 1);
        try {
            return 0xFF & ByteArraySupport.littleEndian().getAndBitwiseOrByte(this.byteArrayBuffer.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 1);
        }
    }

    @Override
    public int atomic_rmw_or_i32_16u(Node node, long address, short value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 2);
        try {
            return 0xFFFF & ByteArraySupport.littleEndian().getAndBitwiseOrShort(this.byteArrayBuffer.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 2);
        }
    }

    @Override
    public int atomic_rmw_or_i32(Node node, long address, int value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 4);
        try {
            return ByteArraySupport.littleEndian().getAndBitwiseOrInt(this.byteArrayBuffer.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 4);
        }
    }

    @Override
    public long atomic_rmw_or_i64_8u(Node node, long address, byte value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 1);
        try {
            return 0xFFL & (long)ByteArraySupport.littleEndian().getAndBitwiseOrByte(this.byteArrayBuffer.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 1);
        }
    }

    @Override
    public long atomic_rmw_or_i64_16u(Node node, long address, short value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 2);
        try {
            return 0xFFFFL & (long)ByteArraySupport.littleEndian().getAndBitwiseOrShort(this.byteArrayBuffer.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 2);
        }
    }

    @Override
    public long atomic_rmw_or_i64_32u(Node node, long address, int value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 4);
        try {
            return 0xFFFFFFFFL & (long)ByteArraySupport.littleEndian().getAndBitwiseOrInt(this.byteArrayBuffer.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 4);
        }
    }

    @Override
    public long atomic_rmw_or_i64(Node node, long address, long value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 8);
        try {
            return ByteArraySupport.littleEndian().getAndBitwiseOrLong(this.byteArrayBuffer.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 8);
        }
    }

    @Override
    public int atomic_rmw_xor_i32_8u(Node node, long address, byte value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 1);
        try {
            return 0xFF & ByteArraySupport.littleEndian().getAndBitwiseXorByte(this.byteArrayBuffer.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 1);
        }
    }

    @Override
    public int atomic_rmw_xor_i32_16u(Node node, long address, short value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 2);
        try {
            return 0xFFFF & ByteArraySupport.littleEndian().getAndBitwiseXorShort(this.byteArrayBuffer.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 2);
        }
    }

    @Override
    public int atomic_rmw_xor_i32(Node node, long address, int value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 4);
        try {
            return ByteArraySupport.littleEndian().getAndBitwiseXorInt(this.byteArrayBuffer.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 4);
        }
    }

    @Override
    public long atomic_rmw_xor_i64_8u(Node node, long address, byte value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 1);
        try {
            return 0xFFL & (long)ByteArraySupport.littleEndian().getAndBitwiseXorByte(this.byteArrayBuffer.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 1);
        }
    }

    @Override
    public long atomic_rmw_xor_i64_16u(Node node, long address, short value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 2);
        try {
            return 0xFFFFL & (long)ByteArraySupport.littleEndian().getAndBitwiseXorShort(this.byteArrayBuffer.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 2);
        }
    }

    @Override
    public long atomic_rmw_xor_i64_32u(Node node, long address, int value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 4);
        try {
            return 0xFFFFFFFFL & (long)ByteArraySupport.littleEndian().getAndBitwiseXorInt(this.byteArrayBuffer.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 4);
        }
    }

    @Override
    public long atomic_rmw_xor_i64(Node node, long address, long value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 8);
        try {
            return ByteArraySupport.littleEndian().getAndBitwiseXorLong(this.byteArrayBuffer.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 8);
        }
    }

    @Override
    public int atomic_rmw_xchg_i32_8u(Node node, long address, byte value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 1);
        try {
            return 0xFF & ByteArraySupport.littleEndian().getAndSetByte(this.byteArrayBuffer.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 1);
        }
    }

    @Override
    public int atomic_rmw_xchg_i32_16u(Node node, long address, short value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 2);
        try {
            return 0xFFFF & ByteArraySupport.littleEndian().getAndSetShort(this.byteArrayBuffer.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 2);
        }
    }

    @Override
    public int atomic_rmw_xchg_i32(Node node, long address, int value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 4);
        try {
            return ByteArraySupport.littleEndian().getAndSetInt(this.byteArrayBuffer.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 4);
        }
    }

    @Override
    public long atomic_rmw_xchg_i64_8u(Node node, long address, byte value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 1);
        try {
            return 0xFFL & (long)ByteArraySupport.littleEndian().getAndSetByte(this.byteArrayBuffer.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 1);
        }
    }

    @Override
    public long atomic_rmw_xchg_i64_16u(Node node, long address, short value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 2);
        try {
            return 0xFFFFL & (long)ByteArraySupport.littleEndian().getAndSetShort(this.byteArrayBuffer.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 2);
        }
    }

    @Override
    public long atomic_rmw_xchg_i64_32u(Node node, long address, int value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 4);
        try {
            return 0xFFFFFFFFL & (long)ByteArraySupport.littleEndian().getAndSetInt(this.byteArrayBuffer.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 4);
        }
    }

    @Override
    public long atomic_rmw_xchg_i64(Node node, long address, long value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 8);
        try {
            return ByteArraySupport.littleEndian().getAndSetLong(this.byteArrayBuffer.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 8);
        }
    }

    @Override
    public int atomic_rmw_cmpxchg_i32_8u(Node node, long address, byte expected, byte replacement) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 1);
        try {
            return 0xFF & ByteArraySupport.littleEndian().compareAndExchangeByte(this.byteArrayBuffer.buffer(), address, expected, replacement);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 1);
        }
    }

    @Override
    public int atomic_rmw_cmpxchg_i32_16u(Node node, long address, short expected, short replacement) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 2);
        try {
            return 0xFFFF & ByteArraySupport.littleEndian().compareAndExchangeShort(this.byteArrayBuffer.buffer(), address, expected, replacement);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 2);
        }
    }

    @Override
    public int atomic_rmw_cmpxchg_i32(Node node, long address, int expected, int replacement) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 4);
        try {
            return ByteArraySupport.littleEndian().compareAndExchangeInt(this.byteArrayBuffer.buffer(), address, expected, replacement);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 4);
        }
    }

    @Override
    public long atomic_rmw_cmpxchg_i64_8u(Node node, long address, byte expected, byte replacement) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 1);
        try {
            return 0xFFL & (long)ByteArraySupport.littleEndian().compareAndExchangeByte(this.byteArrayBuffer.buffer(), address, expected, replacement);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 1);
        }
    }

    @Override
    public long atomic_rmw_cmpxchg_i64_16u(Node node, long address, short expected, short replacement) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 2);
        try {
            return 0xFFFFL & (long)ByteArraySupport.littleEndian().compareAndExchangeShort(this.byteArrayBuffer.buffer(), address, expected, replacement);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 2);
        }
    }

    @Override
    public long atomic_rmw_cmpxchg_i64_32u(Node node, long address, int expected, int replacement) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 4);
        try {
            return 0xFFFFFFFFL & (long)ByteArraySupport.littleEndian().compareAndExchangeInt(this.byteArrayBuffer.buffer(), address, expected, replacement);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 4);
        }
    }

    @Override
    public long atomic_rmw_cmpxchg_i64(Node node, long address, long expected, long replacement) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 8);
        try {
            return ByteArraySupport.littleEndian().compareAndExchangeLong(this.byteArrayBuffer.buffer(), address, expected, replacement);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 8);
        }
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public int atomic_notify(Node node, long address, int count) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 4);
        if (this.outOfBounds(address, 4L)) {
            throw this.trapOutOfBounds(node, address, 4);
        }
        if (!this.isShared()) {
            return 0;
        }
        return this.invokeNotifyCallback(node, address, count);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public int atomic_wait32(Node node, long address, int expected, long timeout) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 4);
        if (this.outOfBounds(address, 4L)) {
            throw this.trapOutOfBounds(node, address, 4);
        }
        if (!this.isShared()) {
            throw this.trapUnsharedMemory(node);
        }
        return this.invokeWaitCallback(node, address, expected, timeout, false);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public int atomic_wait64(Node node, long address, long expected, long timeout) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 8);
        if (this.outOfBounds(address, 8L)) {
            throw this.trapOutOfBounds(node, address, 8);
        }
        if (!this.isShared()) {
            throw this.trapUnsharedMemory(node);
        }
        return this.invokeWaitCallback(node, address, expected, timeout, true);
    }

    @Override
    public void initialize(byte[] source, int sourceOffset, long destinationOffset, int length) {
        assert (destinationOffset + (long)length <= this.byteSize());
        System.arraycopy(source, sourceOffset, this.byteArrayBuffer.buffer(), (int)destinationOffset, length);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public void fill(long offset, long length, byte value) {
        assert (offset + length <= this.byteSize());
        Arrays.fill(this.byteArrayBuffer.buffer(), (int)offset, (int)(offset + length), value);
    }

    @Override
    public void copyFrom(WasmMemory source, long sourceOffset, long destinationOffset, long length) {
        assert (source instanceof ByteArrayWasmMemory);
        assert (destinationOffset < this.byteSize());
        ByteArrayWasmMemory s = (ByteArrayWasmMemory)source;
        System.arraycopy(s.byteArrayBuffer.buffer(), (int)sourceOffset, this.byteArrayBuffer.buffer(), (int)destinationOffset, (int)length);
    }

    @Override
    public WasmMemory duplicate() {
        ByteArrayWasmMemory other = new ByteArrayWasmMemory(this.declaredMinSize, this.declaredMaxSize, this.size(), this.maxAllowedSize, this.indexType64, this.shared);
        System.arraycopy(this.byteArrayBuffer.buffer(), 0, other.byteArrayBuffer.buffer(), 0, (int)this.byteArrayBuffer.byteSize());
        return other;
    }

    @Override
    public void close() {
        this.byteArrayBuffer.close();
    }

    @Override
    public ByteBuffer asByteBuffer() {
        return null;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public int copyFromStream(Node node, InputStream stream, int offset, int length) throws IOException {
        if (this.outOfBounds(offset, length)) {
            throw this.trapOutOfBounds(node, offset, length);
        }
        return stream.read(this.byteArrayBuffer.buffer(), offset, length);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public void copyToStream(Node node, OutputStream stream, int offset, int length) throws IOException {
        if (this.outOfBounds(offset, length)) {
            throw this.trapOutOfBounds(node, offset, length);
        }
        stream.write(this.byteArrayBuffer.buffer(), offset, length);
    }

    @Override
    public void copyToBuffer(Node node, byte[] dst, long srcOffset, int dstOffset, int length) {
        if (this.outOfBounds(srcOffset, (long)length)) {
            throw this.trapOutOfBounds(node, srcOffset, length);
        }
        System.arraycopy(this.byteArrayBuffer.buffer(), (int)srcOffset, dst, dstOffset, length);
    }

    private static final class WasmByteArrayBuffer {
        private static final int MAX_CONSTANT_ATTEMPTS = 5;
        @CompilerDirectives.CompilationFinal
        private Assumption constantMemoryBufferAssumption;
        @CompilerDirectives.CompilationFinal(dimensions=0)
        private byte[] constantBuffer;
        private byte[] dynamicBuffer;
        private int constantAttempts = 0;

        private WasmByteArrayBuffer() {
        }

        @CompilerDirectives.TruffleBoundary
        public void allocate(long byteSize) {
            assert (byteSize <= Integer.MAX_VALUE);
            int effectiveByteSize = (int)byteSize;
            this.constantBuffer = null;
            this.dynamicBuffer = null;
            if (this.constantAttempts < 5) {
                this.constantMemoryBufferAssumption = Assumption.create((String)"ConstantMemoryBuffer");
                ++this.constantAttempts;
            }
            try {
                if (this.constantMemoryBufferAssumption.isValid()) {
                    this.constantBuffer = new byte[effectiveByteSize];
                } else {
                    this.dynamicBuffer = new byte[effectiveByteSize];
                }
            }
            catch (OutOfMemoryError error) {
                throw WasmException.create(Failure.MEMORY_ALLOCATION_FAILED);
            }
        }

        byte[] buffer() {
            if (this.constantMemoryBufferAssumption.isValid()) {
                return this.constantBuffer;
            }
            return this.dynamicBuffer;
        }

        long size() {
            return this.buffer().length / 65536;
        }

        long byteSize() {
            return this.buffer().length;
        }

        void grow(long targetSize) {
            byte[] currentBuffer = this.buffer();
            this.constantMemoryBufferAssumption.invalidate("Memory grow");
            this.allocate(targetSize);
            System.arraycopy(currentBuffer, 0, this.buffer(), 0, currentBuffer.length);
        }

        void reset(long byteSize) {
            this.constantMemoryBufferAssumption.invalidate("Memory reset");
            this.allocate(byteSize);
        }

        void close() {
            this.constantBuffer = null;
            this.dynamicBuffer = null;
        }
    }
}

