/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.memory;

import java.lang.reflect.Field;
import sun.misc.Unsafe;

public final class NativeDataInstanceUtil {
    private static final Unsafe unsafe = NativeDataInstanceUtil.initUnsafe();

    private static Unsafe initUnsafe() {
        try {
            return Unsafe.getUnsafe();
        }
        catch (SecurityException se) {
            try {
                Field theUnsafe = Unsafe.class.getDeclaredField("theUnsafe");
                theUnsafe.setAccessible(true);
                return (Unsafe)theUnsafe.get(Unsafe.class);
            }
            catch (Exception e) {
                throw new RuntimeException("exception while trying to get Unsafe", e);
            }
        }
    }

    private NativeDataInstanceUtil() {
    }

    public static long allocateNativeInstance(byte[] data, int offset, int length) {
        long address = unsafe.allocateMemory(length);
        for (int i = 0; i < length; ++i) {
            unsafe.putByte(address + (long)i, data[offset + i]);
        }
        return address;
    }

    public static void freeNativeInstance(long address) {
        unsafe.freeMemory(address);
    }
}

