/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.parser.validation;

import java.util.Arrays;
import org.graalvm.wasm.collection.IntArrayList;
import org.graalvm.wasm.exception.Failure;
import org.graalvm.wasm.exception.WasmException;
import org.graalvm.wasm.parser.bytecode.RuntimeBytecodeGen;
import org.graalvm.wasm.parser.validation.ControlFrame;
import org.graalvm.wasm.parser.validation.ParserState;

class IfFrame
extends ControlFrame {
    private final IntArrayList branchTargets = new IntArrayList();
    private int falseJumpLocation;
    private boolean elseBranch;

    IfFrame(byte[] paramTypes, byte[] resultTypes, int initialStackSize, boolean unreachable, int falseJumpLocation) {
        super(paramTypes, resultTypes, initialStackSize, unreachable);
        this.falseJumpLocation = falseJumpLocation;
        this.elseBranch = false;
    }

    @Override
    byte[] labelTypes() {
        return this.resultTypes();
    }

    @Override
    void enterElse(ParserState state, RuntimeBytecodeGen bytecode) {
        int location = bytecode.addBranchLocation();
        bytecode.patchLocation(this.falseJumpLocation, bytecode.location());
        this.falseJumpLocation = location;
        this.elseBranch = true;
        state.checkStackAfterFrameExit(this, this.resultTypes());
        this.resetUnreachable();
    }

    @Override
    void exit(RuntimeBytecodeGen bytecode) {
        if (!this.elseBranch && !Arrays.equals(this.paramTypes(), this.resultTypes())) {
            throw WasmException.create(Failure.TYPE_MISMATCH, "Expected else branch. If with incompatible param and result types requires else branch.");
        }
        if (this.branchTargets.size() == 0) {
            bytecode.patchLocation(this.falseJumpLocation, bytecode.location());
        } else {
            int location = bytecode.addLabel(this.resultTypeLength(), this.initialStackSize(), this.commonResultType());
            bytecode.patchLocation(this.falseJumpLocation, location);
            for (int branchLocation : this.branchTargets.toArray()) {
                bytecode.patchLocation(branchLocation, location);
            }
        }
    }

    @Override
    void addBranch(RuntimeBytecodeGen bytecode) {
        this.branchTargets.add(bytecode.addBranchLocation());
    }

    @Override
    void addBranchIf(RuntimeBytecodeGen bytecode) {
        this.branchTargets.add(bytecode.addBranchIfLocation());
    }

    @Override
    void addBranchTableItem(RuntimeBytecodeGen bytecode) {
        this.branchTargets.add(bytecode.addBranchTableItemLocation());
    }
}

