/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.predefined.wasi.types;

import com.oracle.truffle.api.nodes.Node;
import org.graalvm.wasm.memory.WasmMemory;
import org.graalvm.wasm.predefined.wasi.types.Errno;
import org.graalvm.wasm.predefined.wasi.types.Eventtype;

public final class Event {
    public static final int BYTES = 32;

    private Event() {
    }

    public static long readUserdata(Node node, WasmMemory memory, int address) {
        return memory.load_i64(node, address + 0);
    }

    public static void writeUserdata(Node node, WasmMemory memory, int address, long value) {
        memory.store_i64(node, address + 0, value);
    }

    public static Errno readError(Node node, WasmMemory memory, int address) {
        return Errno.fromValue((short)memory.load_i32_16u(node, address + 8));
    }

    public static void writeError(Node node, WasmMemory memory, int address, Errno value) {
        memory.store_i32_16(node, address + 8, value.toValue());
    }

    public static Eventtype readType(Node node, WasmMemory memory, int address) {
        return Eventtype.fromValue((byte)memory.load_i32_8u(node, address + 10));
    }

    public static void writeType(Node node, WasmMemory memory, int address, Eventtype value) {
        memory.store_i32_8(node, address + 10, value.toValue());
    }

    public static int readFdReadwrite(Node node, WasmMemory memory, int address) {
        return memory.load_i32(node, address + 16);
    }

    public static void writeFdReadwrite(Node node, WasmMemory memory, int address, int value) {
        memory.store_i32(node, address + 16, value);
    }
}

