/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm;

import org.graalvm.wasm.Assert;
import org.graalvm.wasm.exception.Failure;

public final class ModuleLimits {
    private final int moduleSizeLimit;
    private final int typeCountLimit;
    private final int functionCountLimit;
    private final int tableCountLimit;
    private final int memoryCountLimit;
    private final int multiMemoryCountLimit;
    private final int importCountLimit;
    private final int exportCountLimit;
    private final int globalCountLimit;
    private final int dataSegmentCountLimit;
    private final int elementSegmentCountLimit;
    private final int functionSizeLimit;
    private final int paramCountLimit;
    private final int resultCountLimit;
    private final int multiValueResultCountLimit;
    private final int localCountLimit;
    private final int tableInstanceSizeLimit;
    private final int memoryInstanceSizeLimit;
    private final long memory64InstanceSizeLimit;
    static final ModuleLimits DEFAULTS = new ModuleLimits(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Short.MAX_VALUE, 976562500L);

    public ModuleLimits(int moduleSizeLimit, int typeCountLimit, int functionCountLimit, int tableCountLimit, int memoryCountLimit, int multiMemoryCountLimit, int importCountLimit, int exportCountLimit, int globalCountLimit, int dataSegmentCountLimit, int elementSegmentCountLimit, int functionSizeLimit, int paramCountLimit, int resultCountLimit, int multiValueResultCountLimit, int localCountLimit, int tableInstanceSizeLimit, int memoryInstanceSizeLimit, long memory64InstanceSizeLimit) {
        this.moduleSizeLimit = ModuleLimits.minUnsigned(moduleSizeLimit, Integer.MAX_VALUE);
        this.typeCountLimit = ModuleLimits.minUnsigned(typeCountLimit, Integer.MAX_VALUE);
        this.functionCountLimit = ModuleLimits.minUnsigned(functionCountLimit, Integer.MAX_VALUE);
        this.tableCountLimit = ModuleLimits.minUnsigned(tableCountLimit, Integer.MAX_VALUE);
        this.memoryCountLimit = ModuleLimits.minUnsigned(memoryCountLimit, Integer.MAX_VALUE);
        this.multiMemoryCountLimit = ModuleLimits.minUnsigned(multiMemoryCountLimit, Integer.MAX_VALUE);
        this.importCountLimit = ModuleLimits.minUnsigned(importCountLimit, Integer.MAX_VALUE);
        this.exportCountLimit = ModuleLimits.minUnsigned(exportCountLimit, Integer.MAX_VALUE);
        this.globalCountLimit = ModuleLimits.minUnsigned(globalCountLimit, Integer.MAX_VALUE);
        this.dataSegmentCountLimit = ModuleLimits.minUnsigned(dataSegmentCountLimit, Integer.MAX_VALUE);
        this.elementSegmentCountLimit = ModuleLimits.minUnsigned(elementSegmentCountLimit, Integer.MAX_VALUE);
        this.functionSizeLimit = ModuleLimits.minUnsigned(functionSizeLimit, Integer.MAX_VALUE);
        this.paramCountLimit = ModuleLimits.minUnsigned(paramCountLimit, Integer.MAX_VALUE);
        this.resultCountLimit = ModuleLimits.minUnsigned(resultCountLimit, Integer.MAX_VALUE);
        this.multiValueResultCountLimit = ModuleLimits.minUnsigned(multiValueResultCountLimit, Integer.MAX_VALUE);
        this.localCountLimit = ModuleLimits.minUnsigned(localCountLimit, Integer.MAX_VALUE);
        this.tableInstanceSizeLimit = ModuleLimits.minUnsigned(tableInstanceSizeLimit, Integer.MAX_VALUE);
        this.memoryInstanceSizeLimit = ModuleLimits.minUnsigned(memoryInstanceSizeLimit, Short.MAX_VALUE);
        this.memory64InstanceSizeLimit = ModuleLimits.minUnsigned(memory64InstanceSizeLimit, 976562500L);
    }

    private static int minUnsigned(int a, int b) {
        return Integer.compareUnsigned(a, b) < 0 ? a : b;
    }

    private static long minUnsigned(long a, long b) {
        return Long.compareUnsigned(a, b) < 0 ? a : b;
    }

    public void checkModuleSize(int size) {
        Assert.assertUnsignedIntLessOrEqual(size, this.moduleSizeLimit, Failure.MODULE_SIZE_LIMIT_EXCEEDED);
    }

    public void checkTypeCount(int count) {
        Assert.assertUnsignedIntLessOrEqual(count, this.typeCountLimit, Failure.TYPE_COUNT_LIMIT_EXCEEDED);
    }

    public void checkFunctionCount(int count) {
        Assert.assertUnsignedIntLessOrEqual(count, this.functionCountLimit, Failure.FUNCTION_COUNT_LIMIT_EXCEEDED);
    }

    public void checkTableCount(int count) {
        Assert.assertUnsignedIntLessOrEqual(count, this.tableCountLimit, Failure.TABLE_COUNT_LIMIT_EXCEEDED);
    }

    public void checkMemoryCount(int count, boolean multiMemory) {
        if (multiMemory) {
            Assert.assertUnsignedIntLessOrEqual(count, this.multiMemoryCountLimit, Failure.MEMORY_COUNT_LIMIT_EXCEEDED);
        } else {
            Assert.assertUnsignedIntLessOrEqual(count, this.memoryCountLimit, Failure.MEMORY_COUNT_LIMIT_EXCEEDED);
        }
    }

    public void checkImportCount(int count) {
        Assert.assertUnsignedIntLessOrEqual(count, this.importCountLimit, Failure.IMPORT_COUNT_LIMIT_EXCEEDED);
    }

    public void checkExportCount(int count) {
        Assert.assertUnsignedIntLessOrEqual(count, this.exportCountLimit, Failure.EXPORT_COUNT_LIMIT_EXCEEDED);
    }

    public void checkGlobalCount(int count) {
        Assert.assertUnsignedIntLessOrEqual(count, this.globalCountLimit, Failure.GLOBAL_COUNT_LIMIT_EXCEEDED);
    }

    public void checkDataSegmentCount(int count) {
        Assert.assertUnsignedIntLessOrEqual(count, this.dataSegmentCountLimit, Failure.DATA_SEGMENT_COUNT_LIMIT_EXCEEDED);
    }

    public void checkElementSegmentCount(int count) {
        Assert.assertUnsignedIntLessOrEqual(count, this.elementSegmentCountLimit, Failure.ELEMENT_SEGMENT_COUNT_LIMIT_EXCEEDED);
    }

    public void checkFunctionSize(int size) {
        Assert.assertUnsignedIntLessOrEqual(size, this.functionSizeLimit, Failure.FUNCTION_SIZE_LIMIT_EXCEEDED);
    }

    public void checkParamCount(int count) {
        Assert.assertUnsignedIntLessOrEqual(count, this.paramCountLimit, Failure.PARAMETERS_COUNT_LIMIT_EXCEEDED);
    }

    public void checkResultCount(int count, boolean multiValue) {
        if (multiValue) {
            Assert.assertUnsignedIntLessOrEqual(count, this.multiValueResultCountLimit, Failure.RESULT_COUNT_LIMIT_EXCEEDED);
        } else {
            Assert.assertUnsignedIntLessOrEqual(count, this.resultCountLimit, Failure.RESULT_COUNT_LIMIT_EXCEEDED);
        }
    }

    public void checkLocalCount(int count) {
        Assert.assertUnsignedIntLessOrEqual(count, this.localCountLimit, Failure.TOO_MANY_LOCALS);
    }

    public void checkTableInstanceSize(int size) {
        Assert.assertUnsignedIntLessOrEqual(size, this.tableInstanceSizeLimit, Failure.TABLE_INSTANCE_SIZE_LIMIT_EXCEEDED);
    }

    public void checkMemoryInstanceSize(long size, boolean indexType64) {
        if (indexType64) {
            Assert.assertUnsignedLongLessOrEqual(size, this.memory64InstanceSizeLimit, Failure.MEMORY_INSTANCE_SIZE_LIMIT_EXCEEDED);
        } else {
            Assert.assertUnsignedLongLessOrEqual(size, this.memoryInstanceSizeLimit, Failure.MEMORY_INSTANCE_SIZE_LIMIT_EXCEEDED);
        }
    }

    public int tableInstanceSizeLimit() {
        return this.tableInstanceSizeLimit;
    }

    public long memoryInstanceSizeLimit() {
        return this.memoryInstanceSizeLimit(false);
    }

    public long memoryInstanceSizeLimit(boolean indexType64) {
        return indexType64 ? this.memory64InstanceSizeLimit : (long)this.memoryInstanceSizeLimit;
    }
}

