/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import org.graalvm.wasm.ImportDescriptor;
import org.graalvm.wasm.SymbolTable;

public final class WasmFunction {
    private final SymbolTable symbolTable;
    private final int index;
    private final ImportDescriptor importDescriptor;
    private final int typeIndex;
    @CompilerDirectives.CompilationFinal
    private int typeEquivalenceClass;
    @CompilerDirectives.CompilationFinal
    private String debugName;
    @CompilerDirectives.CompilationFinal
    private CallTarget callTarget;

    public WasmFunction(SymbolTable symbolTable, int index, int typeIndex, ImportDescriptor importDescriptor) {
        this.symbolTable = symbolTable;
        this.index = index;
        this.importDescriptor = importDescriptor;
        this.typeIndex = typeIndex;
        this.typeEquivalenceClass = -1;
    }

    public String moduleName() {
        return this.symbolTable.module().name();
    }

    public int paramCount() {
        return this.symbolTable.functionTypeParamCount(this.typeIndex);
    }

    public byte paramTypeAt(int argumentIndex) {
        return this.symbolTable.functionTypeParamTypeAt(this.typeIndex, argumentIndex);
    }

    public int resultCount() {
        return this.symbolTable.functionTypeResultCount(this.typeIndex);
    }

    public byte resultTypeAt(int returnIndex) {
        return this.symbolTable.functionTypeResultTypeAt(this.typeIndex, returnIndex);
    }

    void setTypeEquivalenceClass(int typeEquivalenceClass) {
        this.typeEquivalenceClass = typeEquivalenceClass;
    }

    public String toString() {
        return this.name();
    }

    @CompilerDirectives.TruffleBoundary
    public String name() {
        if (this.importDescriptor != null) {
            return this.importDescriptor.memberName();
        }
        String exportedName = this.symbolTable.exportedFunctionName(this.index);
        if (exportedName != null) {
            return exportedName;
        }
        if (this.debugName != null) {
            return this.debugName;
        }
        return "wasm-function:" + this.index;
    }

    public void setDebugName(String debugName) {
        this.debugName = debugName;
    }

    public boolean isImported() {
        return this.importDescriptor != null;
    }

    public ImportDescriptor importDescriptor() {
        return this.importDescriptor;
    }

    public String importedModuleName() {
        return this.isImported() ? this.importDescriptor.moduleName() : null;
    }

    public String importedFunctionName() {
        return this.isImported() ? this.importDescriptor.memberName() : null;
    }

    public int typeIndex() {
        return this.typeIndex;
    }

    public SymbolTable.FunctionType type() {
        return this.symbolTable.typeAt(this.typeIndex());
    }

    public int typeEquivalenceClass() {
        return this.typeEquivalenceClass;
    }

    public int index() {
        return this.index;
    }

    public CallTarget target() {
        return this.callTarget;
    }

    public void setTarget(CallTarget callTarget) {
        assert (!this.isImported()) : this;
        assert (this.callTarget == null) : this;
        this.callTarget = callTarget;
    }

    void setImportedFunctionCallTarget(CallTarget callTarget) {
        assert (this.isImported()) : this;
        this.callTarget = callTarget;
    }
}

