/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.api;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.InlineSupport;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.InvalidBufferOffsetException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnadoptableNode;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import java.lang.invoke.MethodHandles;
import java.nio.ByteOrder;
import org.graalvm.wasm.api.ByteArrayBuffer;

@GeneratedBy(value=ByteArrayBuffer.class)
public final class ByteArrayBufferGen {
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);

    private ByteArrayBufferGen() {
    }

    static {
        LibraryExport.register(ByteArrayBuffer.class, (LibraryExport[])new LibraryExport[]{new InteropLibraryExports()});
    }

    @GeneratedBy(value=ByteArrayBuffer.class)
    public static class InteropLibraryExports
    extends LibraryExport<InteropLibrary> {
        private InteropLibraryExports() {
            super(InteropLibrary.class, ByteArrayBuffer.class, false, false, 0);
        }

        protected InteropLibrary createUncached(Object receiver) {
            assert (receiver instanceof ByteArrayBuffer);
            Uncached uncached = new Uncached(receiver);
            return uncached;
        }

        protected InteropLibrary createCached(Object receiver) {
            assert (receiver instanceof ByteArrayBuffer);
            return new Cached(receiver);
        }

        @GeneratedBy(value=ByteArrayBuffer.class)
        public static class Uncached
        extends InteropLibrary
        implements UnadoptableNode {
            private final Class<? extends ByteArrayBuffer> receiverClass_;

            protected Uncached(Object receiver) {
                this.receiverClass_ = ((ByteArrayBuffer)receiver).getClass();
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                assert (receiver.getClass() != this.receiverClass_ || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return CompilerDirectives.isExact((Object)receiver, this.receiverClass_);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean hasArrayElements(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((ByteArrayBuffer)receiver).hasArrayElements();
            }

            @CompilerDirectives.TruffleBoundary
            public long getArraySize(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((ByteArrayBuffer)receiver).getArraySize();
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isArrayElementReadable(Object receiver, long index) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((ByteArrayBuffer)receiver).isArrayElementReadable(index);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isArrayElementModifiable(Object receiver, long index) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((ByteArrayBuffer)receiver).isArrayElementModifiable(index);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isArrayElementInsertable(Object receiver, long index) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((ByteArrayBuffer)receiver).isArrayElementInsertable(index);
            }

            @CompilerDirectives.TruffleBoundary
            public Object readArrayElement(Object arg0Value_, long arg1Value) throws InvalidArrayIndexException, UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                ByteArrayBuffer arg0Value = (ByteArrayBuffer)arg0Value_;
                return arg0Value.readArrayElement(arg1Value, (Node)this, InlinedBranchProfile.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public void writeArrayElement(Object receiver, long index, Object value) throws UnsupportedMessageException, UnsupportedTypeException, InvalidArrayIndexException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                ((ByteArrayBuffer)receiver).writeArrayElement(index, value);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean hasBufferElements(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((ByteArrayBuffer)receiver).hasBufferElements();
            }

            @CompilerDirectives.TruffleBoundary
            public long getBufferSize(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((ByteArrayBuffer)receiver).getBufferSize();
            }

            @CompilerDirectives.TruffleBoundary
            public void readBuffer(Object receiver, long byteOffset, byte[] destination, int destinationOffset, int length) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                ((ByteArrayBuffer)receiver).readBuffer(byteOffset, destination, destinationOffset, length);
            }

            @CompilerDirectives.TruffleBoundary
            public byte readBufferByte(Object receiver, long byteOffset) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((ByteArrayBuffer)receiver).readBufferByte(byteOffset);
            }

            @CompilerDirectives.TruffleBoundary
            public short readBufferShort(Object receiver, ByteOrder order, long byteOffset) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((ByteArrayBuffer)receiver).readBufferShort(order, byteOffset);
            }

            @CompilerDirectives.TruffleBoundary
            public int readBufferInt(Object receiver, ByteOrder order, long byteOffset) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((ByteArrayBuffer)receiver).readBufferInt(order, byteOffset);
            }

            @CompilerDirectives.TruffleBoundary
            public long readBufferLong(Object receiver, ByteOrder order, long byteOffset) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((ByteArrayBuffer)receiver).readBufferLong(order, byteOffset);
            }

            @CompilerDirectives.TruffleBoundary
            public float readBufferFloat(Object receiver, ByteOrder order, long byteOffset) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((ByteArrayBuffer)receiver).readBufferFloat(order, byteOffset);
            }

            @CompilerDirectives.TruffleBoundary
            public double readBufferDouble(Object receiver, ByteOrder order, long byteOffset) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((ByteArrayBuffer)receiver).readBufferDouble(order, byteOffset);
            }
        }

        @GeneratedBy(value=ByteArrayBuffer.class)
        public static class Cached
        extends InteropLibrary {
            private static final InlineSupport.StateField STATE_0_ReadArrayElementNode__UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_0_");
            private static final InlinedBranchProfile INLINED_ERROR_BRANCH_ = InlinedBranchProfile.inline((InlineSupport.InlineTarget)InlineSupport.InlineTarget.create(InlinedBranchProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_ReadArrayElementNode__UPDATER.subUpdater(0, 1)}));
            private final Class<? extends ByteArrayBuffer> receiverClass_;
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int state_0_;

            protected Cached(Object receiver) {
                ByteArrayBuffer castReceiver = (ByteArrayBuffer)receiver;
                this.receiverClass_ = castReceiver.getClass();
            }

            public boolean accepts(Object receiver) {
                assert (receiver.getClass() != this.receiverClass_ || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return CompilerDirectives.isExact((Object)receiver, this.receiverClass_);
            }

            public boolean hasArrayElements(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((ByteArrayBuffer)CompilerDirectives.castExact((Object)receiver, this.receiverClass_)).hasArrayElements();
            }

            public long getArraySize(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((ByteArrayBuffer)CompilerDirectives.castExact((Object)receiver, this.receiverClass_)).getArraySize();
            }

            public boolean isArrayElementReadable(Object receiver, long index) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((ByteArrayBuffer)CompilerDirectives.castExact((Object)receiver, this.receiverClass_)).isArrayElementReadable(index);
            }

            public boolean isArrayElementModifiable(Object receiver, long index) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((ByteArrayBuffer)CompilerDirectives.castExact((Object)receiver, this.receiverClass_)).isArrayElementModifiable(index);
            }

            public boolean isArrayElementInsertable(Object receiver, long index) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((ByteArrayBuffer)CompilerDirectives.castExact((Object)receiver, this.receiverClass_)).isArrayElementInsertable(index);
            }

            public Object readArrayElement(Object arg0Value_, long arg1Value) throws UnsupportedMessageException, InvalidArrayIndexException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                ByteArrayBuffer arg0Value = (ByteArrayBuffer)CompilerDirectives.castExact((Object)arg0Value_, this.receiverClass_);
                Cached node__ = this;
                return arg0Value.readArrayElement(arg1Value, (Node)node__, INLINED_ERROR_BRANCH_);
            }

            @CompilerDirectives.TruffleBoundary
            public void writeArrayElement(Object receiver, long index, Object value) throws UnsupportedMessageException, UnsupportedTypeException, InvalidArrayIndexException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                ((ByteArrayBuffer)CompilerDirectives.castExact((Object)receiver, this.receiverClass_)).writeArrayElement(index, value);
            }

            public boolean hasBufferElements(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((ByteArrayBuffer)CompilerDirectives.castExact((Object)receiver, this.receiverClass_)).hasBufferElements();
            }

            public long getBufferSize(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((ByteArrayBuffer)CompilerDirectives.castExact((Object)receiver, this.receiverClass_)).getBufferSize();
            }

            public void readBuffer(Object receiver, long byteOffset, byte[] destination, int destinationOffset, int length) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                ((ByteArrayBuffer)CompilerDirectives.castExact((Object)receiver, this.receiverClass_)).readBuffer(byteOffset, destination, destinationOffset, length);
            }

            public byte readBufferByte(Object receiver, long byteOffset) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((ByteArrayBuffer)CompilerDirectives.castExact((Object)receiver, this.receiverClass_)).readBufferByte(byteOffset);
            }

            public short readBufferShort(Object receiver, ByteOrder order, long byteOffset) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((ByteArrayBuffer)CompilerDirectives.castExact((Object)receiver, this.receiverClass_)).readBufferShort(order, byteOffset);
            }

            public int readBufferInt(Object receiver, ByteOrder order, long byteOffset) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((ByteArrayBuffer)CompilerDirectives.castExact((Object)receiver, this.receiverClass_)).readBufferInt(order, byteOffset);
            }

            public long readBufferLong(Object receiver, ByteOrder order, long byteOffset) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((ByteArrayBuffer)CompilerDirectives.castExact((Object)receiver, this.receiverClass_)).readBufferLong(order, byteOffset);
            }

            public float readBufferFloat(Object receiver, ByteOrder order, long byteOffset) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((ByteArrayBuffer)CompilerDirectives.castExact((Object)receiver, this.receiverClass_)).readBufferFloat(order, byteOffset);
            }

            public double readBufferDouble(Object receiver, ByteOrder order, long byteOffset) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((ByteArrayBuffer)CompilerDirectives.castExact((Object)receiver, this.receiverClass_)).readBufferDouble(order, byteOffset);
            }
        }
    }
}

