/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.constants;

import com.oracle.truffle.api.CompilerAsserts;
import org.graalvm.wasm.exception.Failure;
import org.graalvm.wasm.exception.WasmException;

public final class GlobalModifier {
    public static final byte CONSTANT = 0;
    public static final byte MUTABLE = 1;

    public static String asString(int modifier) {
        CompilerAsserts.neverPartOfCompilation();
        switch (modifier) {
            case 0: {
                return "const";
            }
            case 1: {
                return "var";
            }
        }
        throw WasmException.create(Failure.UNSPECIFIED_INVALID, "Unknown modifier: 0x" + Integer.toHexString(modifier));
    }

    private GlobalModifier() {
    }
}

