/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.constants;

public final class Section {
    public static final int CUSTOM = 0;
    public static final int TYPE = 1;
    public static final int IMPORT = 2;
    public static final int FUNCTION = 3;
    public static final int TABLE = 4;
    public static final int MEMORY = 5;
    public static final int GLOBAL = 6;
    public static final int EXPORT = 7;
    public static final int START = 8;
    public static final int ELEMENT = 9;
    public static final int CODE = 10;
    public static final int DATA = 11;
    public static final int DATA_COUNT = 12;
    private static final int[] SECTION_ORDER = new int[13];
    public static final int LAST_SECTION_ID = SECTION_ORDER.length - 1;

    private Section() {
    }

    public static boolean isNextSectionOrderValid(int sectionID, int lastSectionID) {
        return Integer.compareUnsigned(sectionID, SECTION_ORDER.length) >= 0 || SECTION_ORDER[sectionID] > SECTION_ORDER[lastSectionID];
    }

    static {
        Section.SECTION_ORDER[0] = 0;
        Section.SECTION_ORDER[1] = 1;
        Section.SECTION_ORDER[2] = 2;
        Section.SECTION_ORDER[3] = 3;
        Section.SECTION_ORDER[4] = 4;
        Section.SECTION_ORDER[5] = 5;
        Section.SECTION_ORDER[6] = 6;
        Section.SECTION_ORDER[7] = 7;
        Section.SECTION_ORDER[8] = 8;
        Section.SECTION_ORDER[9] = 9;
        Section.SECTION_ORDER[12] = 10;
        Section.SECTION_ORDER[10] = 11;
        Section.SECTION_ORDER[11] = 12;
    }
}

