/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.debugging.languages.rust;

import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.MapCursor;
import org.graalvm.wasm.debugging.data.DebugObject;
import org.graalvm.wasm.debugging.data.DebugObjectFactory;
import org.graalvm.wasm.debugging.data.DebugType;
import org.graalvm.wasm.debugging.languages.rust.RustArrayType;
import org.graalvm.wasm.debugging.languages.rust.RustFunctionType;
import org.graalvm.wasm.debugging.languages.rust.RustPointer;
import org.graalvm.wasm.debugging.languages.rust.RustString;

public class RustObjectFactory
extends DebugObjectFactory {
    @Override
    protected DebugType createStructType(String name, DebugObject[] members, DebugType[] superTypes) {
        if ("&str".equals(name)) {
            return new RustString(name, members);
        }
        return super.createStructType(name, members, superTypes);
    }

    @Override
    protected DebugType createArrayType(String name, DebugType elementType, int[] dimensionLengths) {
        return new RustArrayType(name, elementType, dimensionLengths);
    }

    @Override
    protected DebugType createSubroutineType(String name, DebugType returnType, DebugType[] parameterTypes) {
        return new RustFunctionType(name, returnType, parameterTypes);
    }

    @Override
    protected DebugType createEnumType(String name, DebugType baseType, EconomicMap<Long, String> values) {
        EconomicMap updatedValues = EconomicMap.create((int)values.size());
        MapCursor cursor = values.getEntries();
        while (cursor.advance()) {
            updatedValues.put((Object)((Long)cursor.getKey()), (Object)(name + "::" + (String)cursor.getValue()));
        }
        return super.createEnumType(name, baseType, (EconomicMap<Long, String>)updatedValues);
    }

    @Override
    protected DebugType createPointerType(DebugType baseType) {
        return new RustPointer(baseType);
    }

    @Override
    public String languageName() {
        return "rust";
    }

    @Override
    protected String namespaceSeparator() {
        return "::";
    }
}

