/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.debugging.parser;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.source.Source;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;

public class DebugSourceLoader {
    private final Map<Path, Source> cache = new HashMap<Path, Source>();

    @CompilerDirectives.TruffleBoundary
    public Source load(Path path, String language, boolean testMode) {
        Source s;
        if (path == null || language == null) {
            return null;
        }
        Path fileName = path.getFileName();
        if (fileName == null) {
            return null;
        }
        if (this.cache.containsKey(path)) {
            return this.cache.get(path);
        }
        try {
            Reader reader;
            if (testMode) {
                InputStream stream = DebugSourceLoader.class.getResourceAsStream(path.toString());
                if (stream == null) {
                    return null;
                }
                reader = new InputStreamReader(stream);
            } else {
                reader = Files.newBufferedReader(path);
            }
            s = Source.newBuilder((String)language, (Reader)reader, (String)fileName.toString()).build();
        }
        catch (IOException | SecurityException e) {
            return null;
        }
        this.cache.put(path, s);
        return s;
    }
}

