/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.debugging.parser;

import java.nio.file.Path;
import java.util.List;
import org.graalvm.wasm.debugging.DebugLineMap;

public class DebugState {
    private int pc = 0;
    private int opIndex = 0;
    private int file = 1;
    private int line = 1;
    private int column = 0;
    private boolean isStatement;
    private boolean basicBlock = false;
    private boolean endSequence = false;
    private boolean prologueEnd = false;
    private boolean epilogueBegin = false;
    private int isa = 0;
    private int discriminator = 0;
    private final int lineBase;
    private final int lineRange;
    private final int opcodeBase;
    private final int minInstrLength;
    private final int maxOpsPerInstr;
    private final boolean initialIsStatement;
    private final int length;
    private final DebugLineMap[] lineMaps;
    private final List<Path> filePaths;

    public DebugState(boolean initialIsStatement, int lineBase, int lineRange, int opcodeBase, int minInstrLength, int maxOpsPerInstr, int length, List<Path> filePaths) {
        assert (filePaths.size() > 1);
        this.initialIsStatement = initialIsStatement;
        this.lineBase = lineBase;
        this.lineRange = lineRange;
        this.opcodeBase = opcodeBase;
        this.minInstrLength = minInstrLength;
        this.maxOpsPerInstr = maxOpsPerInstr;
        this.length = length;
        this.filePaths = filePaths;
        this.lineMaps = new DebugLineMap[filePaths.size()];
        this.lineMaps[this.file] = new DebugLineMap(filePaths.get(this.file));
        this.reset();
    }

    public int length() {
        return this.length;
    }

    private void reset() {
        this.pc = 0;
        this.opIndex = 0;
        this.file = 1;
        this.line = 1;
        this.column = 0;
        this.isStatement = this.initialIsStatement;
        this.basicBlock = false;
        this.endSequence = false;
        this.prologueEnd = false;
        this.epilogueBegin = false;
        this.isa = 0;
        this.discriminator = 0;
    }

    public void addRow() {
        this.lineMaps[this.file].add(this.pc, this.line);
        this.discriminator = 0;
        this.basicBlock = false;
        this.prologueEnd = false;
        this.epilogueBegin = false;
    }

    public void advancePc(int operationAdvance) {
        this.advance(operationAdvance);
    }

    public void advanceLine(int lineAdvance) {
        this.line += lineAdvance;
    }

    public void setFile(int f) {
        this.file = f;
        if (this.lineMaps[this.file] == null) {
            this.lineMaps[this.file] = new DebugLineMap(this.filePaths.get(this.file));
        }
    }

    public void setColumn(int c) {
        this.column = c;
    }

    public void negateStatement() {
        this.isStatement = !this.isStatement;
    }

    public void setBasicBlock() {
        this.basicBlock = true;
    }

    public void addConstantPc() {
        int adjustedOpcode = 255 - this.opcodeBase;
        this.advance(Integer.divideUnsigned(adjustedOpcode, this.lineRange));
    }

    public void addFixedPc(int advance) {
        this.pc += advance;
        this.opIndex = 0;
    }

    public void setPrologueEnd() {
        this.prologueEnd = true;
    }

    public void setEpilogueBegin() {
        this.epilogueBegin = true;
    }

    public void setIsa(int i) {
        this.isa = i;
    }

    public void setEndSequence() {
        this.endSequence = true;
        this.addRow();
        this.reset();
    }

    public void setAddress(int a) {
        this.pc = a;
        this.opIndex = 0;
    }

    public void setDiscriminator(int d) {
        this.discriminator = d;
    }

    public void specialOpcode(int opcode) {
        int adjustedOpcode = opcode - this.opcodeBase;
        this.advance(Integer.divideUnsigned(adjustedOpcode, this.lineRange));
        this.line += this.lineBase + Integer.remainderUnsigned(adjustedOpcode, this.lineRange);
        this.addRow();
        this.basicBlock = false;
        this.prologueEnd = false;
        this.epilogueBegin = false;
        this.discriminator = 0;
    }

    private void advance(int operationAdvance) {
        this.pc += (int)((long)this.minInstrLength * (long)Integer.divideUnsigned(this.opIndex + operationAdvance, this.maxOpsPerInstr));
        this.opIndex = Integer.remainderUnsigned(this.opIndex + operationAdvance, this.maxOpsPerInstr);
    }

    public DebugLineMap[] lineMaps() {
        return this.lineMaps;
    }
}

