/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.debugging.representation;

import com.oracle.truffle.api.CompilerDirectives;
import org.graalvm.wasm.debugging.DebugLocation;
import org.graalvm.wasm.debugging.data.DebugContext;
import org.graalvm.wasm.debugging.data.DebugObject;
import org.graalvm.wasm.debugging.representation.DebugArrayDisplayValue;
import org.graalvm.wasm.debugging.representation.DebugConstantDisplayValue;
import org.graalvm.wasm.debugging.representation.DebugObjectDisplayValue;

public abstract class DebugDisplayValue {
    @CompilerDirectives.TruffleBoundary
    protected Object resolveDebugObject(DebugObject object, DebugContext context, DebugLocation objectLocation) {
        DebugLocation loc = object.getLocation(objectLocation);
        DebugContext ctx = object.getContext(context);
        if (object.isValue()) {
            return object.asValue(ctx, loc);
        }
        if (object.isDebugObject()) {
            return this.resolveDebugObject(object.asDebugObject(ctx, loc), ctx, loc);
        }
        if (object.hasMembers()) {
            return DebugObjectDisplayValue.fromDebugObject(object, ctx, loc);
        }
        if (object.hasArrayElements()) {
            return DebugArrayDisplayValue.fromDebugObject(object, ctx, loc);
        }
        return DebugConstantDisplayValue.UNSUPPORTED;
    }
}

