/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.memory;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.InvalidBufferOffsetException;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import org.graalvm.wasm.EmbedderDataHolder;
import org.graalvm.wasm.api.Vector128;
import org.graalvm.wasm.api.WebAssembly;
import org.graalvm.wasm.collection.ByteArrayList;
import org.graalvm.wasm.exception.Failure;
import org.graalvm.wasm.exception.WasmException;
import org.graalvm.wasm.nodes.WasmFunctionNode;

@ExportLibrary(value=InteropLibrary.class)
public abstract class WasmMemory
extends EmbedderDataHolder
implements TruffleObject {
    protected final long declaredMinSize;
    protected final long declaredMaxSize;
    protected long currentMinSize;
    protected final long maxAllowedSize;
    protected final boolean indexType64;
    protected final boolean shared;

    protected WasmMemory(long declaredMinSize, long declaredMaxSize, long initialSize, long maxAllowedSize, boolean indexType64, boolean shared) {
        assert (Long.compareUnsigned(declaredMinSize, initialSize) <= 0);
        assert (Long.compareUnsigned(initialSize, maxAllowedSize) <= 0);
        assert (Long.compareUnsigned(maxAllowedSize, declaredMaxSize) <= 0);
        assert (indexType64 || Long.compareUnsigned(maxAllowedSize, 32767L) <= 0);
        assert (indexType64 || Long.compareUnsigned(declaredMaxSize, 65536L) <= 0);
        assert (!indexType64 || Long.compareUnsigned(maxAllowedSize, 976562500L) <= 0);
        assert (!indexType64 || Long.compareUnsigned(declaredMaxSize, 0x1000000000000L) <= 0);
        this.declaredMinSize = declaredMinSize;
        this.declaredMaxSize = declaredMaxSize;
        this.currentMinSize = declaredMinSize;
        this.maxAllowedSize = maxAllowedSize;
        this.indexType64 = indexType64;
        this.shared = shared;
    }

    public abstract long size();

    public abstract long byteSize();

    public final long declaredMinSize() {
        return this.declaredMinSize;
    }

    public final long declaredMaxSize() {
        return this.declaredMaxSize;
    }

    public final long minSize() {
        return this.currentMinSize;
    }

    public final long maxAllowedSize() {
        return this.maxAllowedSize;
    }

    public final boolean hasIndexType64() {
        return this.indexType64;
    }

    public final boolean isShared() {
        return this.shared;
    }

    public abstract long grow(long var1);

    public abstract void reset();

    public abstract int load_i32(Node var1, long var2);

    public abstract long load_i64(Node var1, long var2);

    public abstract float load_f32(Node var1, long var2);

    public abstract double load_f64(Node var1, long var2);

    public abstract int load_i32_8s(Node var1, long var2);

    public abstract int load_i32_8u(Node var1, long var2);

    public abstract int load_i32_16s(Node var1, long var2);

    public abstract int load_i32_16u(Node var1, long var2);

    public abstract long load_i64_8s(Node var1, long var2);

    public abstract long load_i64_8u(Node var1, long var2);

    public abstract long load_i64_16s(Node var1, long var2);

    public abstract long load_i64_16u(Node var1, long var2);

    public abstract long load_i64_32s(Node var1, long var2);

    public abstract long load_i64_32u(Node var1, long var2);

    public abstract Vector128 load_i128(Node var1, long var2);

    public abstract void store_i32(Node var1, long var2, int var4);

    public abstract void store_i64(Node var1, long var2, long var4);

    public abstract void store_f32(Node var1, long var2, float var4);

    public abstract void store_f64(Node var1, long var2, double var4);

    public abstract void store_i32_8(Node var1, long var2, byte var4);

    public abstract void store_i32_16(Node var1, long var2, short var4);

    public abstract void store_i64_8(Node var1, long var2, byte var4);

    public abstract void store_i64_16(Node var1, long var2, short var4);

    public abstract void store_i64_32(Node var1, long var2, int var4);

    public abstract void store_i128(Node var1, long var2, Vector128 var4);

    public abstract int atomic_load_i32(Node var1, long var2);

    public abstract long atomic_load_i64(Node var1, long var2);

    public abstract int atomic_load_i32_8u(Node var1, long var2);

    public abstract int atomic_load_i32_16u(Node var1, long var2);

    public abstract long atomic_load_i64_8u(Node var1, long var2);

    public abstract long atomic_load_i64_16u(Node var1, long var2);

    public abstract long atomic_load_i64_32u(Node var1, long var2);

    public abstract void atomic_store_i32(Node var1, long var2, int var4);

    public abstract void atomic_store_i64(Node var1, long var2, long var4);

    public abstract void atomic_store_i32_8(Node var1, long var2, byte var4);

    public abstract void atomic_store_i32_16(Node var1, long var2, short var4);

    public abstract void atomic_store_i64_8(Node var1, long var2, byte var4);

    public abstract void atomic_store_i64_16(Node var1, long var2, short var4);

    public abstract void atomic_store_i64_32(Node var1, long var2, int var4);

    public abstract int atomic_rmw_add_i32_8u(Node var1, long var2, byte var4);

    public abstract int atomic_rmw_add_i32_16u(Node var1, long var2, short var4);

    public abstract int atomic_rmw_add_i32(Node var1, long var2, int var4);

    public abstract long atomic_rmw_add_i64_8u(Node var1, long var2, byte var4);

    public abstract long atomic_rmw_add_i64_16u(Node var1, long var2, short var4);

    public abstract long atomic_rmw_add_i64_32u(Node var1, long var2, int var4);

    public abstract long atomic_rmw_add_i64(Node var1, long var2, long var4);

    public abstract int atomic_rmw_sub_i32_8u(Node var1, long var2, byte var4);

    public abstract int atomic_rmw_sub_i32_16u(Node var1, long var2, short var4);

    public abstract int atomic_rmw_sub_i32(Node var1, long var2, int var4);

    public abstract long atomic_rmw_sub_i64_8u(Node var1, long var2, byte var4);

    public abstract long atomic_rmw_sub_i64_16u(Node var1, long var2, short var4);

    public abstract long atomic_rmw_sub_i64_32u(Node var1, long var2, int var4);

    public abstract long atomic_rmw_sub_i64(Node var1, long var2, long var4);

    public abstract int atomic_rmw_and_i32_8u(Node var1, long var2, byte var4);

    public abstract int atomic_rmw_and_i32_16u(Node var1, long var2, short var4);

    public abstract int atomic_rmw_and_i32(Node var1, long var2, int var4);

    public abstract long atomic_rmw_and_i64_8u(Node var1, long var2, byte var4);

    public abstract long atomic_rmw_and_i64_16u(Node var1, long var2, short var4);

    public abstract long atomic_rmw_and_i64_32u(Node var1, long var2, int var4);

    public abstract long atomic_rmw_and_i64(Node var1, long var2, long var4);

    public abstract int atomic_rmw_or_i32_8u(Node var1, long var2, byte var4);

    public abstract int atomic_rmw_or_i32_16u(Node var1, long var2, short var4);

    public abstract int atomic_rmw_or_i32(Node var1, long var2, int var4);

    public abstract long atomic_rmw_or_i64_8u(Node var1, long var2, byte var4);

    public abstract long atomic_rmw_or_i64_16u(Node var1, long var2, short var4);

    public abstract long atomic_rmw_or_i64_32u(Node var1, long var2, int var4);

    public abstract long atomic_rmw_or_i64(Node var1, long var2, long var4);

    public abstract int atomic_rmw_xor_i32_8u(Node var1, long var2, byte var4);

    public abstract int atomic_rmw_xor_i32_16u(Node var1, long var2, short var4);

    public abstract int atomic_rmw_xor_i32(Node var1, long var2, int var4);

    public abstract long atomic_rmw_xor_i64_8u(Node var1, long var2, byte var4);

    public abstract long atomic_rmw_xor_i64_16u(Node var1, long var2, short var4);

    public abstract long atomic_rmw_xor_i64_32u(Node var1, long var2, int var4);

    public abstract long atomic_rmw_xor_i64(Node var1, long var2, long var4);

    public abstract int atomic_rmw_xchg_i32_8u(Node var1, long var2, byte var4);

    public abstract int atomic_rmw_xchg_i32_16u(Node var1, long var2, short var4);

    public abstract int atomic_rmw_xchg_i32(Node var1, long var2, int var4);

    public abstract long atomic_rmw_xchg_i64_8u(Node var1, long var2, byte var4);

    public abstract long atomic_rmw_xchg_i64_16u(Node var1, long var2, short var4);

    public abstract long atomic_rmw_xchg_i64_32u(Node var1, long var2, int var4);

    public abstract long atomic_rmw_xchg_i64(Node var1, long var2, long var4);

    public abstract int atomic_rmw_cmpxchg_i32_8u(Node var1, long var2, byte var4, byte var5);

    public abstract int atomic_rmw_cmpxchg_i32_16u(Node var1, long var2, short var4, short var5);

    public abstract int atomic_rmw_cmpxchg_i32(Node var1, long var2, int var4, int var5);

    public abstract long atomic_rmw_cmpxchg_i64_8u(Node var1, long var2, byte var4, byte var5);

    public abstract long atomic_rmw_cmpxchg_i64_16u(Node var1, long var2, short var4, short var5);

    public abstract long atomic_rmw_cmpxchg_i64_32u(Node var1, long var2, int var4, int var5);

    public abstract long atomic_rmw_cmpxchg_i64(Node var1, long var2, long var4, long var6);

    public abstract int atomic_notify(Node var1, long var2, int var4);

    public abstract int atomic_wait32(Node var1, long var2, int var4, long var5);

    public abstract int atomic_wait64(Node var1, long var2, long var4, long var6);

    public abstract WasmMemory duplicate();

    public abstract void initialize(byte[] var1, int var2, long var3, int var5);

    @CompilerDirectives.TruffleBoundary
    public void initializeUnsafe(long sourceAddress, int sourceOffset, long destinationOffset, int length) {
        throw new UnsupportedOperationException();
    }

    public abstract void fill(long var1, long var3, byte var5);

    public abstract void copyFrom(WasmMemory var1, long var2, long var4, long var6);

    @CompilerDirectives.TruffleBoundary
    protected final WasmException trapOutOfBounds(Node node, long address, int length) {
        String message = String.format("%d-byte memory access at address 0x%016X (%d) is out-of-bounds (memory size %d bytes).", length, address, address, this.byteSize());
        return WasmException.create(Failure.OUT_OF_BOUNDS_MEMORY_ACCESS, node, message);
    }

    @CompilerDirectives.TruffleBoundary
    protected static WasmException trapUnalignedAtomic(Node node, long address, int length) {
        String message = String.format("%d-byte atomic memory access at address 0x%016X (%d) is unaligned.", length, address, address);
        return WasmException.create(Failure.UNALIGNED_ATOMIC, node, message);
    }

    @CompilerDirectives.TruffleBoundary
    protected WasmException trapUnsharedMemory(Node node) {
        String message = "Atomic wait operator can only be used on shared memories.";
        return WasmException.create(Failure.EXPECTED_SHARED_MEMORY, node, "Atomic wait operator can only be used on shared memories.");
    }

    @CompilerDirectives.TruffleBoundary
    public String readString(int startOffset, WasmFunctionNode node) {
        byte currentByte;
        ByteArrayList bytes = new ByteArrayList();
        int offset = startOffset;
        while ((currentByte = (byte)this.load_i32_8u(node, offset)) != 0) {
            bytes.add(currentByte);
            ++offset;
        }
        return new String(bytes.toArray(), StandardCharsets.UTF_8);
    }

    @CompilerDirectives.TruffleBoundary
    public final String readString(int startOffset, int length, Node node) {
        ByteArrayList bytes = new ByteArrayList();
        for (int i = 0; i < length; ++i) {
            bytes.add((byte)this.load_i32_8u(node, startOffset + i));
        }
        return new String(bytes.toArray(), StandardCharsets.UTF_8);
    }

    @CompilerDirectives.TruffleBoundary
    public final int writeString(Node node, String string, int offset, int length) {
        int i;
        byte[] bytes = string.getBytes(StandardCharsets.UTF_8);
        for (i = 0; i < bytes.length && i < length; ++i) {
            this.store_i32_8(node, offset + i, bytes[i]);
        }
        return i;
    }

    public final int writeString(Node node, String string, int offset) {
        return this.writeString(node, string, offset, Integer.MAX_VALUE);
    }

    @CompilerDirectives.TruffleBoundary
    public static int encodedStringLength(String string) {
        return string.getBytes(StandardCharsets.UTF_8).length;
    }

    long[] view(int address, int length) {
        long[] chunk = new long[length / 8];
        for (int p = address; p < address + length; p += 8) {
            chunk[(p - address) / 8] = this.load_i64(null, p);
        }
        return chunk;
    }

    String viewByte(int address) {
        int value = this.load_i32_8u(null, address);
        Object result = Integer.toHexString(value);
        if (((String)result).length() == 1) {
            result = "0" + (String)result;
        }
        return result;
    }

    public String hexView(int address, int length) {
        long[] chunk = this.view(address, length);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < chunk.length; ++i) {
            sb.append("0x").append(WasmMemory.hex((long)address + (long)i * 8L)).append(" | ");
            for (int j = 0; j < 8; ++j) {
                sb.append(this.viewByte(address + i * 8 + j)).append(" ");
            }
            sb.append("| ");
            sb.append(WasmMemory.batch(WasmMemory.hex(chunk[i]), 2)).append("\n");
        }
        return sb.toString();
    }

    private static String hex(long value) {
        return WasmMemory.pad(Long.toHexString(value), 16);
    }

    private static String batch(String s, int count) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            result.insert(0, s.charAt(i));
            if ((i + 1) % count != 0) continue;
            result.insert(0, " ");
        }
        return result.reverse().toString();
    }

    private static String pad(String s, int length) {
        StringBuilder padded = new StringBuilder(s);
        while (padded.length() < length) {
            padded.insert(0, "0");
        }
        return padded.toString();
    }

    @ExportMessage
    final boolean hasBufferElements() {
        return true;
    }

    @ExportMessage
    final long getBufferSize() {
        return this.byteSize();
    }

    private void checkOffset(Node node, long byteOffset, int opLength, InlinedBranchProfile errorBranch) throws InvalidBufferOffsetException {
        if (opLength < 0 || byteOffset < 0L || this.getBufferSize() - (long)opLength < byteOffset) {
            errorBranch.enter(node);
            throw InvalidBufferOffsetException.create((long)byteOffset, (long)opLength);
        }
    }

    @ExportMessage
    final void readBuffer(long byteOffset, byte[] destination, int destinationOffset, int length, @Bind(value="$node") Node node, @Cached.Shared(value="errorBranch") @Cached InlinedBranchProfile errorBranch) throws InvalidBufferOffsetException {
        this.checkOffset(node, byteOffset, length, errorBranch);
        this.copyToBuffer(node, destination, byteOffset, destinationOffset, length);
    }

    @ExportMessage
    final byte readBufferByte(long byteOffset, @Bind(value="$node") Node node, @Cached.Shared(value="errorBranch") @Cached InlinedBranchProfile errorBranch) throws InvalidBufferOffsetException {
        this.checkOffset(node, byteOffset, 1, errorBranch);
        return (byte)this.load_i32_8s(null, byteOffset);
    }

    @ExportMessage
    final short readBufferShort(ByteOrder order, long byteOffset, @Bind(value="$node") Node node, @Cached.Shared(value="errorBranch") @Cached InlinedBranchProfile errorBranch) throws InvalidBufferOffsetException {
        this.checkOffset(node, byteOffset, 2, errorBranch);
        short result = (short)this.load_i32_16s(null, byteOffset);
        if (order == ByteOrder.BIG_ENDIAN) {
            result = Short.reverseBytes(result);
        }
        return result;
    }

    @ExportMessage
    final int readBufferInt(ByteOrder order, long byteOffset, @Bind(value="$node") Node node, @Cached.Shared(value="errorBranch") @Cached InlinedBranchProfile errorBranch) throws InvalidBufferOffsetException {
        this.checkOffset(node, byteOffset, 4, errorBranch);
        int result = this.load_i32(null, byteOffset);
        if (order == ByteOrder.BIG_ENDIAN) {
            result = Integer.reverseBytes(result);
        }
        return result;
    }

    @ExportMessage
    final long readBufferLong(ByteOrder order, long byteOffset, @Bind(value="$node") Node node, @Cached.Shared(value="errorBranch") @Cached InlinedBranchProfile errorBranch) throws InvalidBufferOffsetException {
        this.checkOffset(node, byteOffset, 8, errorBranch);
        long result = this.load_i64(null, byteOffset);
        if (order == ByteOrder.BIG_ENDIAN) {
            result = Long.reverseBytes(result);
        }
        return result;
    }

    @ExportMessage
    final float readBufferFloat(ByteOrder order, long byteOffset, @Bind(value="$node") Node node, @Cached.Shared(value="errorBranch") @Cached InlinedBranchProfile errorBranch) throws InvalidBufferOffsetException {
        this.checkOffset(node, byteOffset, 4, errorBranch);
        float result = this.load_f32(null, byteOffset);
        if (order == ByteOrder.BIG_ENDIAN) {
            result = Float.intBitsToFloat(Integer.reverseBytes(Float.floatToRawIntBits(result)));
        }
        return result;
    }

    @ExportMessage
    final double readBufferDouble(ByteOrder order, long byteOffset, @Bind(value="$node") Node node, @Cached.Shared(value="errorBranch") @Cached InlinedBranchProfile errorBranch) throws InvalidBufferOffsetException {
        this.checkOffset(node, byteOffset, 8, errorBranch);
        double result = this.load_f64(null, byteOffset);
        if (order == ByteOrder.BIG_ENDIAN) {
            result = Double.longBitsToDouble(Long.reverseBytes(Double.doubleToRawLongBits(result)));
        }
        return result;
    }

    @ExportMessage
    final boolean isBufferWritable() {
        return true;
    }

    @ExportMessage
    final void writeBufferByte(long byteOffset, byte value, @Bind(value="$node") Node node, @Cached.Shared(value="errorBranch") @Cached InlinedBranchProfile errorBranch) throws InvalidBufferOffsetException {
        this.checkOffset(node, byteOffset, 1, errorBranch);
        this.store_i32_8(null, byteOffset, value);
    }

    @ExportMessage
    final void writeBufferShort(ByteOrder order, long byteOffset, short value, @Bind(value="$node") Node node, @Cached.Shared(value="errorBranch") @Cached InlinedBranchProfile errorBranch) throws InvalidBufferOffsetException {
        this.checkOffset(node, byteOffset, 2, errorBranch);
        short actualValue = order == ByteOrder.LITTLE_ENDIAN ? value : Short.reverseBytes(value);
        this.store_i32_16(null, byteOffset, actualValue);
    }

    @ExportMessage
    final void writeBufferInt(ByteOrder order, long byteOffset, int value, @Bind(value="$node") Node node, @Cached.Shared(value="errorBranch") @Cached InlinedBranchProfile errorBranch) throws InvalidBufferOffsetException {
        this.checkOffset(node, byteOffset, 4, errorBranch);
        int actualValue = order == ByteOrder.LITTLE_ENDIAN ? value : Integer.reverseBytes(value);
        this.store_i32(null, byteOffset, actualValue);
    }

    @ExportMessage
    final void writeBufferLong(ByteOrder order, long byteOffset, long value, @Bind(value="$node") Node node, @Cached.Shared(value="errorBranch") @Cached InlinedBranchProfile errorBranch) throws InvalidBufferOffsetException {
        this.checkOffset(node, byteOffset, 8, errorBranch);
        long actualValue = order == ByteOrder.LITTLE_ENDIAN ? value : Long.reverseBytes(value);
        this.store_i64(null, byteOffset, actualValue);
    }

    @ExportMessage
    final void writeBufferFloat(ByteOrder order, long byteOffset, float value, @Bind(value="$node") Node node, @Cached.Shared(value="errorBranch") @Cached InlinedBranchProfile errorBranch) throws InvalidBufferOffsetException {
        this.checkOffset(node, byteOffset, 4, errorBranch);
        float actualValue = order == ByteOrder.LITTLE_ENDIAN ? value : Float.intBitsToFloat(Integer.reverseBytes(Float.floatToRawIntBits(value)));
        this.store_f32(null, byteOffset, actualValue);
    }

    @ExportMessage
    final void writeBufferDouble(ByteOrder order, long byteOffset, double value, @Bind(value="$node") Node node, @Cached.Shared(value="errorBranch") @Cached InlinedBranchProfile errorBranch) throws InvalidBufferOffsetException {
        this.checkOffset(node, byteOffset, 8, errorBranch);
        double actualValue = order == ByteOrder.LITTLE_ENDIAN ? value : Double.longBitsToDouble(Long.reverseBytes(Double.doubleToRawLongBits(value)));
        this.store_f64(null, byteOffset, actualValue);
    }

    @ExportMessage
    boolean hasArrayElements() {
        return true;
    }

    @ExportMessage
    long getArraySize() {
        return this.byteSize();
    }

    @ExportMessage
    boolean isArrayElementReadable(long address) {
        return address >= 0L && address < this.getArraySize();
    }

    @ExportMessage
    final boolean isArrayElementModifiable(long address) {
        return this.isArrayElementReadable(address);
    }

    @ExportMessage
    final boolean isArrayElementInsertable(long address) {
        return false;
    }

    @ExportMessage
    public Object readArrayElement(long address, @Bind(value="$node") Node node, @Cached.Shared(value="errorBranch") @Cached InlinedBranchProfile errorBranch) throws InvalidArrayIndexException {
        if (!this.isArrayElementReadable(address)) {
            errorBranch.enter(node);
            throw InvalidArrayIndexException.create((long)address);
        }
        return this.load_i32_8u(null, address);
    }

    @ExportMessage
    public void writeArrayElement(long address, Object value, @Bind(value="$node") Node node, @CachedLibrary(limit="3") InteropLibrary valueLib, @Cached.Shared(value="errorBranch") @Cached InlinedBranchProfile errorBranch) throws InvalidArrayIndexException, UnsupportedMessageException, UnsupportedTypeException {
        if (!this.isArrayElementModifiable(address)) {
            errorBranch.enter(node);
            throw InvalidArrayIndexException.create((long)address);
        }
        if (!valueLib.fitsInByte(value)) {
            errorBranch.enter(node);
            throw UnsupportedTypeException.create((Object[])new Object[]{value}, (String)"Only bytes can be stored into WebAssembly memory.");
        }
        byte rawValue = valueLib.asByte(value);
        this.store_i32_8(null, address, rawValue);
    }

    protected void invokeGrowCallback() {
        WebAssembly.invokeMemGrowCallback(this);
    }

    protected int invokeNotifyCallback(Node node, long address, int count) {
        return WebAssembly.invokeMemNotifyCallback(node, this, address, count);
    }

    protected int invokeWaitCallback(Node node, long address, long expected, long timeout, boolean is64) {
        return WebAssembly.invokeMemWaitCallback(node, this, address, expected, timeout, is64);
    }

    public abstract void close();

    public abstract ByteBuffer asByteBuffer();

    public boolean freed() {
        return true;
    }

    protected boolean outOfBounds(int offset, int length) {
        return length < 0 || offset < 0 || (long)offset > this.getBufferSize() - (long)length;
    }

    protected boolean outOfBounds(long offset, long length) {
        return length < 0L || offset < 0L || offset > this.getBufferSize() - length;
    }

    public final WasmMemory checkSize(long initialSize) {
        if (this.byteSize() < initialSize * 65536L) {
            throw CompilerDirectives.shouldNotReachHere((String)"Memory size must not be less than initial size");
        }
        return this;
    }

    public abstract int copyFromStream(Node var1, InputStream var2, int var3, int var4) throws IOException;

    public abstract void copyToStream(Node var1, OutputStream var2, int var3, int var4) throws IOException;

    public abstract void copyToBuffer(Node var1, byte[] var2, long var3, int var5, int var6);

    public boolean isUnsafe() {
        return false;
    }
}

