/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.memory;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.InlineSupport;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.InvalidBufferOffsetException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnadoptableNode;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.ByteOrder;
import java.util.Objects;
import org.graalvm.wasm.memory.WasmMemory;

@GeneratedBy(value=WasmMemory.class)
public final class WasmMemoryGen {
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    private WasmMemoryGen() {
    }

    static {
        LibraryExport.register(WasmMemory.class, (LibraryExport[])new LibraryExport[]{new InteropLibraryExports()});
    }

    @GeneratedBy(value=WasmMemory.class)
    public static class InteropLibraryExports
    extends LibraryExport<InteropLibrary> {
        private InteropLibraryExports() {
            super(InteropLibrary.class, WasmMemory.class, false, false, 0);
        }

        protected InteropLibrary createUncached(Object receiver) {
            assert (receiver instanceof WasmMemory);
            Uncached uncached = new Uncached(receiver);
            return uncached;
        }

        protected InteropLibrary createCached(Object receiver) {
            assert (receiver instanceof WasmMemory);
            return new Cached(receiver);
        }

        @GeneratedBy(value=WasmMemory.class)
        public static class Uncached
        extends InteropLibrary
        implements UnadoptableNode {
            private final Class<? extends WasmMemory> receiverClass_;

            protected Uncached(Object receiver) {
                this.receiverClass_ = ((WasmMemory)receiver).getClass();
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                assert (receiver.getClass() != this.receiverClass_ || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return CompilerDirectives.isExact((Object)receiver, this.receiverClass_);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean hasBufferElements(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((WasmMemory)receiver).hasBufferElements();
            }

            @CompilerDirectives.TruffleBoundary
            public long getBufferSize(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((WasmMemory)receiver).getBufferSize();
            }

            @CompilerDirectives.TruffleBoundary
            public void readBuffer(Object arg0Value_, long arg1Value, byte[] arg2Value, int arg3Value, int arg4Value) throws InvalidBufferOffsetException, UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                WasmMemory arg0Value = (WasmMemory)arg0Value_;
                arg0Value.readBuffer(arg1Value, arg2Value, arg3Value, arg4Value, (Node)this, InlinedBranchProfile.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public byte readBufferByte(Object arg0Value_, long arg1Value) throws InvalidBufferOffsetException, UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                WasmMemory arg0Value = (WasmMemory)arg0Value_;
                return arg0Value.readBufferByte(arg1Value, (Node)this, InlinedBranchProfile.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public short readBufferShort(Object arg0Value_, ByteOrder arg1Value, long arg2Value) throws InvalidBufferOffsetException, UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                WasmMemory arg0Value = (WasmMemory)arg0Value_;
                return arg0Value.readBufferShort(arg1Value, arg2Value, (Node)this, InlinedBranchProfile.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public int readBufferInt(Object arg0Value_, ByteOrder arg1Value, long arg2Value) throws InvalidBufferOffsetException, UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                WasmMemory arg0Value = (WasmMemory)arg0Value_;
                return arg0Value.readBufferInt(arg1Value, arg2Value, (Node)this, InlinedBranchProfile.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public long readBufferLong(Object arg0Value_, ByteOrder arg1Value, long arg2Value) throws InvalidBufferOffsetException, UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                WasmMemory arg0Value = (WasmMemory)arg0Value_;
                return arg0Value.readBufferLong(arg1Value, arg2Value, (Node)this, InlinedBranchProfile.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public float readBufferFloat(Object arg0Value_, ByteOrder arg1Value, long arg2Value) throws InvalidBufferOffsetException, UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                WasmMemory arg0Value = (WasmMemory)arg0Value_;
                return arg0Value.readBufferFloat(arg1Value, arg2Value, (Node)this, InlinedBranchProfile.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public double readBufferDouble(Object arg0Value_, ByteOrder arg1Value, long arg2Value) throws InvalidBufferOffsetException, UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                WasmMemory arg0Value = (WasmMemory)arg0Value_;
                return arg0Value.readBufferDouble(arg1Value, arg2Value, (Node)this, InlinedBranchProfile.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isBufferWritable(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((WasmMemory)receiver).isBufferWritable();
            }

            @CompilerDirectives.TruffleBoundary
            public void writeBufferByte(Object arg0Value_, long arg1Value, byte arg2Value) throws InvalidBufferOffsetException, UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                WasmMemory arg0Value = (WasmMemory)arg0Value_;
                arg0Value.writeBufferByte(arg1Value, arg2Value, (Node)this, InlinedBranchProfile.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public void writeBufferShort(Object arg0Value_, ByteOrder arg1Value, long arg2Value, short arg3Value) throws InvalidBufferOffsetException, UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                WasmMemory arg0Value = (WasmMemory)arg0Value_;
                arg0Value.writeBufferShort(arg1Value, arg2Value, arg3Value, (Node)this, InlinedBranchProfile.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public void writeBufferInt(Object arg0Value_, ByteOrder arg1Value, long arg2Value, int arg3Value) throws InvalidBufferOffsetException, UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                WasmMemory arg0Value = (WasmMemory)arg0Value_;
                arg0Value.writeBufferInt(arg1Value, arg2Value, arg3Value, (Node)this, InlinedBranchProfile.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public void writeBufferLong(Object arg0Value_, ByteOrder arg1Value, long arg2Value, long arg3Value) throws InvalidBufferOffsetException, UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                WasmMemory arg0Value = (WasmMemory)arg0Value_;
                arg0Value.writeBufferLong(arg1Value, arg2Value, arg3Value, (Node)this, InlinedBranchProfile.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public void writeBufferFloat(Object arg0Value_, ByteOrder arg1Value, long arg2Value, float arg3Value) throws InvalidBufferOffsetException, UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                WasmMemory arg0Value = (WasmMemory)arg0Value_;
                arg0Value.writeBufferFloat(arg1Value, arg2Value, arg3Value, (Node)this, InlinedBranchProfile.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public void writeBufferDouble(Object arg0Value_, ByteOrder arg1Value, long arg2Value, double arg3Value) throws InvalidBufferOffsetException, UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                WasmMemory arg0Value = (WasmMemory)arg0Value_;
                arg0Value.writeBufferDouble(arg1Value, arg2Value, arg3Value, (Node)this, InlinedBranchProfile.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public boolean hasArrayElements(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((WasmMemory)receiver).hasArrayElements();
            }

            @CompilerDirectives.TruffleBoundary
            public long getArraySize(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((WasmMemory)receiver).getArraySize();
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isArrayElementReadable(Object receiver, long index) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((WasmMemory)receiver).isArrayElementReadable(index);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isArrayElementModifiable(Object receiver, long index) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((WasmMemory)receiver).isArrayElementModifiable(index);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isArrayElementInsertable(Object receiver, long index) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((WasmMemory)receiver).isArrayElementInsertable(index);
            }

            @CompilerDirectives.TruffleBoundary
            public Object readArrayElement(Object arg0Value_, long arg1Value) throws InvalidArrayIndexException, UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                WasmMemory arg0Value = (WasmMemory)arg0Value_;
                return arg0Value.readArrayElement(arg1Value, (Node)this, InlinedBranchProfile.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public void writeArrayElement(Object arg0Value_, long arg1Value, Object arg2Value) throws InvalidArrayIndexException, UnsupportedMessageException, UnsupportedTypeException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                WasmMemory arg0Value = (WasmMemory)arg0Value_;
                arg0Value.writeArrayElement(arg1Value, arg2Value, (Node)this, (InteropLibrary)INTEROP_LIBRARY_.getUncached(), InlinedBranchProfile.getUncached());
            }
        }

        @GeneratedBy(value=WasmMemory.class)
        public static class Cached
        extends InteropLibrary {
            private static final InlineSupport.StateField STATE_0_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_0_");
            private static final InlinedBranchProfile INLINED_ERROR_BRANCH = InlinedBranchProfile.inline((InlineSupport.InlineTarget)InlineSupport.InlineTarget.create(InlinedBranchProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_UPDATER.subUpdater(1, 1)}));
            private final Class<? extends WasmMemory> receiverClass_;
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int state_0_;
            @Node.Child
            private InteropLibrary writeArrayElementNode__writeArrayElement_valueLib_;

            protected Cached(Object receiver) {
                WasmMemory castReceiver = (WasmMemory)receiver;
                this.receiverClass_ = castReceiver.getClass();
            }

            public boolean accepts(Object receiver) {
                assert (receiver.getClass() != this.receiverClass_ || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return CompilerDirectives.isExact((Object)receiver, this.receiverClass_);
            }

            public boolean hasBufferElements(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((WasmMemory)CompilerDirectives.castExact((Object)receiver, this.receiverClass_)).hasBufferElements();
            }

            public long getBufferSize(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((WasmMemory)CompilerDirectives.castExact((Object)receiver, this.receiverClass_)).getBufferSize();
            }

            public void readBuffer(Object arg0Value_, long arg1Value, byte[] arg2Value, int arg3Value, int arg4Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                WasmMemory arg0Value = (WasmMemory)CompilerDirectives.castExact((Object)arg0Value_, this.receiverClass_);
                Cached node__ = this;
                arg0Value.readBuffer(arg1Value, arg2Value, arg3Value, arg4Value, (Node)node__, INLINED_ERROR_BRANCH);
            }

            public byte readBufferByte(Object arg0Value_, long arg1Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                WasmMemory arg0Value = (WasmMemory)CompilerDirectives.castExact((Object)arg0Value_, this.receiverClass_);
                Cached node__ = this;
                return arg0Value.readBufferByte(arg1Value, (Node)node__, INLINED_ERROR_BRANCH);
            }

            public short readBufferShort(Object arg0Value_, ByteOrder arg1Value, long arg2Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                WasmMemory arg0Value = (WasmMemory)CompilerDirectives.castExact((Object)arg0Value_, this.receiverClass_);
                Cached node__ = this;
                return arg0Value.readBufferShort(arg1Value, arg2Value, (Node)node__, INLINED_ERROR_BRANCH);
            }

            public int readBufferInt(Object arg0Value_, ByteOrder arg1Value, long arg2Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                WasmMemory arg0Value = (WasmMemory)CompilerDirectives.castExact((Object)arg0Value_, this.receiverClass_);
                Cached node__ = this;
                return arg0Value.readBufferInt(arg1Value, arg2Value, (Node)node__, INLINED_ERROR_BRANCH);
            }

            public long readBufferLong(Object arg0Value_, ByteOrder arg1Value, long arg2Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                WasmMemory arg0Value = (WasmMemory)CompilerDirectives.castExact((Object)arg0Value_, this.receiverClass_);
                Cached node__ = this;
                return arg0Value.readBufferLong(arg1Value, arg2Value, (Node)node__, INLINED_ERROR_BRANCH);
            }

            public float readBufferFloat(Object arg0Value_, ByteOrder arg1Value, long arg2Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                WasmMemory arg0Value = (WasmMemory)CompilerDirectives.castExact((Object)arg0Value_, this.receiverClass_);
                Cached node__ = this;
                return arg0Value.readBufferFloat(arg1Value, arg2Value, (Node)node__, INLINED_ERROR_BRANCH);
            }

            public double readBufferDouble(Object arg0Value_, ByteOrder arg1Value, long arg2Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                WasmMemory arg0Value = (WasmMemory)CompilerDirectives.castExact((Object)arg0Value_, this.receiverClass_);
                Cached node__ = this;
                return arg0Value.readBufferDouble(arg1Value, arg2Value, (Node)node__, INLINED_ERROR_BRANCH);
            }

            public boolean isBufferWritable(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((WasmMemory)CompilerDirectives.castExact((Object)receiver, this.receiverClass_)).isBufferWritable();
            }

            public void writeBufferByte(Object arg0Value_, long arg1Value, byte arg2Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                WasmMemory arg0Value = (WasmMemory)CompilerDirectives.castExact((Object)arg0Value_, this.receiverClass_);
                Cached node__ = this;
                arg0Value.writeBufferByte(arg1Value, arg2Value, (Node)node__, INLINED_ERROR_BRANCH);
            }

            public void writeBufferShort(Object arg0Value_, ByteOrder arg1Value, long arg2Value, short arg3Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                WasmMemory arg0Value = (WasmMemory)CompilerDirectives.castExact((Object)arg0Value_, this.receiverClass_);
                Cached node__ = this;
                arg0Value.writeBufferShort(arg1Value, arg2Value, arg3Value, (Node)node__, INLINED_ERROR_BRANCH);
            }

            public void writeBufferInt(Object arg0Value_, ByteOrder arg1Value, long arg2Value, int arg3Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                WasmMemory arg0Value = (WasmMemory)CompilerDirectives.castExact((Object)arg0Value_, this.receiverClass_);
                Cached node__ = this;
                arg0Value.writeBufferInt(arg1Value, arg2Value, arg3Value, (Node)node__, INLINED_ERROR_BRANCH);
            }

            public void writeBufferLong(Object arg0Value_, ByteOrder arg1Value, long arg2Value, long arg3Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                WasmMemory arg0Value = (WasmMemory)CompilerDirectives.castExact((Object)arg0Value_, this.receiverClass_);
                Cached node__ = this;
                arg0Value.writeBufferLong(arg1Value, arg2Value, arg3Value, (Node)node__, INLINED_ERROR_BRANCH);
            }

            public void writeBufferFloat(Object arg0Value_, ByteOrder arg1Value, long arg2Value, float arg3Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                WasmMemory arg0Value = (WasmMemory)CompilerDirectives.castExact((Object)arg0Value_, this.receiverClass_);
                Cached node__ = this;
                arg0Value.writeBufferFloat(arg1Value, arg2Value, arg3Value, (Node)node__, INLINED_ERROR_BRANCH);
            }

            public void writeBufferDouble(Object arg0Value_, ByteOrder arg1Value, long arg2Value, double arg3Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                WasmMemory arg0Value = (WasmMemory)CompilerDirectives.castExact((Object)arg0Value_, this.receiverClass_);
                Cached node__ = this;
                arg0Value.writeBufferDouble(arg1Value, arg2Value, arg3Value, (Node)node__, INLINED_ERROR_BRANCH);
            }

            public boolean hasArrayElements(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((WasmMemory)CompilerDirectives.castExact((Object)receiver, this.receiverClass_)).hasArrayElements();
            }

            public long getArraySize(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((WasmMemory)CompilerDirectives.castExact((Object)receiver, this.receiverClass_)).getArraySize();
            }

            public boolean isArrayElementReadable(Object receiver, long index) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((WasmMemory)CompilerDirectives.castExact((Object)receiver, this.receiverClass_)).isArrayElementReadable(index);
            }

            public boolean isArrayElementModifiable(Object receiver, long index) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((WasmMemory)CompilerDirectives.castExact((Object)receiver, this.receiverClass_)).isArrayElementModifiable(index);
            }

            public boolean isArrayElementInsertable(Object receiver, long index) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((WasmMemory)CompilerDirectives.castExact((Object)receiver, this.receiverClass_)).isArrayElementInsertable(index);
            }

            public Object readArrayElement(Object arg0Value_, long arg1Value) throws UnsupportedMessageException, InvalidArrayIndexException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                WasmMemory arg0Value = (WasmMemory)CompilerDirectives.castExact((Object)arg0Value_, this.receiverClass_);
                Cached node__ = this;
                return arg0Value.readArrayElement(arg1Value, (Node)node__, INLINED_ERROR_BRANCH);
            }

            public void writeArrayElement(Object arg0Value_, long arg1Value, Object arg2Value) throws UnsupportedMessageException, UnsupportedTypeException, InvalidArrayIndexException {
                InteropLibrary valueLib__;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                WasmMemory arg0Value = (WasmMemory)CompilerDirectives.castExact((Object)arg0Value_, this.receiverClass_);
                int state_0 = this.state_0_;
                if ((state_0 & 1) != 0 && (valueLib__ = this.writeArrayElementNode__writeArrayElement_valueLib_) != null) {
                    Cached node__ = this;
                    arg0Value.writeArrayElement(arg1Value, arg2Value, (Node)node__, valueLib__, INLINED_ERROR_BRANCH);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.writeArrayElementNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            private void writeArrayElementNode_AndSpecialize(WasmMemory arg0Value, long arg1Value, Object arg2Value) throws InvalidArrayIndexException, UnsupportedMessageException, UnsupportedTypeException {
                int state_0 = this.state_0_;
                Cached node__ = null;
                node__ = this;
                InteropLibrary valueLib__ = (InteropLibrary)this.insert((Node)((InteropLibrary)INTEROP_LIBRARY_.createDispatched(3)));
                Objects.requireNonNull(valueLib__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                VarHandle.storeStoreFence();
                this.writeArrayElementNode__writeArrayElement_valueLib_ = valueLib__;
                this.state_0_ = state_0 |= 1;
                arg0Value.writeArrayElement(arg1Value, arg2Value, (Node)node__, valueLib__, INLINED_ERROR_BRANCH);
            }
        }
    }
}

