/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.nodes;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NodeField;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import org.graalvm.wasm.nodes.WasmCallNode;
import org.graalvm.wasm.nodes.WasmIndirectCallNodeGen;

@GenerateUncached
@GenerateInline(value=false)
@NodeField(name="bytecodeOffset", type=int.class)
public abstract class WasmIndirectCallNode
extends WasmCallNode {
    static final int INLINE_CACHE_LIMIT = 5;

    public abstract Object execute(CallTarget var1, Object[] var2);

    @Override
    public abstract int getBytecodeOffset();

    @Specialization(guards={"target == cachedTarget"}, limit="INLINE_CACHE_LIMIT")
    final Object doCached(CallTarget target, Object[] args, @Cached(value="target") CallTarget cachedTarget) {
        return cachedTarget.call((Node)this, args);
    }

    @Specialization(replaces={"doCached"})
    final Object doIndirect(CallTarget target, Object[] args) {
        return target.call((Node)this, args);
    }

    @NeverDefault
    public static WasmIndirectCallNode create(int bytecodeOffset) {
        return WasmIndirectCallNodeGen.create(bytecodeOffset);
    }
}

