/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.nodes;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.InstrumentableNode;
import com.oracle.truffle.api.instrumentation.ProbeNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.Source;
import java.util.Iterator;
import java.util.SortedSet;
import org.graalvm.collections.EconomicMap;
import org.graalvm.wasm.WasmConstant;
import org.graalvm.wasm.WasmModule;
import org.graalvm.wasm.collection.IntArrayList;
import org.graalvm.wasm.debugging.DebugLineMap;
import org.graalvm.wasm.debugging.data.DebugFunction;
import org.graalvm.wasm.nodes.WasmBaseStatementNode;
import org.graalvm.wasm.nodes.WasmStatementNode;

public final class WasmInstrumentationSupportNode
extends Node {
    @Node.Children
    private final WasmBaseStatementNode[] statementNodes;
    private final EconomicMap<Integer, Integer> lineToIndexMap;
    private int sourceLocation;

    @CompilerDirectives.TruffleBoundary
    public WasmInstrumentationSupportNode(DebugFunction debugFunction, WasmModule module, int functionIndex) {
        DebugLineMap sourceLineMap = debugFunction.lineMap();
        Source source = debugFunction.sourceSection().getSource();
        int startOffset = module.functionSourceCodeStartOffset(functionIndex);
        if (sourceLineMap != null && startOffset != -1) {
            int line;
            int pc;
            IntArrayList functionLines = new IntArrayList();
            int endOffset = module.functionSourceCodeEndOffset(functionIndex);
            int startElement = sourceLineMap.getLine(startOffset);
            SortedSet<Integer> lineSet = sourceLineMap.lines().tailSet(startElement);
            this.lineToIndexMap = EconomicMap.create((int)lineSet.size());
            Iterator iterator = lineSet.iterator();
            while (iterator.hasNext() && (pc = sourceLineMap.getSourceLocation(line = ((Integer)iterator.next()).intValue())) <= endOffset) {
                this.lineToIndexMap.put((Object)line, (Object)functionLines.size());
                functionLines.add(line);
            }
            int length = functionLines.size();
            this.statementNodes = length == 0 ? null : new WasmBaseStatementNode[length];
            for (int i = 0; i < length; ++i) {
                this.statementNodes[i] = new WasmStatementNode(functionLines.get(i), source);
            }
        } else {
            this.statementNodes = null;
            this.lineToIndexMap = null;
        }
    }

    public void notifyLine(VirtualFrame frame, int currentLine, int nextLine, int currentSourceLocation) {
        CompilerAsserts.partialEvaluationConstant((int)currentLine);
        CompilerAsserts.partialEvaluationConstant((int)nextLine);
        int currentLineIndex = this.lineIndexOrDefault(currentLine);
        int nextLineIndex = this.lineIndexOrDefault(nextLine);
        if (currentLineIndex == nextLineIndex) {
            return;
        }
        this.sourceLocation = currentSourceLocation;
        this.exitAt(frame, currentLineIndex);
        this.enterAt(frame, nextLineIndex);
    }

    @CompilerDirectives.TruffleBoundary
    private int lineIndexOrDefault(int line) {
        return (Integer)this.lineToIndexMap.get((Object)line, (Object)-1);
    }

    private void enterAt(VirtualFrame frame, int lineIndex) {
        InstrumentableNode.WrapperNode wrapperNode = this.getWrapperAt(lineIndex);
        if (wrapperNode == null) {
            return;
        }
        ProbeNode probeNode = wrapperNode.getProbeNode();
        try {
            probeNode.onEnter(frame);
        }
        catch (Throwable t) {
            Object result = probeNode.onReturnExceptionalOrUnwind(frame, t, false);
            if (result == ProbeNode.UNWIND_ACTION_REENTER) {
                CompilerDirectives.transferToInterpreter();
                throw new UnsupportedOperationException();
            }
            if (result != null) {
                return;
            }
            throw t;
        }
    }

    private void exitAt(VirtualFrame frame, int lineIndex) {
        InstrumentableNode.WrapperNode wrapperNode = this.getWrapperAt(lineIndex);
        if (wrapperNode == null) {
            return;
        }
        ProbeNode probeNode = wrapperNode.getProbeNode();
        try {
            probeNode.onReturnValue(frame, (Object)WasmConstant.VOID);
        }
        catch (Throwable t) {
            Object result = probeNode.onReturnExceptionalOrUnwind(frame, t, true);
            if (result == ProbeNode.UNWIND_ACTION_REENTER) {
                CompilerDirectives.transferToInterpreter();
                throw new UnsupportedOperationException();
            }
            if (result != null) {
                return;
            }
            throw t;
        }
    }

    @CompilerDirectives.TruffleBoundary
    private InstrumentableNode.WrapperNode getWrapperAt(int lineIndex) {
        if (this.statementNodes == null || lineIndex < 0 || lineIndex > this.statementNodes.length) {
            return null;
        }
        WasmBaseStatementNode node = this.statementNodes[lineIndex];
        if (!(node instanceof InstrumentableNode.WrapperNode)) {
            return null;
        }
        CompilerAsserts.partialEvaluationConstant((Object)((Object)node));
        return (InstrumentableNode.WrapperNode)node;
    }

    public int currentSourceLocation() {
        return this.sourceLocation;
    }
}

