/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.parser.validation;

import org.graalvm.wasm.Assert;
import org.graalvm.wasm.WasmType;
import org.graalvm.wasm.api.Vector128;
import org.graalvm.wasm.collection.ByteArrayList;
import org.graalvm.wasm.exception.Failure;
import org.graalvm.wasm.parser.bytecode.RuntimeBytecodeGen;
import org.graalvm.wasm.parser.validation.BlockFrame;
import org.graalvm.wasm.parser.validation.ControlFrame;
import org.graalvm.wasm.parser.validation.ControlStack;
import org.graalvm.wasm.parser.validation.IfFrame;
import org.graalvm.wasm.parser.validation.LoopFrame;
import org.graalvm.wasm.parser.validation.ValidationErrors;

public class ParserState {
    private static final byte[] EMPTY_ARRAY = new byte[0];
    private static final byte ANY = 0;
    private final ByteArrayList valueStack = new ByteArrayList();
    private final ControlStack controlStack = new ControlStack();
    private final RuntimeBytecodeGen bytecode;
    private int maxStackSize;
    private boolean usesMemoryZero;

    public ParserState(RuntimeBytecodeGen bytecode) {
        this.bytecode = bytecode;
        this.maxStackSize = 0;
    }

    private byte popInternal(byte expectedValueType) {
        if (this.availableStackSize() == 0) {
            if (this.isCurrentStackUnreachable()) {
                return -1;
            }
            if (expectedValueType == 0) {
                throw ValidationErrors.createExpectedAnyOnEmptyStack();
            }
            throw ValidationErrors.createExpectedTypeOnEmptyStack(expectedValueType);
        }
        return this.valueStack.popBack();
    }

    private byte[] popAvailableUnchecked(byte[] expectedValueTypes) {
        int availableStackSize = this.availableStackSize();
        int availableSize = Math.min(availableStackSize, expectedValueTypes.length);
        byte[] popped = new byte[availableSize];
        for (int i = availableSize - 1; i >= 0; --i) {
            popped[i] = this.popInternal(expectedValueTypes[i]);
        }
        return popped;
    }

    private byte[] popAvailableUnchecked() {
        int availableStackSize = this.availableStackSize();
        byte[] popped = new byte[availableStackSize];
        int j = 0;
        for (int i = availableStackSize - 1; i >= 0; --i) {
            popped[j] = this.popInternal((byte)0);
            ++j;
        }
        return popped;
    }

    private boolean isTypeMismatch(byte[] expectedTypes, byte[] actualTypes) {
        if (expectedTypes.length != actualTypes.length) {
            return true;
        }
        if (this.isCurrentStackUnreachable()) {
            return false;
        }
        for (int i = 0; i < expectedTypes.length; ++i) {
            if (expectedTypes[i] == actualTypes[i]) continue;
            return true;
        }
        return false;
    }

    public void push(byte valueType) {
        this.valueStack.push(valueType);
        this.maxStackSize = Math.max(this.valueStack.size(), this.maxStackSize);
    }

    public void pushAll(byte[] valueTypes) {
        for (byte valueType : valueTypes) {
            this.push(valueType);
        }
    }

    public byte pop() {
        return this.popInternal((byte)0);
    }

    public byte popChecked(byte expectedValueType) {
        byte actualValueType = this.popInternal(expectedValueType);
        if (actualValueType != expectedValueType && actualValueType != -1 && expectedValueType != -1) {
            throw ValidationErrors.createTypeMismatch(expectedValueType, actualValueType);
        }
        return actualValueType;
    }

    public void popReferenceTypeChecked() {
        if (this.availableStackSize() != 0) {
            byte value = this.valueStack.popBack();
            if (WasmType.isReferenceType(value)) {
                return;
            }
            this.valueStack.push(value);
        }
        this.popChecked((byte)112);
    }

    public byte[] popAll(byte[] expectedValueTypes) {
        byte[] popped = new byte[expectedValueTypes.length];
        for (int i = expectedValueTypes.length - 1; i >= 0; --i) {
            popped[i] = this.popChecked(expectedValueTypes[i]);
        }
        return popped;
    }

    private int availableStackSize() {
        return this.valueStack.size() - this.controlStack.peek().initialStackSize();
    }

    private boolean isCurrentStackUnreachable() {
        return this.controlStack.peek().isUnreachable();
    }

    private void unwindStack(int size) {
        assert (Integer.compareUnsigned(size, this.valueStack.size()) <= 0) : "invalid stack shrink size";
        while (this.valueStack.size() > size) {
            this.valueStack.popBack();
        }
    }

    public void enterFunction(byte[] resultTypes) {
        this.enterBlock(EMPTY_ARRAY, resultTypes);
    }

    public void enterBlock(byte[] paramTypes, byte[] resultTypes) {
        BlockFrame frame = new BlockFrame(paramTypes, resultTypes, this.valueStack.size(), false);
        this.controlStack.push(frame);
        this.pushAll(paramTypes);
    }

    public void enterLoop(byte[] paramTypes, byte[] resultTypes) {
        int label = this.bytecode.addLoopLabel(paramTypes.length, this.valueStack.size(), WasmType.getCommonValueType(resultTypes));
        LoopFrame frame = new LoopFrame(paramTypes, resultTypes, this.valueStack.size(), false, label);
        this.controlStack.push(frame);
        this.pushAll(paramTypes);
    }

    public void enterIf(byte[] paramTypes, byte[] resultTypes) {
        int fixupLocation = this.bytecode.addIfLocation();
        IfFrame frame = new IfFrame(paramTypes, resultTypes, this.valueStack.size(), false, fixupLocation);
        this.controlStack.push(frame);
        this.pushAll(paramTypes);
    }

    public void enterElse() {
        ControlFrame frame = this.controlStack.peek();
        frame.enterElse(this, this.bytecode);
        this.pushAll(frame.paramTypes());
    }

    public void addInstruction(int instruction) {
        this.bytecode.add(instruction);
    }

    public void addConditionalBranch(int branchLabel) {
        this.checkLabelExists(branchLabel);
        ControlFrame frame = this.getFrame(branchLabel);
        byte[] labelTypes = frame.labelTypes();
        this.popAll(labelTypes);
        this.pushAll(labelTypes);
        frame.addBranchIf(this.bytecode);
    }

    public void addUnconditionalBranch(int branchLabel) {
        this.checkLabelExists(branchLabel);
        ControlFrame frame = this.getFrame(branchLabel);
        byte[] labelTypes = frame.labelTypes();
        this.popAll(labelTypes);
        frame.addBranch(this.bytecode);
    }

    public void addBranchTable(int[] branchLabels) {
        this.bytecode.addBranchTable(branchLabels.length);
        int branchLabel = branchLabels[branchLabels.length - 1];
        this.checkLabelExists(branchLabel);
        ControlFrame frame = this.getFrame(branchLabel);
        byte[] branchLabelReturnTypes = frame.labelTypes();
        for (int otherBranchLabel : branchLabels) {
            this.checkLabelExists(otherBranchLabel);
            frame = this.getFrame(otherBranchLabel);
            byte[] otherBranchLabelReturnTypes = frame.labelTypes();
            this.checkLabelTypes(branchLabelReturnTypes, otherBranchLabelReturnTypes);
            this.pushAll(this.popAll(otherBranchLabelReturnTypes));
            frame.addBranchTableItem(this.bytecode);
        }
        this.popAll(branchLabelReturnTypes);
    }

    public void addReturn(boolean multiValue) {
        ControlFrame frame = this.getRootBlock();
        if (!multiValue) {
            Assert.assertIntLessOrEqual(frame.labelTypeLength(), 1, Failure.INVALID_RESULT_ARITY);
        }
        this.checkResultTypes(frame);
        this.bytecode.add(4);
    }

    public void addIndirectCall(int nodeIndex, int typeIndex, int tableIndex) {
        this.bytecode.addIndirectCall(nodeIndex, typeIndex, tableIndex);
    }

    public void addCall(int nodeIndex, int functionIndex) {
        this.bytecode.addCall(nodeIndex, functionIndex);
    }

    public void addMiscFlag() {
        this.bytecode.add(251);
    }

    public void addAtomicFlag() {
        this.bytecode.add(252);
    }

    public void addVectorFlag() {
        this.bytecode.add(253);
    }

    public void addInstruction(int instruction, int value) {
        this.bytecode.add(instruction, value);
    }

    public void addInstruction(int instruction, long value) {
        this.bytecode.add(instruction, value);
    }

    public void addInstruction(int instruction, Vector128 value) {
        this.bytecode.add(instruction, value);
    }

    public void addInstruction(int instruction, int value1, int value2) {
        this.bytecode.add(instruction, value1, value2);
    }

    public void addSignedInstruction(int instruction, int value) {
        this.bytecode.addSigned(instruction, instruction + 1, value);
    }

    public void addSignedInstruction(int instruction, long value) {
        this.bytecode.addSigned(instruction, instruction + 1, value);
    }

    public void addUnsignedInstruction(int instruction, int value) {
        this.bytecode.addUnsigned(instruction, instruction + 1, value);
    }

    public void addMemoryInstruction(int baseInstruction, int memoryIndex, long value, boolean indexType64) {
        this.markMemoryUsed(memoryIndex);
        this.bytecode.addMemoryInstruction(baseInstruction, baseInstruction + 1, baseInstruction + 2, memoryIndex, value, indexType64);
    }

    public void addExtendedMemoryInstruction(int instruction, int memoryIndex, long value, boolean indexType64) {
        this.markMemoryUsed(memoryIndex);
        this.bytecode.addExtendedMemoryInstruction(instruction, memoryIndex, value, indexType64);
    }

    public void addVectorMemoryLaneInstruction(int instruction, int memoryIndex, long value, boolean indexType64, byte laneIndex) {
        this.markMemoryUsed(memoryIndex);
        this.bytecode.addExtendedMemoryInstruction(instruction, memoryIndex, value, indexType64);
        this.bytecode.add(laneIndex);
    }

    public void addVectorLaneInstruction(int instruction, byte laneIndex) {
        this.bytecode.add(instruction);
        this.bytecode.add(laneIndex);
    }

    public void exit(boolean multiValue) {
        Assert.assertTrue(!this.controlStack.isEmpty(), Failure.UNEXPECTED_END_OF_BLOCK);
        ControlFrame frame = this.controlStack.peek();
        byte[] resultTypes = frame.resultTypes();
        frame.exit(this.bytecode);
        this.checkStackAfterFrameExit(frame, resultTypes);
        this.controlStack.pop();
        if (!multiValue) {
            Assert.assertIntLessOrEqual(resultTypes.length, 1, "A block cannot return more than one value.", Failure.INVALID_RESULT_ARITY);
        }
        this.pushAll(resultTypes);
    }

    void checkStackAfterFrameExit(ControlFrame frame, byte[] resultTypes) {
        byte[] actualTypes;
        if (this.availableStackSize() > resultTypes.length && this.isTypeMismatch(resultTypes, actualTypes = this.popAvailableUnchecked())) {
            throw ValidationErrors.createResultTypesMismatch(resultTypes, actualTypes);
        }
        this.checkResultTypes(frame);
    }

    public ControlFrame getFrame(int index) {
        return this.controlStack.get(index);
    }

    public ControlFrame getRootBlock() {
        return this.controlStack.getFirst();
    }

    private void checkResultTypes(ControlFrame frame) {
        byte[] resultTypes = frame.resultTypes();
        if (this.isCurrentStackUnreachable()) {
            this.popAll(resultTypes);
        } else {
            byte[] actualTypes = this.popAvailableUnchecked(resultTypes);
            if (this.isTypeMismatch(resultTypes, actualTypes)) {
                throw ValidationErrors.createResultTypesMismatch(resultTypes, actualTypes);
            }
        }
    }

    public void checkParamTypes(byte[] paramTypes) {
        if (this.isCurrentStackUnreachable()) {
            this.popAll(paramTypes);
        } else {
            byte[] actualTypes = this.popAvailableUnchecked(paramTypes);
            if (this.isTypeMismatch(paramTypes, actualTypes)) {
                throw ValidationErrors.createParamTypesMismatch(paramTypes, actualTypes);
            }
        }
    }

    public void checkLabelExists(int label) {
        if (Integer.compareUnsigned(label, this.controlStackSize()) >= 0) {
            throw ValidationErrors.createMissingLabel(label, this.controlStackSize() - 1);
        }
    }

    public void checkLabelTypes(byte[] expectedTypes, byte[] actualTypes) {
        if (this.isTypeMismatch(expectedTypes, actualTypes)) {
            throw ValidationErrors.createLabelTypesMismatch(expectedTypes, actualTypes);
        }
    }

    public void checkFunctionTypeExists(int typeIndex, int max) {
        if (Integer.compareUnsigned(typeIndex, max) >= 0) {
            throw ValidationErrors.createMissingFunctionType(typeIndex, max - 1);
        }
    }

    public void setUnreachable() {
        ControlFrame frame = this.controlStack.peek();
        this.unwindStack(frame.initialStackSize());
        frame.setUnreachable();
    }

    public int controlStackSize() {
        return this.controlStack.size();
    }

    public int valueStackSize() {
        return this.valueStack.size();
    }

    public int maxStackSize() {
        return this.maxStackSize;
    }

    private void markMemoryUsed(int memoryIndex) {
        if (memoryIndex == 0) {
            this.usesMemoryZero = true;
        }
    }

    public boolean usesMemoryZero() {
        return this.usesMemoryZero;
    }
}

