/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.predefined;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.RootCallTarget;
import java.util.Map;
import org.graalvm.wasm.WasmContext;
import org.graalvm.wasm.WasmFunction;
import org.graalvm.wasm.WasmInstance;
import org.graalvm.wasm.WasmLanguage;
import org.graalvm.wasm.WasmModule;
import org.graalvm.wasm.exception.Failure;
import org.graalvm.wasm.exception.WasmException;
import org.graalvm.wasm.nodes.WasmRootNode;
import org.graalvm.wasm.predefined.emscripten.EmscriptenModule;
import org.graalvm.wasm.predefined.go.GoModule;
import org.graalvm.wasm.predefined.spectest.SpectestModule;
import org.graalvm.wasm.predefined.testutil.TestutilModule;
import org.graalvm.wasm.predefined.wasi.WasiModule;

public abstract class BuiltinModule {
    private static final Map<String, BuiltinModule> predefinedModules = Map.of("emscripten", new EmscriptenModule(), "testutil", new TestutilModule(), "wasi_snapshot_preview1", new WasiModule(), "spectest", new SpectestModule(), "go", new GoModule());

    public static WasmInstance createBuiltinInstance(WasmLanguage language, WasmContext context, String name, String predefinedModuleName) {
        CompilerAsserts.neverPartOfCompilation();
        BuiltinModule builtinModule = predefinedModules.get(predefinedModuleName);
        if (builtinModule == null) {
            throw WasmException.create(Failure.UNSPECIFIED_INVALID, "Unknown predefined module: " + predefinedModuleName);
        }
        return builtinModule.createInstance(language, context, name);
    }

    protected BuiltinModule() {
    }

    protected abstract WasmModule createModule(WasmLanguage var1, WasmContext var2, String var3);

    protected WasmInstance createInstance(WasmLanguage language, WasmContext context, String name) {
        WasmModule module = language.getOrCreateBuiltinModule(this, bm -> this.createModule(language, context, name));
        WasmInstance instance = new WasmInstance(context, module);
        instance.createLinkActions();
        boolean multiContext = context.language().isMultiContext();
        for (int i = 0; i < module.numFunctions(); ++i) {
            CallTarget target = module.function(i).target();
            if (target == null || instance.target(i) != null) continue;
            instance.setTarget(i, target);
            if (multiContext) continue;
            ((WasmRootNode)((RootCallTarget)target).getRootNode()).setBoundModuleInstance(instance);
        }
        return instance;
    }

    protected WasmFunction defineFunction(WasmContext context, WasmModule module, String name, byte[] paramTypes, byte[] retTypes, WasmRootNode rootNode) {
        assert (context.language() == rootNode.getLanguage(WasmLanguage.class));
        int typeIdx = module.symbolTable().allocateFunctionType(paramTypes, retTypes, context.getContextOptions().supportMultiValue());
        WasmFunction function = module.symbolTable().declareExportedFunction(typeIdx, name);
        function.setTarget((CallTarget)rootNode.getCallTarget());
        return function;
    }

    protected int defineGlobal(WasmModule module, String name, byte valueType, byte mutability, Object value) {
        int index = module.symbolTable().numGlobals();
        module.symbolTable().declareExportedGlobalWithValue(name, index, valueType, mutability, value);
        return index;
    }

    protected int defineTable(WasmContext context, WasmModule module, String tableName, int initSize, int maxSize, byte type) {
        boolean referenceTypes = context.getContextOptions().supportBulkMemoryAndRefTypes();
        switch (type) {
            case 112: {
                break;
            }
            case 111: {
                if (referenceTypes) break;
                throw WasmException.create(Failure.UNSPECIFIED_MALFORMED, "Only function types are currently supported in tables.");
            }
            default: {
                throw WasmException.create(Failure.MALFORMED_REFERENCE_TYPE, "Only reference types supported in tables.");
            }
        }
        int index = module.symbolTable().tableCount();
        module.symbolTable().allocateTable(index, initSize, maxSize, type, referenceTypes);
        module.symbolTable().exportTable(index, tableName);
        return index;
    }

    protected void defineMemory(WasmContext context, WasmModule module, String memoryName, int initSize, int maxSize, boolean is64Bit, boolean isShared) {
        boolean useUnsafeMemory = context.getContextOptions().useUnsafeMemory();
        int index = module.symbolTable().memoryCount();
        module.symbolTable().allocateMemory(index, initSize, maxSize, is64Bit, isShared, true, useUnsafeMemory);
        module.symbolTable().exportMemory(index, memoryName);
    }

    protected void importFunction(WasmContext context, WasmModule module, String importModuleName, String importFunctionName, byte[] paramTypes, byte[] retTypes, String exportName) {
        int typeIdx = module.symbolTable().allocateFunctionType(paramTypes, retTypes, context.getContextOptions().supportMultiValue());
        WasmFunction function = module.symbolTable().importFunction(importModuleName, importFunctionName, typeIdx);
        module.symbolTable().exportFunction(function.index(), exportName);
    }

    protected void importMemory(WasmContext context, WasmModule module, String importModuleName, String memoryName, int initSize, long maxSize, boolean is64Bit, boolean isShared) {
        boolean multiMemory = context.getContextOptions().supportMultiMemory();
        boolean useUnsafeMemory = context.getContextOptions().useUnsafeMemory();
        int index = module.symbolTable().memoryCount();
        module.symbolTable().importMemory(importModuleName, memoryName, index, initSize, maxSize, is64Bit, isShared, multiMemory, useUnsafeMemory);
    }

    protected static byte[] types(byte ... args) {
        return args;
    }
}

