/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.predefined.emscripten;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import org.graalvm.wasm.WasmArguments;
import org.graalvm.wasm.WasmContext;
import org.graalvm.wasm.WasmInstance;
import org.graalvm.wasm.WasmLanguage;
import org.graalvm.wasm.WasmModule;
import org.graalvm.wasm.exception.Failure;
import org.graalvm.wasm.exception.WasmException;
import org.graalvm.wasm.predefined.WasmBuiltinRootNode;

public class AbortNode
extends WasmBuiltinRootNode {
    public AbortNode(WasmLanguage language, WasmModule module) {
        super(language, module);
    }

    @Override
    public Object executeWithContext(VirtualFrame frame, WasmContext context, WasmInstance instance) {
        Object[] args = frame.getArguments();
        int code = WasmArguments.getArgumentCount(args) > 0 ? (Integer)WasmArguments.getArgument(args, 0) : 0;
        throw this.fail(code);
    }

    @Override
    public String builtinNodeName() {
        return "abort";
    }

    @CompilerDirectives.TruffleBoundary
    private WasmException fail(int code) {
        throw WasmException.format(Failure.UNSPECIFIED_TRAP, (Node)this, "Program aborted: %d", code);
    }
}

