/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.predefined.emscripten;

import org.graalvm.wasm.WasmContext;
import org.graalvm.wasm.WasmLanguage;
import org.graalvm.wasm.WasmModule;
import org.graalvm.wasm.predefined.BuiltinModule;
import org.graalvm.wasm.predefined.emscripten.AbortNode;
import org.graalvm.wasm.predefined.emscripten.AbortOnCannotGrowMemoryNode;
import org.graalvm.wasm.predefined.emscripten.AlignfaultNode;
import org.graalvm.wasm.predefined.emscripten.EmscriptenGetHeapSizeNode;
import org.graalvm.wasm.predefined.emscripten.EmscriptenMemcpyBigNode;
import org.graalvm.wasm.predefined.emscripten.EmscriptenNotifyMemoryGrowthNode;
import org.graalvm.wasm.predefined.emscripten.EmscriptenResizeHeapNode;
import org.graalvm.wasm.predefined.emscripten.GetTimeOfDayNode;
import org.graalvm.wasm.predefined.emscripten.LLVMExp2F64Node;
import org.graalvm.wasm.predefined.emscripten.LockNode;
import org.graalvm.wasm.predefined.emscripten.SegfaultNode;
import org.graalvm.wasm.predefined.emscripten.SetErrNoNode;
import org.graalvm.wasm.predefined.emscripten.UnimplementedNode;
import org.graalvm.wasm.predefined.emscripten.UnlockNode;
import org.graalvm.wasm.predefined.wasi.WasiFdWriteNode;

public class EmscriptenModule
extends BuiltinModule {
    @Override
    protected WasmModule createModule(WasmLanguage language, WasmContext context, String name) {
        WasmModule module = WasmModule.createBuiltin(name);
        this.defineFunction(context, module, "abort", EmscriptenModule.types(new byte[0]), EmscriptenModule.types(new byte[0]), new AbortNode(language, module));
        this.defineFunction(context, module, "abortOnCannotGrowMemory", EmscriptenModule.types(127), EmscriptenModule.types(127), new AbortOnCannotGrowMemoryNode(language, module));
        this.defineFunction(context, module, "segfault", EmscriptenModule.types(new byte[0]), EmscriptenModule.types(new byte[0]), new SegfaultNode(language, module));
        this.defineFunction(context, module, "alignfault", EmscriptenModule.types(new byte[0]), EmscriptenModule.types(new byte[0]), new AlignfaultNode(language, module));
        this.defineFunction(context, module, "emscripten_memcpy_big", EmscriptenModule.types(127, 127, 127), EmscriptenModule.types(127), new EmscriptenMemcpyBigNode(language, module));
        this.defineFunction(context, module, "emscripten_get_heap_size", EmscriptenModule.types(new byte[0]), EmscriptenModule.types(127), new EmscriptenGetHeapSizeNode(language, module));
        this.defineFunction(context, module, "emscripten_resize_heap", EmscriptenModule.types(127), EmscriptenModule.types(127), new EmscriptenResizeHeapNode(language, module));
        this.defineFunction(context, module, "emscripten_notify_memory_growth", EmscriptenModule.types(127), EmscriptenModule.types(new byte[0]), new EmscriptenNotifyMemoryGrowthNode(language, module));
        this.defineFunction(context, module, "gettimeofday", EmscriptenModule.types(127, 127), EmscriptenModule.types(127), new GetTimeOfDayNode(language, module));
        this.defineFunction(context, module, "llvm_exp2_f64", EmscriptenModule.types(124), EmscriptenModule.types(124), new LLVMExp2F64Node(language, module));
        this.defineFunction(context, module, "__wasi_fd_write", EmscriptenModule.types(127, 127, 127, 127), EmscriptenModule.types(127), new WasiFdWriteNode(language, module));
        this.defineFunction(context, module, "__lock", EmscriptenModule.types(127), EmscriptenModule.types(new byte[0]), new LockNode(language, module));
        this.defineFunction(context, module, "__unlock", EmscriptenModule.types(127), EmscriptenModule.types(new byte[0]), new UnlockNode(language, module));
        this.defineFunction(context, module, "__setErrNo", EmscriptenModule.types(127), EmscriptenModule.types(new byte[0]), new SetErrNoNode(language, module));
        this.defineFunction(context, module, "__syscall140", EmscriptenModule.types(127, 127), EmscriptenModule.types(127), new UnimplementedNode("__syscall140", language, module));
        this.defineFunction(context, module, "__syscall146", EmscriptenModule.types(127, 127), EmscriptenModule.types(127), new UnimplementedNode("__syscall146", language, module));
        this.defineFunction(context, module, "__syscall54", EmscriptenModule.types(127, 127), EmscriptenModule.types(127), new UnimplementedNode("__syscall54", language, module));
        this.defineFunction(context, module, "__syscall6", EmscriptenModule.types(127, 127), EmscriptenModule.types(127), new UnimplementedNode("__syscall6", language, module));
        this.defineFunction(context, module, "setTempRet0", EmscriptenModule.types(127), EmscriptenModule.types(new byte[0]), new UnimplementedNode("setTempRet0", language, module));
        this.defineGlobal(module, "_table_base", (byte)127, (byte)0, 0);
        this.defineGlobal(module, "_memory_base", (byte)127, (byte)0, 0);
        this.defineGlobal(module, "DYNAMICTOP_PTR", (byte)127, (byte)0, 0);
        this.defineGlobal(module, "DYNAMIC_BASE", (byte)127, (byte)0, 0);
        this.defineTable(context, module, "table", 0, -1, (byte)112);
        return module;
    }
}

