/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.predefined.testutil;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import java.util.function.Consumer;
import org.graalvm.wasm.WasmArguments;
import org.graalvm.wasm.WasmConstant;
import org.graalvm.wasm.WasmContext;
import org.graalvm.wasm.WasmInstance;
import org.graalvm.wasm.WasmLanguage;
import org.graalvm.wasm.WasmModule;
import org.graalvm.wasm.predefined.WasmBuiltinRootNode;

public class RunCustomInitializationNode
extends WasmBuiltinRootNode {
    public RunCustomInitializationNode(WasmLanguage language, WasmModule module) {
        super(language, module);
    }

    @Override
    public Object executeWithContext(VirtualFrame frame, WasmContext context, WasmInstance instance) {
        RunCustomInitializationNode.initializeModule(WasmArguments.getArgument(frame.getArguments(), 0));
        return WasmConstant.VOID;
    }

    @Override
    public String builtinNodeName() {
        return "__testutil_run_custom_initialization";
    }

    @CompilerDirectives.TruffleBoundary
    private static void initializeModule(Object initialization) {
        if (initialization != null) {
            WasmContext context = WasmContext.get(null);
            ((Consumer)initialization).accept(context);
        }
    }
}

