/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.predefined.wasi;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import org.graalvm.wasm.WasmArguments;
import org.graalvm.wasm.WasmContext;
import org.graalvm.wasm.WasmInstance;
import org.graalvm.wasm.WasmLanguage;
import org.graalvm.wasm.WasmModule;
import org.graalvm.wasm.memory.WasmMemory;
import org.graalvm.wasm.predefined.WasmBuiltinRootNode;
import org.graalvm.wasm.predefined.wasi.fd.Fd;
import org.graalvm.wasm.predefined.wasi.types.Errno;

public final class WasiFdPrestatDirNameNode
extends WasmBuiltinRootNode {
    public WasiFdPrestatDirNameNode(WasmLanguage language, WasmModule module) {
        super(language, module);
    }

    @Override
    public Object executeWithContext(VirtualFrame frame, WasmContext context, WasmInstance instance) {
        Object[] args = frame.getArguments();
        return this.fdPrestatDirName(context, this.memory(frame), (Integer)WasmArguments.getArgument(args, 0), (Integer)WasmArguments.getArgument(args, 1), (Integer)WasmArguments.getArgument(args, 2));
    }

    @CompilerDirectives.TruffleBoundary
    private int fdPrestatDirName(WasmContext context, WasmMemory memory, int fd, int pathAddress, int pathLength) {
        Fd handle = context.fdManager().get(fd);
        if (handle == null) {
            return Errno.Badf.ordinal();
        }
        return handle.prestatDirName((Node)this, memory, pathAddress, pathLength).ordinal();
    }

    @Override
    public String builtinNodeName() {
        return "__wasi_fd_prestat_dir_name";
    }
}

