/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.predefined.wasi.fd;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.nodes.Node;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotLinkException;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.graalvm.wasm.memory.WasmMemory;
import org.graalvm.wasm.predefined.wasi.FlagUtils;
import org.graalvm.wasm.predefined.wasi.WasiClockTimeGetNode;
import org.graalvm.wasm.predefined.wasi.fd.Fd;
import org.graalvm.wasm.predefined.wasi.fd.FdManager;
import org.graalvm.wasm.predefined.wasi.fd.FdUtils;
import org.graalvm.wasm.predefined.wasi.fd.FileFd;
import org.graalvm.wasm.predefined.wasi.fd.PreopenedDirectory;
import org.graalvm.wasm.predefined.wasi.types.Errno;
import org.graalvm.wasm.predefined.wasi.types.Fdflags;
import org.graalvm.wasm.predefined.wasi.types.Filetype;
import org.graalvm.wasm.predefined.wasi.types.Fstflags;
import org.graalvm.wasm.predefined.wasi.types.Lookupflags;
import org.graalvm.wasm.predefined.wasi.types.Oflags;
import org.graalvm.wasm.predefined.wasi.types.Rights;

class DirectoryFd
extends Fd {
    private final FdManager fdManager;
    private final PreopenedDirectory preopenedRoot;
    private final TruffleFile virtualFile;

    protected DirectoryFd(FdManager fdManager, TruffleFile virtualFile, PreopenedDirectory preopenedRoot, long fsRightsBase, long fsRightsInheriting, short fsFlags) {
        super(Filetype.Directory, fsRightsBase, fsRightsInheriting, fsFlags);
        this.fdManager = fdManager;
        this.virtualFile = virtualFile.normalize();
        this.preopenedRoot = preopenedRoot;
    }

    private TruffleFile resolveVirtualFile(Node node, WasmMemory memory, int pathAddress, int pathLength) {
        String path = memory.readString(pathAddress, pathLength, node);
        return this.preopenedRoot.containedVirtualFile(this.virtualFile.resolve(path));
    }

    private static TruffleFile resolveVirtualFile(Node node, WasmMemory memory, DirectoryFd fd, int pathAddress, int pathLength) {
        String path = memory.readString(pathAddress, pathLength, node);
        return fd.preopenedRoot.containedVirtualFile(fd.virtualFile.resolve(path));
    }

    private TruffleFile resolveHostFile(Node node, WasmMemory memory, int pathAddress, int pathLength) {
        TruffleFile virtualChildFile = this.resolveVirtualFile(node, memory, pathAddress, pathLength);
        if (virtualChildFile == null) {
            return null;
        }
        return this.preopenedRoot.virtualFileToHostFile(virtualChildFile);
    }

    private static TruffleFile resolveHostFile(Node node, WasmMemory memory, DirectoryFd fd, int pathAddress, int pathLength) {
        TruffleFile virtualChildFile = DirectoryFd.resolveVirtualFile(node, memory, fd, pathAddress, pathLength);
        if (virtualChildFile == null) {
            return null;
        }
        return fd.preopenedRoot.virtualFileToHostFile(virtualChildFile);
    }

    private TruffleFile resolveHostFile(Node node, WasmMemory memory, int pathAddress, int pathLength, int lookupFlags) throws IOException, SecurityException {
        TruffleFile hostFile = this.resolveHostFile(node, memory, pathAddress, pathLength);
        if (hostFile == null) {
            return null;
        }
        if (FlagUtils.isSet(lookupFlags, Lookupflags.SymlinkFollow) && hostFile.exists(new LinkOption[0])) {
            hostFile = this.preopenedRoot.containedHostFile(hostFile.getCanonicalFile(new LinkOption[0]));
        }
        return hostFile;
    }

    private TruffleFile resolveHostFile(TruffleFile virtualChildFile, int lookupFlags) throws IOException, SecurityException {
        if (virtualChildFile == null) {
            return null;
        }
        TruffleFile hostFile = this.preopenedRoot.virtualFileToHostFile(virtualChildFile);
        if (hostFile == null) {
            return null;
        }
        if (FlagUtils.isSet(lookupFlags, Lookupflags.SymlinkFollow) && hostFile.exists(new LinkOption[0])) {
            hostFile = this.preopenedRoot.containedHostFile(hostFile.getCanonicalFile(new LinkOption[0]));
        }
        return hostFile;
    }

    @Override
    public Errno filestatGet(Node node, WasmMemory memory, int resultAddress) {
        if (!FlagUtils.isSet(this.fsRightsBase, Rights.FdFilestatGet)) {
            return Errno.Notcapable;
        }
        return FdUtils.writeFilestat(node, memory, resultAddress, this.virtualFile);
    }

    @Override
    public Errno pathCreateDirectory(Node node, WasmMemory memory, int pathAddress, int pathLength) {
        if (!FlagUtils.isSet(this.fsRightsBase, Rights.PathCreateDirectory)) {
            return Errno.Notcapable;
        }
        TruffleFile hostChildFile = this.resolveHostFile(node, memory, pathAddress, pathLength);
        if (hostChildFile == null) {
            return Errno.Noent;
        }
        try {
            hostChildFile.createDirectory(new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException e) {
            return Errno.Exist;
        }
        catch (IOException | UnsupportedOperationException e) {
            return Errno.Io;
        }
        catch (SecurityException e) {
            return Errno.Acces;
        }
        return Errno.Success;
    }

    @Override
    public Errno pathFilestatGet(Node node, WasmMemory memory, int flags, int pathAddress, int pathLength, int resultAddress) {
        TruffleFile hostChildFile;
        if (!FlagUtils.isSet(this.fsRightsBase, Rights.PathFilestatGet)) {
            return Errno.Notcapable;
        }
        try {
            hostChildFile = this.resolveHostFile(node, memory, pathAddress, pathLength, flags);
        }
        catch (IOException e) {
            return Errno.Io;
        }
        catch (SecurityException e) {
            return Errno.Acces;
        }
        if (hostChildFile == null) {
            return Errno.Noent;
        }
        return FdUtils.writeFilestat(node, memory, resultAddress, hostChildFile);
    }

    @Override
    public Errno pathFilestatSetTimes(Node node, WasmMemory memory, int flags, int pathAddress, int pathLength, long atim, long mtim, int fstFlags) {
        TruffleFile hostChildFile;
        if (!FlagUtils.isSet(this.fsRightsBase, Rights.PathFilestatSetTimes)) {
            return Errno.Notcapable;
        }
        try {
            hostChildFile = this.resolveHostFile(node, memory, pathAddress, pathLength, flags);
        }
        catch (IOException e) {
            return Errno.Io;
        }
        catch (SecurityException e) {
            return Errno.Acces;
        }
        if (hostChildFile == null) {
            return Errno.Noent;
        }
        try {
            if (FlagUtils.isSet(fstFlags, Fstflags.Atim)) {
                hostChildFile.setLastAccessTime(FileTime.from(atim, TimeUnit.NANOSECONDS), new LinkOption[0]);
            }
            if (FlagUtils.isSet(fstFlags, Fstflags.AtimNow)) {
                hostChildFile.setLastAccessTime(FileTime.from(WasiClockTimeGetNode.realtimeNow(), TimeUnit.NANOSECONDS), new LinkOption[0]);
            }
            if (FlagUtils.isSet(fstFlags, Fstflags.Mtim)) {
                hostChildFile.setLastModifiedTime(FileTime.from(mtim, TimeUnit.NANOSECONDS), new LinkOption[0]);
            }
            if (FlagUtils.isSet(fstFlags, Fstflags.MtimNow)) {
                hostChildFile.setLastModifiedTime(FileTime.from(WasiClockTimeGetNode.realtimeNow(), TimeUnit.NANOSECONDS), new LinkOption[0]);
            }
        }
        catch (IOException e) {
            return Errno.Io;
        }
        catch (SecurityException e) {
            return Errno.Acces;
        }
        return Errno.Success;
    }

    @Override
    public Errno pathLink(Node node, WasmMemory memory, int oldFlags, int oldPathAddress, int oldPathLength, Fd newFd, int newPathAddress, int newPathLength) {
        TruffleFile oldHostChildFile;
        if (!FlagUtils.isSet(this.fsRightsBase, Rights.PathLinkSource) || !FlagUtils.isSet(newFd.fsRightsBase, Rights.PathLinkTarget)) {
            return Errno.Notcapable;
        }
        try {
            oldHostChildFile = this.resolveHostFile(node, memory, oldPathAddress, oldPathLength, oldFlags);
        }
        catch (IOException e) {
            return Errno.Io;
        }
        catch (SecurityException e) {
            return Errno.Acces;
        }
        if (oldHostChildFile == null) {
            return Errno.Noent;
        }
        if (!(newFd instanceof DirectoryFd)) {
            return Errno.Notdir;
        }
        TruffleFile newHostChildFile = DirectoryFd.resolveHostFile(node, memory, (DirectoryFd)newFd, newPathAddress, newPathLength);
        if (newHostChildFile == null) {
            return Errno.Noent;
        }
        try {
            newHostChildFile.createLink(oldHostChildFile);
        }
        catch (FileAlreadyExistsException e) {
            return Errno.Exist;
        }
        catch (IOException | UnsupportedOperationException e) {
            return Errno.Io;
        }
        catch (SecurityException e) {
            return Errno.Acces;
        }
        return Errno.Success;
    }

    @Override
    public Errno pathOpen(Node node, WasmMemory memory, int dirFlags, int pathAddress, int pathLength, short childOflags, long childFsRightsBase, long childFsRightsInheriting, short childFdFlags, int fdAddress) {
        TruffleFile hostChildFile;
        if (!(FlagUtils.isSet(this.fsRightsBase, Rights.PathOpen) && FlagUtils.isSubsetOf(childFsRightsBase, this.fsRightsInheriting) && FlagUtils.isSubsetOf(childFsRightsInheriting, this.fsRightsInheriting))) {
            return Errno.Notcapable;
        }
        TruffleFile virtualChildFile = this.resolveVirtualFile(node, memory, pathAddress, pathLength);
        if (virtualChildFile == null) {
            return Errno.Noent;
        }
        try {
            hostChildFile = this.resolveHostFile(virtualChildFile, dirFlags);
        }
        catch (IOException e) {
            return Errno.Io;
        }
        catch (SecurityException e) {
            return Errno.Acces;
        }
        if (hostChildFile == null) {
            return Errno.Noent;
        }
        if (FlagUtils.isSet(childFdFlags, Fdflags.Rsync)) {
            return Errno.Inval;
        }
        if (FlagUtils.isSet(childOflags, Oflags.Directory)) {
            if (hostChildFile.isDirectory(new LinkOption[0])) {
                int fd = this.fdManager.put(new DirectoryFd(this.fdManager, virtualChildFile, this.preopenedRoot, childFsRightsBase, childFsRightsInheriting, childFdFlags));
                memory.store_i32(node, fdAddress, fd);
                return Errno.Success;
            }
            return Errno.Notdir;
        }
        try {
            int fd = this.fdManager.put(new FileFd(hostChildFile, childOflags, childFsRightsBase, childFsRightsInheriting, childFdFlags));
            memory.store_i32(node, fdAddress, fd);
            return Errno.Success;
        }
        catch (FileAlreadyExistsException e) {
            return Errno.Exist;
        }
        catch (IOException | UnsupportedOperationException e) {
            return Errno.Io;
        }
        catch (IllegalArgumentException e) {
            return Errno.Inval;
        }
        catch (SecurityException e) {
            return Errno.Acces;
        }
    }

    @Override
    public Errno readdir(Node node, WasmMemory memory, int bufAddress, int bufLength, long cookie, int sizeAddress) {
        if (!FlagUtils.isSet(this.fsRightsBase, Rights.FdReaddir)) {
            return Errno.Notcapable;
        }
        try {
            Collection children = this.virtualFile.list();
            ArrayList<TruffleFile> entries = new ArrayList<TruffleFile>(children.size() + 2);
            entries.add(this.virtualFile.resolve("."));
            entries.add(this.virtualFile.resolve(".."));
            entries.addAll(children);
            int bufPointer = bufAddress;
            int bufEnd = bufAddress + bufLength;
            long currentEntry = 0L;
            for (TruffleFile file : entries) {
                if (currentEntry >= cookie) {
                    byte[] name = file.getName().getBytes(StandardCharsets.UTF_8);
                    if (bufEnd - bufPointer >= 24) {
                        bufPointer += FdUtils.writeDirent(node, memory, bufPointer, file, name.length, currentEntry + 1L);
                    } else {
                        byte[] dirent = FdUtils.writeDirentToByteArray(file, name.length, currentEntry + 1L);
                        int i = 0;
                        while (bufPointer < bufEnd) {
                            assert (i < dirent.length);
                            memory.store_i32_8(node, bufPointer, dirent[i]);
                            ++i;
                            ++bufPointer;
                        }
                        assert (bufPointer == bufEnd);
                        break;
                    }
                    if (bufEnd - bufPointer >= name.length) {
                        bufPointer += memory.writeString(node, file.getName(), bufPointer);
                    } else {
                        int i = 0;
                        while (bufPointer < bufEnd) {
                            assert (i < name.length);
                            memory.store_i32_8(node, bufPointer, name[i]);
                            ++i;
                            ++bufPointer;
                        }
                        assert (bufPointer == bufEnd);
                        break;
                    }
                }
                ++currentEntry;
            }
            memory.store_i32(node, sizeAddress, bufPointer - bufAddress);
        }
        catch (IOException e) {
            return Errno.Io;
        }
        return Errno.Success;
    }

    @Override
    public int pathReadLink(Node node, WasmMemory memory, int pathAddress, int pathLength, int buf, int bufLen, int sizeAddress) {
        if (!FlagUtils.isSet(this.fsRightsBase, Rights.PathReadlink)) {
            return Errno.Notcapable.ordinal();
        }
        TruffleFile hostChildFile = this.resolveHostFile(node, memory, pathAddress, pathLength);
        if (hostChildFile == null) {
            return Errno.Noent.ordinal();
        }
        try {
            TruffleFile link = hostChildFile.readSymbolicLink();
            TruffleFile virtualLink = this.preopenedRoot.hostFileToVirtualFile(link);
            if (virtualLink == null) {
                return Errno.Noent.ordinal();
            }
            String content = virtualLink.getPath();
            int bytesWritten = memory.writeString(node, content, buf, bufLen);
            memory.store_i32(node, sizeAddress, bytesWritten);
            return Errno.Success.ordinal();
        }
        catch (NotLinkException e) {
            return Errno.Nolink.ordinal();
        }
        catch (IOException | UnsupportedOperationException e) {
            return Errno.Io.ordinal();
        }
        catch (SecurityException e) {
            return Errno.Acces.ordinal();
        }
    }

    @Override
    public Errno pathRemoveDirectory(Node node, WasmMemory memory, int pathAddress, int pathLength) {
        if (!FlagUtils.isSet(this.fsRightsBase, Rights.PathRemoveDirectory)) {
            return Errno.Notcapable;
        }
        TruffleFile hostChildFile = this.resolveHostFile(node, memory, pathAddress, pathLength);
        if (hostChildFile == null) {
            return Errno.Noent;
        }
        if (!hostChildFile.isDirectory(new LinkOption[0])) {
            return Errno.Notdir;
        }
        try {
            hostChildFile.delete();
        }
        catch (DirectoryNotEmptyException e) {
            return Errno.Notempty;
        }
        catch (NoSuchFileException e) {
            return Errno.Noent;
        }
        catch (IOException e) {
            return Errno.Io;
        }
        catch (SecurityException e) {
            return Errno.Acces;
        }
        return Errno.Success;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public Errno pathRename(Node node, WasmMemory memory, int oldPathAddress, int oldPathLength, Fd newFd, int newPathAddress, int newPathLength) {
        if (!FlagUtils.isSet(this.fsRightsBase, Rights.PathRenameSource) || !FlagUtils.isSet(newFd.fsRightsBase, Rights.PathRenameTarget)) {
            return Errno.Notcapable;
        }
        TruffleFile oldHostChildFile = this.resolveHostFile(node, memory, oldPathAddress, oldPathLength);
        if (oldHostChildFile == null) {
            return Errno.Noent;
        }
        if (!(newFd instanceof DirectoryFd)) {
            return Errno.Notdir;
        }
        TruffleFile newHostChildFile = DirectoryFd.resolveHostFile(node, memory, (DirectoryFd)newFd, newPathAddress, newPathLength);
        if (newHostChildFile == null) {
            return Errno.Noent;
        }
        try {
            oldHostChildFile.move(newHostChildFile, new CopyOption[0]);
        }
        catch (FileAlreadyExistsException e) {
            return Errno.Exist;
        }
        catch (IOException | UnsupportedOperationException e) {
            return Errno.Io;
        }
        catch (SecurityException e) {
            return Errno.Acces;
        }
        return Errno.Success;
    }

    @Override
    public Errno pathSymlink(Node node, WasmMemory memory, int oldPathAddress, int oldPathLength, int newPathAddress, int newPathLength) {
        if (!FlagUtils.isSet(this.fsRightsBase, Rights.PathSymlink)) {
            return Errno.Notcapable;
        }
        TruffleFile oldHostChildFile = this.resolveHostFile(node, memory, oldPathAddress, oldPathLength);
        if (oldHostChildFile == null) {
            return Errno.Noent;
        }
        TruffleFile newHostChildFile = this.resolveHostFile(node, memory, newPathAddress, newPathLength);
        if (newHostChildFile == null) {
            return Errno.Noent;
        }
        try {
            newHostChildFile.createSymbolicLink(oldHostChildFile, new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException e) {
            return Errno.Exist;
        }
        catch (IOException | UnsupportedOperationException e) {
            return Errno.Io;
        }
        catch (SecurityException e) {
            return Errno.Acces;
        }
        return Errno.Success;
    }

    @Override
    public Errno pathUnlinkFile(Node node, WasmMemory memory, int pathAddress, int pathLength) {
        if (!FlagUtils.isSet(this.fsRightsBase, Rights.PathUnlinkFile)) {
            return Errno.Notcapable;
        }
        TruffleFile hostChildFile = this.resolveHostFile(node, memory, pathAddress, pathLength);
        if (hostChildFile == null) {
            return Errno.Noent;
        }
        if (hostChildFile.isDirectory(new LinkOption[0])) {
            return Errno.Isdir;
        }
        try {
            hostChildFile.delete();
        }
        catch (NoSuchFileException e) {
            return Errno.Noent;
        }
        catch (IOException e) {
            return Errno.Io;
        }
        catch (SecurityException e) {
            return Errno.Acces;
        }
        return Errno.Success;
    }
}

