/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.predefined.wasi.fd;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.TruffleLanguage;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.LinkOption;
import java.util.concurrent.ThreadLocalRandom;
import org.graalvm.collections.EconomicMap;
import org.graalvm.wasm.WasmOptions;
import org.graalvm.wasm.exception.Failure;
import org.graalvm.wasm.exception.WasmException;
import org.graalvm.wasm.predefined.wasi.fd.Fd;
import org.graalvm.wasm.predefined.wasi.fd.InputStreamFd;
import org.graalvm.wasm.predefined.wasi.fd.OutputStreamFd;
import org.graalvm.wasm.predefined.wasi.fd.PreopenedDirectoryFd;

public final class FdManager
implements Closeable {
    private final EconomicMap<Integer, Fd> handles;

    public FdManager(TruffleLanguage.Env env) {
        CompilerAsserts.neverPartOfCompilation();
        this.handles = EconomicMap.create((int)3);
        this.put(0, new InputStreamFd(env.in()));
        this.put(1, new OutputStreamFd(env.out()));
        this.put(2, new OutputStreamFd(env.err()));
        String preopenedDirs = (String)WasmOptions.WasiMapDirs.getValue(env.getOptions());
        if (preopenedDirs == null || preopenedDirs.isEmpty()) {
            return;
        }
        int fd = 3;
        for (String dir : preopenedDirs.split(",")) {
            TruffleFile hostDir;
            TruffleFile virtualDir;
            String[] parts = dir.split("::", 2);
            if (parts.length > 2) {
                throw WasmException.create(Failure.INVALID_WASI_DIRECTORIES_MAPPING, String.format("Wasi directory map '%s' is not valid. Syntax: --WasiMapDirs <virtual_path>::<host_path>, or --WasiMapDirs <host_path>", dir));
            }
            String virtualDirPath = parts[0];
            String hostDirPath = parts.length == 2 ? parts[1] : parts[0];
            try {
                virtualDir = env.getPublicTruffleFile(virtualDirPath).normalize();
                hostDir = env.getPublicTruffleFile(hostDirPath).getCanonicalFile(new LinkOption[0]);
            }
            catch (IOException | SecurityException e) {
                throw WasmException.create(Failure.INVALID_WASI_DIRECTORIES_MAPPING);
            }
            this.put(fd, new PreopenedDirectoryFd(this, hostDir, virtualDir, virtualDirPath));
            ++fd;
        }
    }

    public synchronized Fd get(int fd) {
        return (Fd)this.handles.get((Object)fd);
    }

    synchronized int put(Fd handle) {
        int fd;
        while (this.handles.containsKey((Object)(fd = ThreadLocalRandom.current().nextInt(Integer.MAX_VALUE)))) {
        }
        this.put(fd, handle);
        return fd;
    }

    private synchronized void put(int fd, Fd handle) {
        this.handles.put((Object)fd, (Object)handle);
    }

    public synchronized void remove(int fd) {
        this.handles.removeKey((Object)fd);
    }

    public synchronized void renumber(int fd, int to) {
        this.handles.put((Object)to, (Object)((Fd)this.handles.get((Object)fd)));
        this.handles.removeKey((Object)fd);
    }

    public synchronized int size() {
        return this.handles.size();
    }

    @Override
    public synchronized void close() throws IOException {
        for (Fd handle : this.handles.getValues()) {
            handle.close();
        }
        this.handles.clear();
    }
}

