/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.predefined.wasi.types;

import com.oracle.truffle.api.nodes.Node;
import org.graalvm.wasm.memory.WasmMemory;
import org.graalvm.wasm.predefined.wasi.types.Filetype;

public final class Filestat {
    public static final int BYTES = 64;

    private Filestat() {
    }

    public static long readDev(Node node, WasmMemory memory, int address) {
        return memory.load_i64(node, address + 0);
    }

    public static void writeDev(Node node, WasmMemory memory, int address, long value) {
        memory.store_i64(node, address + 0, value);
    }

    public static long readIno(Node node, WasmMemory memory, int address) {
        return memory.load_i64(node, address + 8);
    }

    public static void writeIno(Node node, WasmMemory memory, int address, long value) {
        memory.store_i64(node, address + 8, value);
    }

    public static Filetype readFiletype(Node node, WasmMemory memory, int address) {
        return Filetype.fromValue((byte)memory.load_i32_8u(node, address + 16));
    }

    public static void writeFiletype(Node node, WasmMemory memory, int address, Filetype value) {
        memory.store_i32_8(node, address + 16, value.toValue());
    }

    public static long readNlink(Node node, WasmMemory memory, int address) {
        return memory.load_i64(node, address + 24);
    }

    public static void writeNlink(Node node, WasmMemory memory, int address, long value) {
        memory.store_i64(node, address + 24, value);
    }

    public static long readSize(Node node, WasmMemory memory, int address) {
        return memory.load_i64(node, address + 32);
    }

    public static void writeSize(Node node, WasmMemory memory, int address, long value) {
        memory.store_i64(node, address + 32, value);
    }

    public static long readAtim(Node node, WasmMemory memory, int address) {
        return memory.load_i64(node, address + 40);
    }

    public static void writeAtim(Node node, WasmMemory memory, int address, long value) {
        memory.store_i64(node, address + 40, value);
    }

    public static long readMtim(Node node, WasmMemory memory, int address) {
        return memory.load_i64(node, address + 48);
    }

    public static void writeMtim(Node node, WasmMemory memory, int address, long value) {
        memory.store_i64(node, address + 48, value);
    }

    public static long readCtim(Node node, WasmMemory memory, int address) {
        return memory.load_i64(node, address + 56);
    }

    public static void writeCtim(Node node, WasmMemory memory, int address, long value) {
        memory.store_i64(node, address + 56, value);
    }
}

