/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import org.graalvm.wasm.api.Vector128;
import org.graalvm.wasm.exception.Failure;
import org.graalvm.wasm.exception.WasmException;
import org.graalvm.wasm.globals.WasmGlobal;

public class GlobalRegistry {
    private static final int INITIAL_GLOBALS_SIZE = 8;
    @CompilerDirectives.CompilationFinal(dimensions=0)
    private long[] globals = new long[8];
    @CompilerDirectives.CompilationFinal(dimensions=0)
    private Object[] objectGlobals = new Object[8];
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private WasmGlobal[] externalGlobals = new WasmGlobal[8];
    private int globalCount = 0;
    private int externalGlobalCount = 0;

    public int count() {
        return this.globalCount;
    }

    private void ensureGlobalCapacity() {
        if (this.globalCount == this.globals.length) {
            long[] nGlobals = new long[this.globals.length * 2];
            System.arraycopy(this.globals, 0, nGlobals, 0, this.globals.length);
            this.globals = nGlobals;
            Object[] nObjectGlobals = new Object[this.objectGlobals.length * 2];
            System.arraycopy(this.objectGlobals, 0, nObjectGlobals, 0, this.objectGlobals.length);
            this.objectGlobals = nObjectGlobals;
        }
    }

    private void ensureExternalGlobalCapacity() {
        if (this.externalGlobalCount == this.externalGlobals.length) {
            WasmGlobal[] nExternalGlobals = new WasmGlobal[this.externalGlobals.length * 2];
            System.arraycopy(this.externalGlobals, 0, nExternalGlobals, 0, this.externalGlobals.length);
            this.externalGlobals = nExternalGlobals;
        }
    }

    public int allocateGlobal() {
        this.ensureGlobalCapacity();
        this.globals[this.globalCount] = 0L;
        this.objectGlobals[this.globalCount] = null;
        int idx = this.globalCount++;
        return idx;
    }

    public int allocateExternalGlobal(WasmGlobal object) {
        this.ensureExternalGlobalCapacity();
        this.externalGlobals[this.externalGlobalCount] = object;
        int idx = -this.externalGlobalCount - 1;
        ++this.externalGlobalCount;
        return idx;
    }

    public int loadAsInt(int address) {
        return (int)this.loadAsLong(address);
    }

    public long loadAsLong(int address) {
        if (address < 0) {
            WasmGlobal global = this.externalGlobals[-address - 1];
            return global.loadAsLong();
        }
        return this.globals[address];
    }

    public Vector128 loadAsVector128(int address) {
        return (Vector128)this.loadAsObject(address);
    }

    public Object loadAsReference(int address) {
        return this.loadAsObject(address);
    }

    public Object loadAsObject(int address) {
        if (address < 0) {
            WasmGlobal global = this.externalGlobals[-address - 1];
            return global.loadAsObject();
        }
        return this.objectGlobals[address];
    }

    public void store(byte globalValueType, int address, Object value) {
        switch (globalValueType) {
            case 127: {
                this.storeInt(address, (Integer)value);
                break;
            }
            case 126: {
                this.storeLong(address, (Long)value);
                break;
            }
            case 125: {
                this.storeInt(address, Float.floatToRawIntBits(((Float)value).floatValue()));
                break;
            }
            case 124: {
                this.storeLong(address, Double.doubleToRawLongBits((Double)value));
                break;
            }
            case 123: {
                this.storeVector128(address, (Vector128)value);
                break;
            }
            case 111: 
            case 112: {
                this.storeReference(address, value);
                break;
            }
            default: {
                throw CompilerDirectives.shouldNotReachHere();
            }
        }
    }

    public void storeInt(int address, int value) {
        this.storeLong(address, value);
    }

    public void storeLong(int address, long value) {
        if (address < 0) {
            WasmGlobal global = this.externalGlobals[-address - 1];
            global.storeLong(value);
        } else {
            this.globals[address] = value;
        }
    }

    public void storeVector128(int address, Vector128 value) {
        this.storeObject(address, value);
    }

    public void storeReference(int address, Object value) {
        this.storeObject(address, value);
    }

    public void storeObject(int address, Object value) {
        if (address < 0) {
            WasmGlobal global = this.externalGlobals[-address - 1];
            global.storeObject(value);
        } else {
            this.objectGlobals[address] = value;
        }
    }

    public GlobalRegistry duplicate() {
        int i;
        GlobalRegistry other = new GlobalRegistry();
        for (i = 0; i < this.globalCount; ++i) {
            int address = other.allocateGlobal();
            long value = this.loadAsLong(address);
            Object objectValue = this.loadAsObject(address);
            other.storeLong(address, value);
            other.storeObject(address, objectValue);
        }
        for (i = 0; i < this.externalGlobalCount; ++i) {
            other.allocateExternalGlobal(this.externalGlobals[i]);
        }
        return other;
    }

    public WasmGlobal externalGlobal(int address) {
        CompilerAsserts.neverPartOfCompilation();
        if (address >= 0) {
            throw WasmException.create(Failure.UNSPECIFIED_INTERNAL, "Global at address " + address + " is not external.");
        }
        return this.externalGlobals[-address - 1];
    }
}

