/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import org.graalvm.wasm.BinaryStreamParser;
import org.graalvm.wasm.Linker;
import org.graalvm.wasm.SymbolTable;
import org.graalvm.wasm.WasmContext;
import org.graalvm.wasm.WasmFunction;
import org.graalvm.wasm.WasmFunctionInstance;
import org.graalvm.wasm.WasmInstance;
import org.graalvm.wasm.WasmModule;
import org.graalvm.wasm.memory.NativeDataInstanceUtil;
import org.graalvm.wasm.memory.WasmMemory;

public abstract class RuntimeState {
    private static final int INITIAL_GLOBALS_SIZE = 64;
    private static final int INITIAL_TABLES_SIZE = 1;
    private static final int INITIAL_MEMORIES_SIZE = 1;
    private final WasmContext context;
    private final WasmModule module;
    private final CallTarget[] targets;
    private final WasmFunctionInstance[] functionInstances;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private int[] globalAddresses;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private int[] tableAddresses;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private WasmMemory[] memories;
    @CompilerDirectives.CompilationFinal(dimensions=0)
    private Object[][] elementInstances;
    @CompilerDirectives.CompilationFinal(dimensions=0)
    private int[] dataInstances;
    private final int droppedDataInstanceOffset;
    @CompilerDirectives.CompilationFinal
    private Linker.LinkState linkState;
    @CompilerDirectives.CompilationFinal
    private int startFunctionIndex;

    private void ensureGlobalsCapacity(int index) {
        while (index >= this.globalAddresses.length) {
            int[] nGlobalAddresses = new int[this.globalAddresses.length * 2];
            System.arraycopy(this.globalAddresses, 0, nGlobalAddresses, 0, this.globalAddresses.length);
            this.globalAddresses = nGlobalAddresses;
        }
    }

    private void ensureTablesCapacity(int index) {
        if (index >= this.tableAddresses.length) {
            int[] nTableAddresses = new int[Math.max(Integer.highestOneBit(index) << 1, 2 * this.tableAddresses.length)];
            System.arraycopy(this.tableAddresses, 0, nTableAddresses, 0, this.tableAddresses.length);
            this.tableAddresses = nTableAddresses;
        }
    }

    private void ensureMemoriesCapacity(int index) {
        if (index >= this.memories.length) {
            WasmMemory[] nMemories = new WasmMemory[Math.max(Integer.highestOneBit(index) << 1, 2 * this.memories.length)];
            System.arraycopy(this.memories, 0, nMemories, 0, this.memories.length);
            this.memories = nMemories;
        }
    }

    public RuntimeState(WasmContext context, WasmModule module, int numberOfFunctions, int droppedDataInstanceOffset) {
        this.context = context;
        this.module = module;
        this.globalAddresses = new int[64];
        this.tableAddresses = new int[1];
        this.memories = new WasmMemory[1];
        this.targets = new CallTarget[numberOfFunctions];
        this.functionInstances = new WasmFunctionInstance[numberOfFunctions];
        this.linkState = Linker.LinkState.nonLinked;
        this.dataInstances = null;
        this.elementInstances = null;
        this.droppedDataInstanceOffset = droppedDataInstanceOffset;
        this.startFunctionIndex = -1;
    }

    private void checkNotLinked() {
        if (this.linkState == Linker.LinkState.linked) {
            throw CompilerDirectives.shouldNotReachHere((String)"The engine tried to modify the instance after linking.");
        }
    }

    public void setLinkInProgress() {
        if (this.linkState != Linker.LinkState.nonLinked) {
            throw CompilerDirectives.shouldNotReachHere((String)"Can only switch to in-progress state when not linked.");
        }
        this.linkState = Linker.LinkState.inProgress;
    }

    public void setLinkCompleted() {
        if (this.linkState != Linker.LinkState.inProgress) {
            throw CompilerDirectives.shouldNotReachHere((String)"Can only switch to linked state when linking is in-progress.");
        }
        this.linkState = Linker.LinkState.linked;
    }

    public void setLinkFailed() {
        if (this.linkState != Linker.LinkState.inProgress) {
            throw CompilerDirectives.shouldNotReachHere((String)"Can only switch to failed state when linking is in-progress.");
        }
        this.linkState = Linker.LinkState.failed;
    }

    public WasmContext context() {
        return this.context;
    }

    public boolean isNonLinked() {
        return this.linkState == Linker.LinkState.nonLinked;
    }

    public boolean isLinkInProgress() {
        return this.linkState == Linker.LinkState.inProgress;
    }

    public boolean isLinkCompleted() {
        return this.linkState == Linker.LinkState.linked;
    }

    public boolean isLinkFailed() {
        return this.linkState == Linker.LinkState.failed;
    }

    public SymbolTable symbolTable() {
        return this.module.symbolTable();
    }

    public WasmModule module() {
        return this.module;
    }

    protected WasmInstance instance() {
        return null;
    }

    public CallTarget target(int index) {
        return this.targets[index];
    }

    public void setTarget(int index, CallTarget target) {
        this.targets[index] = target;
    }

    public int globalAddress(int index) {
        int result = this.globalAddresses[index];
        assert (result != Integer.MIN_VALUE) : "Uninitialized global at index: " + index;
        return result;
    }

    public void setGlobalAddress(int globalIndex, int address) {
        this.ensureGlobalsCapacity(globalIndex);
        this.checkNotLinked();
        this.globalAddresses[globalIndex] = address;
    }

    public int tableAddress(int index) {
        int result = this.tableAddresses[index];
        assert (result != Integer.MIN_VALUE) : "Uninitialized table at index: " + index;
        return result;
    }

    public void setTableAddress(int tableIndex, int address) {
        this.ensureTablesCapacity(tableIndex);
        this.checkNotLinked();
        this.tableAddresses[tableIndex] = address;
    }

    public WasmMemory memory(int index) {
        return this.memories[index];
    }

    public void setMemory(int index, WasmMemory memory) {
        this.ensureMemoriesCapacity(index);
        this.checkNotLinked();
        this.memories[index] = memory;
    }

    public WasmFunctionInstance functionInstance(WasmFunction function) {
        int functionIndex = function.index();
        WasmFunctionInstance functionInstance = this.functionInstances[functionIndex];
        if (functionInstance == null) {
            this.functionInstances[functionIndex] = functionInstance = new WasmFunctionInstance(this.instance(), function, this.target(functionIndex));
        }
        return functionInstance;
    }

    public WasmFunctionInstance functionInstance(int index) {
        return this.functionInstances[index];
    }

    public void setFunctionInstance(int index, WasmFunctionInstance functionInstance) {
        assert (functionInstance != null);
        this.functionInstances[index] = functionInstance;
    }

    private void ensureDataInstanceCapacity(int index) {
        if (this.dataInstances == null) {
            this.dataInstances = new int[Math.max(Integer.highestOneBit(index) << 1, 2)];
        } else if (index >= this.dataInstances.length) {
            int[] nDataInstances = new int[Math.max(Integer.highestOneBit(index) << 1, 2 * this.dataInstances.length)];
            System.arraycopy(this.dataInstances, 0, nDataInstances, 0, this.dataInstances.length);
            this.dataInstances = nDataInstances;
        }
    }

    public void setDataInstance(int index, int bytecodeOffset) {
        assert (bytecodeOffset != -1);
        this.ensureDataInstanceCapacity(index);
        this.dataInstances[index] = bytecodeOffset;
    }

    public void dropDataInstance(int index) {
        if (this.dataInstances == null) {
            return;
        }
        assert (index < this.dataInstances.length);
        this.dataInstances[index] = this.droppedDataInstanceOffset;
    }

    public void dropUnsafeDataInstance(int index) {
        long address = this.dataInstanceAddress(index);
        if (address != 0L) {
            NativeDataInstanceUtil.freeNativeInstance(address);
        }
        this.dataInstances[index] = this.droppedDataInstanceOffset;
    }

    public int dataInstanceOffset(int index) {
        if (this.dataInstances == null || this.dataInstances[index] == this.droppedDataInstanceOffset) {
            return 0;
        }
        int bytecodeOffset = this.dataInstances[index];
        byte[] bytecode = this.module().bytecode();
        return bytecodeOffset + (bytecode[bytecodeOffset] & 0xC0) + 1;
    }

    public int dataInstanceLength(int index) {
        if (this.dataInstances == null || this.dataInstances[index] == this.droppedDataInstanceOffset) {
            return 0;
        }
        int bytecodeOffset = this.dataInstances[index];
        byte[] bytecode = this.module().bytecode();
        int encoding = bytecode[bytecodeOffset];
        int lengthEncoding = encoding & 0xC0;
        return switch (lengthEncoding) {
            case 0 -> encoding;
            case 64 -> BinaryStreamParser.rawPeekU8(bytecode, bytecodeOffset + 1);
            case 128 -> BinaryStreamParser.rawPeekU16(bytecode, bytecodeOffset + 1);
            case 192 -> BinaryStreamParser.rawPeekI32(bytecode, bytecodeOffset + 1);
            default -> throw CompilerDirectives.shouldNotReachHere();
        };
    }

    public long dataInstanceAddress(int index) {
        if (this.dataInstances == null || this.dataInstances[index] == this.droppedDataInstanceOffset) {
            return 0L;
        }
        int bytecodeOffset = this.dataInstances[index];
        byte[] bytecode = this.module().bytecode();
        byte encoding = bytecode[bytecodeOffset];
        int lengthEncoding = encoding & 0xC0;
        switch (lengthEncoding) {
            case 0: {
                return BinaryStreamParser.rawPeekI64(bytecode, bytecodeOffset + 1);
            }
            case 64: {
                return BinaryStreamParser.rawPeekI64(bytecode, bytecodeOffset + 2);
            }
            case 128: {
                return BinaryStreamParser.rawPeekI64(bytecode, bytecodeOffset + 3);
            }
            case 192: {
                return BinaryStreamParser.rawPeekI64(bytecode, bytecodeOffset + 5);
            }
        }
        throw CompilerDirectives.shouldNotReachHere();
    }

    public int droppedDataInstanceOffset() {
        return this.droppedDataInstanceOffset;
    }

    private void ensureElemInstanceCapacity(int index) {
        if (this.elementInstances == null) {
            this.elementInstances = new Object[Math.max(Integer.highestOneBit(index) << 1, 2)][];
        } else if (index >= this.elementInstances.length) {
            Object[][] nElementInstanceData = new Object[Math.max(Integer.highestOneBit(index) << 1, 2 * this.elementInstances.length)][];
            System.arraycopy(this.elementInstances, 0, nElementInstanceData, 0, this.elementInstances.length);
            this.elementInstances = nElementInstanceData;
        }
    }

    void setElemInstance(int index, Object[] data) {
        assert (data != null);
        this.ensureElemInstanceCapacity(index);
        this.elementInstances[index] = data;
    }

    public void dropElemInstance(int index) {
        if (this.elementInstances == null) {
            return;
        }
        assert (index < this.elementInstances.length);
        this.elementInstances[index] = null;
    }

    public Object[] elemInstance(int index) {
        if (this.elementInstances == null) {
            return null;
        }
        assert (index < this.elementInstances.length);
        return this.elementInstances[index];
    }

    public int startFunctionIndex() {
        return this.startFunctionIndex;
    }

    public void setStartFunctionIndex(int index) {
        this.startFunctionIndex = index;
    }
}

