/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.TruffleContext;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import org.graalvm.wasm.Assert;
import org.graalvm.wasm.EmbedderDataHolder;
import org.graalvm.wasm.WasmArguments;
import org.graalvm.wasm.WasmConstant;
import org.graalvm.wasm.WasmContext;
import org.graalvm.wasm.WasmFunction;
import org.graalvm.wasm.WasmInstance;
import org.graalvm.wasm.WasmLanguage;
import org.graalvm.wasm.api.InteropArray;
import org.graalvm.wasm.api.Vector128;
import org.graalvm.wasm.exception.Failure;
import org.graalvm.wasm.exception.WasmException;
import org.graalvm.wasm.nodes.WasmIndirectCallNode;

@ExportLibrary(value=InteropLibrary.class)
public final class WasmFunctionInstance
extends EmbedderDataHolder
implements TruffleObject {
    static final int NO_BYTECODE_INDEX = -1;
    private final WasmContext context;
    private final WasmInstance moduleInstance;
    private final WasmFunction function;
    private final CallTarget target;
    private final TruffleContext truffleContext;
    private Object importedFunction;

    public WasmFunctionInstance(WasmInstance moduleInstance, WasmFunction function, CallTarget target) {
        this(moduleInstance.context(), moduleInstance, function, target);
    }

    public WasmFunctionInstance(WasmContext context, CallTarget target) {
        this(context, null, null, target);
    }

    public WasmFunctionInstance(WasmContext context, WasmInstance moduleInstance, WasmFunction function, CallTarget target) {
        Assert.assertNotNull(target, "Call target must be non-null", Failure.UNSPECIFIED_INTERNAL);
        this.context = context;
        this.moduleInstance = moduleInstance;
        this.function = function;
        this.target = target;
        this.truffleContext = context.environment().getContext();
        assert (((RootCallTarget)target).getRootNode().getLanguage(WasmLanguage.class) == context.language());
    }

    public String toString() {
        return this.name();
    }

    public WasmContext context() {
        return this.context;
    }

    public WasmInstance moduleInstance() {
        return this.moduleInstance;
    }

    @CompilerDirectives.TruffleBoundary
    public String name() {
        if (this.function == null) {
            return this.target.toString();
        }
        return this.function.name();
    }

    public WasmFunction function() {
        return this.function;
    }

    public CallTarget target() {
        return this.target;
    }

    public TruffleContext getTruffleContext() {
        return this.truffleContext;
    }

    public void setImportedFunction(Object importedFunction) {
        this.importedFunction = importedFunction;
    }

    public Object getImportedFunction() {
        return this.importedFunction;
    }

    @ExportMessage
    boolean isExecutable() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    Object execute(Object[] arguments, @CachedLibrary(value="this") InteropLibrary self, @Cached(value="create(NO_BYTECODE_INDEX)") WasmIndirectCallNode callNode) throws ArityException, UnsupportedTypeException {
        TruffleContext c = this.getTruffleContext();
        Object prev = c.enter((Node)self);
        try {
            Object result = callNode.execute(this.target, WasmArguments.create(this.moduleInstance, this.validateArguments(arguments)));
            if (result == WasmConstant.MULTI_VALUE) {
                WasmLanguage language = this.context.language();
                assert (language == WasmLanguage.get(null));
                Object object = this.multiValueStackAsArray(language);
                return object;
            }
            Object object = result;
            return object;
        }
        finally {
            c.leave((Node)self, prev);
        }
    }

    private Object[] validateArguments(Object[] arguments) throws ArityException, UnsupportedTypeException {
        if (this.function == null) {
            return arguments;
        }
        int paramCount = this.function.paramCount();
        if (arguments.length != paramCount) {
            throw ArityException.create((int)paramCount, (int)paramCount, (int)arguments.length);
        }
        block9: for (int i = 0; i < paramCount; ++i) {
            byte paramType = this.function.paramTypeAt(i);
            Object value = arguments[i];
            switch (paramType) {
                case 127: {
                    if (!(value instanceof Integer)) break;
                    continue block9;
                }
                case 126: {
                    if (!(value instanceof Long)) break;
                    continue block9;
                }
                case 125: {
                    if (!(value instanceof Float)) break;
                    continue block9;
                }
                case 124: {
                    if (!(value instanceof Double)) break;
                    continue block9;
                }
                case 123: {
                    if (!(value instanceof Vector128)) break;
                    continue block9;
                }
                case 112: {
                    if (!(value instanceof WasmFunctionInstance) && value != WasmConstant.NULL) break;
                    continue block9;
                }
                case 111: {
                    continue block9;
                }
                default: {
                    throw WasmException.create(Failure.UNKNOWN_TYPE);
                }
            }
            throw UnsupportedTypeException.create((Object[])arguments);
        }
        return arguments;
    }

    private Object multiValueStackAsArray(WasmLanguage language) {
        WasmLanguage.MultiValueStack multiValueStack = language.multiValueStack();
        long[] primitiveMultiValueStack = multiValueStack.primitiveStack();
        Object[] objectMultiValueStack = multiValueStack.objectStack();
        int resultCount = this.function.resultCount();
        assert (primitiveMultiValueStack.length >= resultCount);
        assert (objectMultiValueStack.length >= resultCount);
        Object[] values = new Object[resultCount];
        for (int i = 0; i < resultCount; ++i) {
            byte resultType = this.function.resultTypeAt(i);
            values[i] = switch (resultType) {
                case 127 -> (int)primitiveMultiValueStack[i];
                case 126 -> primitiveMultiValueStack[i];
                case 125 -> Float.valueOf(Float.intBitsToFloat((int)primitiveMultiValueStack[i]));
                case 124 -> Double.longBitsToDouble(primitiveMultiValueStack[i]);
                case 111, 112, 123 -> {
                    Object obj = objectMultiValueStack[i];
                    objectMultiValueStack[i] = null;
                    yield obj;
                }
                default -> throw WasmException.create(Failure.UNSPECIFIED_INTERNAL);
            };
        }
        return InteropArray.create(values);
    }
}

