/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.FrameSlotKind;
import com.oracle.truffle.api.nodes.Node;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.MapCursor;
import org.graalvm.wasm.BinaryStreamParser;
import org.graalvm.wasm.GlobalRegistry;
import org.graalvm.wasm.ImportDescriptor;
import org.graalvm.wasm.LinkAction;
import org.graalvm.wasm.ModuleLimits;
import org.graalvm.wasm.WasmCodeEntry;
import org.graalvm.wasm.WasmContext;
import org.graalvm.wasm.WasmFunction;
import org.graalvm.wasm.WasmInstance;
import org.graalvm.wasm.WasmLanguage;
import org.graalvm.wasm.WasmMath;
import org.graalvm.wasm.WasmModule;
import org.graalvm.wasm.WasmOptions;
import org.graalvm.wasm.WasmTable;
import org.graalvm.wasm.exception.Failure;
import org.graalvm.wasm.exception.WasmException;
import org.graalvm.wasm.memory.WasmMemory;
import org.graalvm.wasm.memory.WasmMemoryFactory;
import org.graalvm.wasm.nodes.WasmCallStubNode;
import org.graalvm.wasm.nodes.WasmFunctionNode;
import org.graalvm.wasm.nodes.WasmIndirectCallNode;
import org.graalvm.wasm.nodes.WasmInstrumentableFunctionNode;
import org.graalvm.wasm.nodes.WasmMemoryOverheadModeRootNode;
import org.graalvm.wasm.nodes.WasmRootNode;
import org.graalvm.wasm.parser.ir.CallNode;
import org.graalvm.wasm.parser.ir.CodeEntry;

public class WasmInstantiator {
    private static final int MIN_DEFAULT_STACK_SIZE = 1000000;
    private static final int MAX_DEFAULT_ASYNC_STACK_SIZE = 10000000;
    private final WasmLanguage language;

    @CompilerDirectives.TruffleBoundary
    public WasmInstantiator(WasmLanguage language) {
        this.language = language;
    }

    @CompilerDirectives.TruffleBoundary
    public WasmInstance createInstance(WasmContext context, WasmModule module) {
        WasmInstance instance = new WasmInstance(context, module);
        instance.createLinkActions();
        int binarySize = instance.module().bytecodeLength();
        int asyncParsingBinarySize = (Integer)WasmOptions.AsyncParsingBinarySize.getValue(context.environment().getOptions());
        if (binarySize < asyncParsingBinarySize || !context.environment().isCreateThreadAllowed()) {
            this.instantiateCodeEntries(context, instance);
        } else {
            Runnable parsing = () -> this.instantiateCodeEntries(context, instance);
            String name = "wasm-parsing-thread(" + instance.name() + ")";
            int requestedSize = (Integer)WasmOptions.AsyncParsingStackSize.getValue(context.environment().getOptions()) * 1000;
            int defaultSize = Math.max(1000000, Math.min(2 * binarySize, 10000000));
            int stackSize = requestedSize != 0 ? requestedSize : defaultSize;
            Thread parsingThread = context.environment().newTruffleThreadBuilder(parsing).stackSize((long)stackSize).build();
            parsingThread.setName(name);
            ParsingExceptionHandler handler = new ParsingExceptionHandler();
            parsingThread.setUncaughtExceptionHandler(handler);
            parsingThread.start();
            try {
                parsingThread.join();
                if (handler.parsingException() != null) {
                    throw WasmException.create(Failure.UNSPECIFIED_INVALID, "Asynchronous parsing failed.");
                }
            }
            catch (InterruptedException e) {
                throw WasmException.create(Failure.UNSPECIFIED_INVALID, "Asynchronous parsing interrupted.");
            }
        }
        return instance;
    }

    static List<LinkAction> recreateLinkActions(WasmModule module) {
        byte encoding;
        int i;
        ArrayList<LinkAction> linkActions = new ArrayList<LinkAction>();
        for (int i2 = 0; i2 < module.numFunctions(); ++i2) {
            String exportName;
            WasmFunction function = module.function(i2);
            if (function.isImported()) {
                linkActions.add((context, instance, imports) -> context.linker().resolveFunctionImport(context, instance, function, imports));
            }
            if ((exportName = module.exportedFunctionName(i2)) == null) continue;
            int functionIndex = i2;
            linkActions.add((context, instance, imports) -> context.linker().resolveFunctionExport(instance.module(), functionIndex, exportName));
        }
        EconomicMap<Integer, ImportDescriptor> importedGlobals = module.importedGlobals();
        for (int i3 = 0; i3 < module.numGlobals(); ++i3) {
            int globalIndex = i3;
            byte globalValueType = module.globalValueType(globalIndex);
            byte globalMutability = module.globalMutability(globalIndex);
            if (importedGlobals.containsKey((Object)globalIndex)) {
                ImportDescriptor globalDescriptor = (ImportDescriptor)importedGlobals.get((Object)globalIndex);
                linkActions.add((context, instance, imports) -> instance.setGlobalAddress(globalIndex, Integer.MIN_VALUE));
                linkActions.add((context, instance, imports) -> context.linker().resolveGlobalImport(context, instance, globalDescriptor, globalIndex, globalValueType, globalMutability, imports));
                continue;
            }
            boolean initialized = module.globalInitialized(globalIndex);
            byte[] initBytecode = module.globalInitializerBytecode(globalIndex);
            Object initialValue = module.globalInitialValue(globalIndex);
            linkActions.add((context, instance, imports) -> {
                GlobalRegistry registry = context.globals();
                int address = registry.allocateGlobal();
                instance.setGlobalAddress(globalIndex, address);
            });
            linkActions.add((context, instance, imports) -> {
                if (initialized) {
                    context.globals().store(globalValueType, instance.globalAddress(globalIndex), initialValue);
                    context.linker().resolveGlobalInitialization(instance, globalIndex);
                } else {
                    context.linker().resolveGlobalInitialization(context, instance, globalIndex, initBytecode);
                }
            });
        }
        MapCursor exportedGlobals = module.exportedGlobals().getEntries();
        while (exportedGlobals.advance()) {
            String globalName = (String)exportedGlobals.getKey();
            int globalIndex = (Integer)exportedGlobals.getValue();
            linkActions.add((context, instance, imports) -> context.linker().resolveGlobalExport(instance.module(), globalName, globalIndex));
        }
        for (int i4 = 0; i4 < module.tableCount(); ++i4) {
            int tableIndex = i4;
            int tableMinSize = module.tableInitialSize(tableIndex);
            int tableMaxSize = module.tableMaximumSize(tableIndex);
            byte tableElemType = module.tableElementType(tableIndex);
            ImportDescriptor tableDescriptor = module.importedTable(tableIndex);
            if (tableDescriptor != null) {
                linkActions.add((context, instance, imports) -> instance.setTableAddress(tableIndex, Integer.MIN_VALUE));
                linkActions.add((context, instance, imports) -> context.linker().resolveTableImport(context, instance, tableDescriptor, tableIndex, tableMinSize, tableMaxSize, tableElemType, imports));
                continue;
            }
            linkActions.add((context, instance, imports) -> {
                ModuleLimits limits = instance.module().limits();
                int maxAllowedSize = WasmMath.minUnsigned(tableMaxSize, limits.tableInstanceSizeLimit());
                limits.checkTableInstanceSize(tableMinSize);
                WasmTable wasmTable = new WasmTable(tableMinSize, tableMaxSize, maxAllowedSize, tableElemType);
                int address = context.tables().register(wasmTable);
                instance.setTableAddress(tableIndex, address);
            });
        }
        MapCursor exportedTables = module.exportedTables().getEntries();
        while (exportedTables.advance()) {
            String tableName = (String)exportedTables.getKey();
            int tableIndex = (Integer)exportedTables.getValue();
            linkActions.add((context, instance, imports) -> context.linker().resolveTableExport(instance.module(), tableIndex, tableName));
        }
        for (int i5 = 0; i5 < module.memoryCount(); ++i5) {
            int memoryIndex = i5;
            long memoryMinSize = module.memoryInitialSize(memoryIndex);
            long memoryMaxSize = module.memoryMaximumSize(memoryIndex);
            boolean memoryIndexType64 = module.memoryHasIndexType64(memoryIndex);
            boolean memoryShared = module.memoryIsShared(memoryIndex);
            ImportDescriptor memoryDescriptor = module.importedMemory(memoryIndex);
            if (memoryDescriptor != null) {
                linkActions.add((context, instance, imports) -> context.linker().resolveMemoryImport(context, instance, memoryDescriptor, memoryIndex, memoryMinSize, memoryMaxSize, memoryIndexType64, memoryShared, imports));
                continue;
            }
            linkActions.add((context, instance, imports) -> {
                ModuleLimits limits = instance.module().limits();
                long maxAllowedSize = WasmMath.minUnsigned(memoryMaxSize, limits.memoryInstanceSizeLimit());
                limits.checkMemoryInstanceSize(memoryMinSize, memoryIndexType64);
                WasmMemory wasmMemory = WasmMemoryFactory.createMemory(memoryMinSize, memoryMaxSize, maxAllowedSize, memoryIndexType64, memoryShared, context.getContextOptions().useUnsafeMemory());
                int address = context.memories().register(wasmMemory);
                WasmMemory allocatedMemory = context.memories().memory(address);
                instance.setMemory(memoryIndex, allocatedMemory);
            });
        }
        MapCursor exportedMemories = module.exportedMemories().getEntries();
        while (exportedMemories.advance()) {
            String memoryName = (String)exportedMemories.getKey();
            int memoryIndex = (Integer)exportedMemories.getValue();
            linkActions.add((context, instance, imports) -> context.linker().resolveMemoryExport(instance, memoryIndex, memoryName));
        }
        byte[] bytecode = module.bytecode();
        for (i = 0; i < module.dataInstanceCount(); ++i) {
            int dataLength;
            int dataIndex = i;
            int dataOffset = module.dataInstanceOffset(dataIndex);
            encoding = bytecode[dataOffset];
            int effectiveOffset = dataOffset + 1;
            int dataMode = encoding & 1;
            switch (encoding & 0xC0) {
                case 64: {
                    dataLength = BinaryStreamParser.rawPeekU8(bytecode, effectiveOffset);
                    ++effectiveOffset;
                    break;
                }
                case 128: {
                    dataLength = BinaryStreamParser.rawPeekU16(bytecode, effectiveOffset);
                    effectiveOffset += 2;
                    break;
                }
                case 192: {
                    dataLength = BinaryStreamParser.rawPeekI32(bytecode, effectiveOffset);
                    effectiveOffset += 4;
                    break;
                }
                default: {
                    throw CompilerDirectives.shouldNotReachHere();
                }
            }
            if (dataMode == 0) {
                int memoryIndex;
                long dataOffsetAddress;
                byte[] dataOffsetBytecode;
                long value;
                switch (encoding & 0xE) {
                    case 0: {
                        value = -1L;
                        break;
                    }
                    case 2: {
                        value = BinaryStreamParser.rawPeekU8(bytecode, effectiveOffset);
                        ++effectiveOffset;
                        break;
                    }
                    case 4: {
                        value = BinaryStreamParser.rawPeekU16(bytecode, effectiveOffset);
                        effectiveOffset += 2;
                        break;
                    }
                    case 6: {
                        value = BinaryStreamParser.rawPeekU32(bytecode, effectiveOffset);
                        effectiveOffset += 4;
                        break;
                    }
                    case 8: {
                        value = BinaryStreamParser.rawPeekI64(bytecode, effectiveOffset);
                        effectiveOffset += 8;
                        break;
                    }
                    default: {
                        throw CompilerDirectives.shouldNotReachHere();
                    }
                }
                if ((encoding & 0x10) == 0) {
                    int dataOffsetBytecodeLength = (int)value;
                    dataOffsetBytecode = Arrays.copyOfRange(bytecode, effectiveOffset, effectiveOffset + dataOffsetBytecodeLength);
                    effectiveOffset += dataOffsetBytecodeLength;
                    dataOffsetAddress = -1L;
                } else {
                    dataOffsetBytecode = null;
                    dataOffsetAddress = value;
                }
                if ((encoding & 0x20) != 0) {
                    memoryIndex = 0;
                } else {
                    byte memoryIndexEncoding = bytecode[effectiveOffset];
                    ++effectiveOffset;
                    switch (memoryIndexEncoding & 0xC0) {
                        case 0: {
                            memoryIndex = encoding & 0x3F;
                            break;
                        }
                        case 64: {
                            memoryIndex = BinaryStreamParser.rawPeekU8(bytecode, effectiveOffset);
                            break;
                        }
                        case 128: {
                            memoryIndex = BinaryStreamParser.rawPeekU16(bytecode, effectiveOffset);
                            effectiveOffset += 2;
                            break;
                        }
                        case 192: {
                            memoryIndex = BinaryStreamParser.rawPeekI32(bytecode, effectiveOffset);
                            effectiveOffset += 4;
                            break;
                        }
                        default: {
                            throw CompilerDirectives.shouldNotReachHere();
                        }
                    }
                }
                int dataBytecodeOffset = ++effectiveOffset;
                linkActions.add((context, instance, imports) -> context.linker().resolveDataSegment(context, instance, dataIndex, memoryIndex, dataOffsetAddress, dataOffsetBytecode, dataLength, dataBytecodeOffset, instance.droppedDataInstanceOffset()));
                continue;
            }
            int dataBytecodeOffset = effectiveOffset;
            linkActions.add((context, instance, imports) -> context.linker().resolvePassiveDataSegment(context, instance, dataIndex, dataBytecodeOffset, dataLength));
        }
        for (i = 0; i < module.elemInstanceCount(); ++i) {
            int elemCount;
            int elemIndex = i;
            int elemOffset = module.elemInstanceOffset(elemIndex);
            encoding = bytecode[elemOffset];
            byte typeAndMode = bytecode[elemOffset + 1];
            int effectiveOffset = elemOffset + 2;
            int elemMode = typeAndMode & 0xF;
            switch (encoding & 0xC0) {
                case 64: {
                    elemCount = BinaryStreamParser.rawPeekU8(bytecode, effectiveOffset);
                    ++effectiveOffset;
                    break;
                }
                case 128: {
                    elemCount = BinaryStreamParser.rawPeekU16(bytecode, effectiveOffset);
                    effectiveOffset += 2;
                    break;
                }
                case 192: {
                    elemCount = BinaryStreamParser.rawPeekI32(bytecode, effectiveOffset);
                    effectiveOffset += 4;
                    break;
                }
                default: {
                    throw CompilerDirectives.shouldNotReachHere();
                }
            }
            if (elemMode == 0) {
                int offsetAddress;
                byte[] offsetBytecode;
                int tableIndex;
                switch (encoding & 0x30) {
                    case 0: {
                        tableIndex = 0;
                        break;
                    }
                    case 16: {
                        tableIndex = BinaryStreamParser.rawPeekU8(bytecode, effectiveOffset);
                        ++effectiveOffset;
                        break;
                    }
                    case 32: {
                        tableIndex = BinaryStreamParser.rawPeekU16(bytecode, effectiveOffset);
                        effectiveOffset += 2;
                        break;
                    }
                    case 48: {
                        tableIndex = BinaryStreamParser.rawPeekI32(bytecode, effectiveOffset);
                        effectiveOffset += 4;
                        break;
                    }
                    default: {
                        throw CompilerDirectives.shouldNotReachHere();
                    }
                }
                switch (encoding & 0xC) {
                    case 0: {
                        offsetBytecode = null;
                        break;
                    }
                    case 4: {
                        int offsetBytecodeLength = BinaryStreamParser.rawPeekU8(bytecode, effectiveOffset);
                        offsetBytecode = Arrays.copyOfRange(bytecode, ++effectiveOffset, effectiveOffset + offsetBytecodeLength);
                        effectiveOffset += offsetBytecodeLength;
                        break;
                    }
                    case 8: {
                        int offsetBytecodeLength = BinaryStreamParser.rawPeekU16(bytecode, effectiveOffset);
                        offsetBytecode = Arrays.copyOfRange(bytecode, effectiveOffset += 2, effectiveOffset + offsetBytecodeLength);
                        effectiveOffset += offsetBytecodeLength;
                        break;
                    }
                    case 12: {
                        int offsetBytecodeLength = BinaryStreamParser.rawPeekI32(bytecode, effectiveOffset);
                        offsetBytecode = Arrays.copyOfRange(bytecode, effectiveOffset += 4, effectiveOffset + offsetBytecodeLength);
                        effectiveOffset += offsetBytecodeLength;
                        break;
                    }
                    default: {
                        throw CompilerDirectives.shouldNotReachHere();
                    }
                }
                switch (encoding & 3) {
                    case 0: {
                        offsetAddress = -1;
                        break;
                    }
                    case 1: {
                        offsetAddress = BinaryStreamParser.rawPeekU8(bytecode, effectiveOffset);
                        break;
                    }
                    case 2: {
                        offsetAddress = BinaryStreamParser.rawPeekU16(bytecode, effectiveOffset);
                        effectiveOffset += 2;
                        break;
                    }
                    case 3: {
                        offsetAddress = BinaryStreamParser.rawPeekI32(bytecode, effectiveOffset);
                        effectiveOffset += 4;
                        break;
                    }
                    default: {
                        throw CompilerDirectives.shouldNotReachHere();
                    }
                }
                int bytecodeOffset = ++effectiveOffset;
                linkActions.add((context, instance, imports) -> context.linker().resolveElemSegment(context, instance, tableIndex, elemIndex, offsetAddress, offsetBytecode, bytecodeOffset, elemCount));
                continue;
            }
            int bytecodeOffset = effectiveOffset;
            linkActions.add((context, instance, imports) -> context.linker().resolvePassiveElemSegment(context, instance, elemIndex, bytecodeOffset, elemCount));
        }
        return linkActions;
    }

    private void instantiateCodeEntries(WasmContext context, WasmInstance instance) {
        WasmModule module = instance.module();
        CodeEntry[] codeEntries = module.codeEntries();
        if (codeEntries == null) {
            return;
        }
        for (int entry = 0; entry != codeEntries.length; ++entry) {
            CodeEntry codeEntry = codeEntries[entry];
            CallTarget callTarget = this.instantiateCodeEntry(context, module, instance, codeEntry);
            instance.setTarget(codeEntry.functionIndex(), callTarget);
            context.linker().resolveCodeEntry(module, entry);
        }
    }

    private static FrameDescriptor createFrameDescriptor(byte[] localTypes, int maxStackSize) {
        FrameDescriptor.Builder builder = FrameDescriptor.newBuilder((int)localTypes.length);
        builder.addSlots(localTypes.length + maxStackSize, FrameSlotKind.Static);
        return builder.build();
    }

    private CallTarget instantiateCodeEntry(WasmContext context, WasmModule module, WasmInstance instance, CodeEntry codeEntry) {
        int functionIndex = codeEntry.functionIndex();
        WasmFunction function = module.symbolTable().function(functionIndex);
        CallTarget cachedTarget = function.target();
        if (cachedTarget != null) {
            assert (context.language().isMultiContext());
            return cachedTarget;
        }
        WasmCodeEntry wasmCodeEntry = new WasmCodeEntry(function, module.bytecode(), codeEntry.localTypes(), codeEntry.resultTypes(), codeEntry.usesMemoryZero());
        FrameDescriptor frameDescriptor = WasmInstantiator.createFrameDescriptor(codeEntry.localTypes(), codeEntry.maxStackSize());
        WasmInstrumentableFunctionNode functionNode = WasmInstantiator.instantiateFunctionNode(module, instance, wasmCodeEntry, codeEntry);
        WasmRootNode rootNode = context.getContextOptions().memoryOverheadMode() ? new WasmMemoryOverheadModeRootNode(this.language, frameDescriptor, functionNode) : new WasmRootNode(this.language, frameDescriptor, functionNode);
        RootCallTarget callTarget = rootNode.getCallTarget();
        if (context.language().isMultiContext()) {
            function.setTarget((CallTarget)callTarget);
        } else {
            rootNode.setBoundModuleInstance(instance);
        }
        return callTarget;
    }

    private static WasmInstrumentableFunctionNode instantiateFunctionNode(WasmModule module, WasmInstance instance, WasmCodeEntry codeEntry, CodeEntry entry) {
        WasmFunctionNode currentFunction = new WasmFunctionNode(module, codeEntry, entry.bytecodeStartOffset(), entry.bytecodeEndOffset());
        List<CallNode> childNodeList = entry.callNodes();
        Node[] callNodes = new Node[childNodeList.size()];
        int childIndex = 0;
        for (CallNode callNode : childNodeList) {
            Node child;
            int bytecodeIndex = callNode.getBytecodeOffset();
            if (callNode.isIndirectCall()) {
                child = WasmIndirectCallNode.create(bytecodeIndex);
            } else {
                WasmFunction resolvedFunction = module.function(callNode.getFunctionIndex());
                child = resolvedFunction.isImported() ? WasmIndirectCallNode.create(bytecodeIndex) : new WasmCallStubNode(resolvedFunction);
                int stubIndex = childIndex;
                instance.addLinkAction((ctx, inst, imports) -> ctx.linker().resolveCallsite(inst, currentFunction, stubIndex, bytecodeIndex, resolvedFunction));
            }
            callNodes[childIndex++] = child;
        }
        currentFunction.initializeCallNodes(callNodes);
        int sourceCodeLocation = module.functionSourceCodeStartOffset(codeEntry.functionIndex());
        return new WasmInstrumentableFunctionNode(module, codeEntry, currentFunction, sourceCodeLocation);
    }

    private static class ParsingExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        private Throwable parsingException = null;

        private ParsingExceptionHandler() {
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            this.parsingException = e;
        }

        public Throwable parsingException() {
            return this.parsingException;
        }
    }
}

