/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm;

import com.oracle.truffle.api.ExactMath;

public final class WasmMath {
    private static final long DOUBLE_SIGNIFICAND_WIDTH = 52L;
    public static final long DOUBLE_SIGNIFICAND_BIT_MASK = 0xFFFFFFFFFFFFFL;
    private static final long FLOAT_POWER_63_ULP = (long)Math.ulp(9.223372E18f);
    private static final long DOUBLE_POWER_63_ULP = (long)Math.ulp(9.223372036854776E18);

    private WasmMath() {
    }

    public static int addExactUnsigned(int a, int b) {
        int result = a + b;
        if (Integer.compareUnsigned(result, a) < 0) {
            throw new ArithmeticException("unsigned int overflow");
        }
        return result;
    }

    public static int minUnsigned(int a, int b) {
        return Integer.compareUnsigned(a, b) < 0 ? a : b;
    }

    public static long minUnsigned(long a, long b) {
        return Long.compareUnsigned(a, b) < 0 ? a : b;
    }

    public static int maxUnsigned(int a, int b) {
        return Integer.compareUnsigned(a, b) > 0 ? a : b;
    }

    public static int toUnsignedIntExact(long value) {
        if (value < 0L || value > 0xFFFFFFFFL) {
            throw new ArithmeticException("unsigned int overflow");
        }
        return (int)value;
    }

    public static float unsignedIntToFloat(int x) {
        return WasmMath.unsignedIntToLong(x);
    }

    public static double unsignedIntToDouble(int x) {
        return WasmMath.unsignedIntToLong(x);
    }

    public static long unsignedIntToLong(int x) {
        return (long)x & 0xFFFFFFFFL;
    }

    public static float unsignedLongToFloat(long x) {
        if (x >= 0L) {
            return x;
        }
        long shiftedX = x + Long.MIN_VALUE;
        boolean roundUp = shiftedX % FLOAT_POWER_63_ULP > FLOAT_POWER_63_ULP / 2L;
        long offset = shiftedX / FLOAT_POWER_63_ULP + (long)(roundUp ? 1 : 0);
        return 9.223372E18f + (float)offset * (float)FLOAT_POWER_63_ULP;
    }

    public static double unsignedLongToDouble(long x) {
        if (x >= 0L) {
            return x;
        }
        long shiftedX = x + Long.MIN_VALUE;
        boolean roundUp = shiftedX % DOUBLE_POWER_63_ULP > DOUBLE_POWER_63_ULP / 2L;
        long offset = shiftedX / DOUBLE_POWER_63_ULP + (long)(roundUp ? 1 : 0);
        return 9.223372036854776E18 + (double)offset * (double)DOUBLE_POWER_63_ULP;
    }

    public static long truncFloatToLong(float x) {
        return WasmMath.truncDoubleToLong(x);
    }

    public static long truncDoubleToLong(double x) {
        return (long)ExactMath.truncate((double)x);
    }

    public static long truncFloatToUnsignedLong(float x) {
        return WasmMath.truncDoubleToUnsignedLong(x);
    }

    public static long truncDoubleToUnsignedLong(double x) {
        if (x < 9.223372036854776E18) {
            return WasmMath.truncDoubleToLong(x);
        }
        long shift = (long)Math.getExponent(x) - 52L;
        long xBits = Double.doubleToRawLongBits(x);
        long significand = 0x10000000000000L | xBits & 0xFFFFFFFFFFFFFL;
        if (shift >= 12L) {
            return -1L;
        }
        if (shift > 0L) {
            return significand << (int)shift;
        }
        if (shift >= -52L) {
            return significand >> (int)(-shift);
        }
        return 0L;
    }
}

