/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.api;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.InvalidBufferOffsetException;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.memory.ByteArraySupport;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import java.nio.ByteOrder;

@ExportLibrary(value=InteropLibrary.class)
public class ByteArrayBuffer
implements TruffleObject {
    private final byte[] data;
    private final int offset;
    private final int length;

    public ByteArrayBuffer(byte[] data, int offset, int length) {
        assert (offset >= 0);
        assert (length >= 0);
        assert (data.length >= offset + length);
        this.data = data;
        this.offset = offset;
        this.length = length;
    }

    @ExportMessage
    boolean hasArrayElements() {
        return true;
    }

    @ExportMessage
    public long getArraySize() {
        return this.length;
    }

    @ExportMessage
    boolean isArrayElementReadable(long index) {
        return index >= 0L && index < this.getArraySize();
    }

    @ExportMessage
    final boolean isArrayElementModifiable(long index) {
        return false;
    }

    @ExportMessage
    final boolean isArrayElementInsertable(long index) {
        return false;
    }

    @ExportMessage
    public Object readArrayElement(long index, @Bind(value="$node") Node node, @Cached InlinedBranchProfile errorBranch) throws InvalidArrayIndexException {
        if (!this.isArrayElementReadable(index)) {
            errorBranch.enter(node);
            throw InvalidArrayIndexException.create((long)index);
        }
        return this.data[this.offset + (int)index];
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    final void writeArrayElement(long index, Object value) throws UnsupportedMessageException {
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    final boolean hasBufferElements() {
        return true;
    }

    @ExportMessage
    final long getBufferSize() {
        return this.length;
    }

    private void checkBufferOffset(long byteOffset, int opLength) throws InvalidBufferOffsetException {
        if (byteOffset < 0L || opLength < 0 || this.getBufferSize() - (long)opLength < byteOffset) {
            throw InvalidBufferOffsetException.create((long)byteOffset, (long)opLength);
        }
    }

    @ExportMessage
    final void readBuffer(long byteOffset, byte[] destination, int destinationOffset, int opLength) throws InvalidBufferOffsetException {
        this.checkBufferOffset(byteOffset, opLength);
        System.arraycopy(this.data, this.offset + (int)byteOffset, destination, destinationOffset, opLength);
    }

    @ExportMessage
    final byte readBufferByte(long byteOffset) throws InvalidBufferOffsetException {
        this.checkBufferOffset(byteOffset, 1);
        return this.data[this.offset + (int)byteOffset];
    }

    @ExportMessage
    final short readBufferShort(ByteOrder order, long byteOffset) throws InvalidBufferOffsetException {
        this.checkBufferOffset(byteOffset, 2);
        if (order == ByteOrder.LITTLE_ENDIAN) {
            return ByteArraySupport.littleEndian().getShort(this.data, (long)this.offset + byteOffset);
        }
        return ByteArraySupport.bigEndian().getShort(this.data, (long)this.offset + byteOffset);
    }

    @ExportMessage
    final int readBufferInt(ByteOrder order, long byteOffset) throws InvalidBufferOffsetException {
        this.checkBufferOffset(byteOffset, 4);
        if (order == ByteOrder.LITTLE_ENDIAN) {
            return ByteArraySupport.littleEndian().getInt(this.data, (long)this.offset + byteOffset);
        }
        return ByteArraySupport.bigEndian().getInt(this.data, (long)this.offset + byteOffset);
    }

    @ExportMessage
    final long readBufferLong(ByteOrder order, long byteOffset) throws InvalidBufferOffsetException {
        this.checkBufferOffset(byteOffset, 8);
        if (order == ByteOrder.LITTLE_ENDIAN) {
            return ByteArraySupport.littleEndian().getLong(this.data, (long)this.offset + byteOffset);
        }
        return ByteArraySupport.bigEndian().getLong(this.data, (long)this.offset + byteOffset);
    }

    @ExportMessage
    final float readBufferFloat(ByteOrder order, long byteOffset) throws InvalidBufferOffsetException {
        this.checkBufferOffset(byteOffset, 4);
        if (order == ByteOrder.LITTLE_ENDIAN) {
            return ByteArraySupport.littleEndian().getFloat(this.data, (long)this.offset + byteOffset);
        }
        return ByteArraySupport.bigEndian().getFloat(this.data, (long)this.offset + byteOffset);
    }

    @ExportMessage
    final double readBufferDouble(ByteOrder order, long byteOffset) throws InvalidBufferOffsetException {
        this.checkBufferOffset(byteOffset, 8);
        if (order == ByteOrder.LITTLE_ENDIAN) {
            return ByteArraySupport.littleEndian().getDouble(this.data, (long)this.offset + byteOffset);
        }
        return ByteArraySupport.bigEndian().getDouble(this.data, (long)this.offset + byteOffset);
    }
}

