/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.api;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import java.util.List;

@ExportLibrary(value=InteropLibrary.class)
public class Sequence<T>
implements TruffleObject {
    private final List<T> list;

    public Sequence(List<T> list) {
        this.list = list;
    }

    @ExportMessage
    public boolean hasArrayElements() {
        return true;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    public long getArraySize() {
        return this.list.size();
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    public boolean isArrayElementReadable(long index) {
        return index >= 0L && index < this.getArraySize();
    }

    @ExportMessage
    public final boolean isArrayElementModifiable(long index) {
        return false;
    }

    @ExportMessage
    public final boolean isArrayElementInsertable(long index) {
        return false;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    public Object readArrayElement(long index) throws InvalidArrayIndexException {
        if (!this.isArrayElementReadable(index)) {
            throw InvalidArrayIndexException.create((long)index);
        }
        return this.list.get((int)index);
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    public final void writeArrayElement(long index, Object value) throws UnsupportedMessageException {
        throw UnsupportedMessageException.create();
    }
}

