/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.api;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.TruffleContext;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.Source;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import org.graalvm.collections.EconomicMap;
import org.graalvm.polyglot.io.ByteSequence;
import org.graalvm.wasm.EmbedderDataHolder;
import org.graalvm.wasm.ImportDescriptor;
import org.graalvm.wasm.WasmConstant;
import org.graalvm.wasm.WasmContext;
import org.graalvm.wasm.WasmCustomSection;
import org.graalvm.wasm.WasmFunction;
import org.graalvm.wasm.WasmFunctionInstance;
import org.graalvm.wasm.WasmInstance;
import org.graalvm.wasm.WasmLanguage;
import org.graalvm.wasm.WasmMath;
import org.graalvm.wasm.WasmModule;
import org.graalvm.wasm.WasmTable;
import org.graalvm.wasm.api.ByteArrayBuffer;
import org.graalvm.wasm.api.Dictionary;
import org.graalvm.wasm.api.Executable;
import org.graalvm.wasm.api.ImportExportKind;
import org.graalvm.wasm.api.JsConstants;
import org.graalvm.wasm.api.ModuleExportDescriptor;
import org.graalvm.wasm.api.ModuleImportDescriptor;
import org.graalvm.wasm.api.Sequence;
import org.graalvm.wasm.api.TableKind;
import org.graalvm.wasm.api.ValueType;
import org.graalvm.wasm.api.WasmModuleWithSource;
import org.graalvm.wasm.exception.Failure;
import org.graalvm.wasm.exception.WasmException;
import org.graalvm.wasm.exception.WasmJsApiException;
import org.graalvm.wasm.globals.DefaultWasmGlobal;
import org.graalvm.wasm.globals.ExportedWasmGlobal;
import org.graalvm.wasm.globals.WasmGlobal;
import org.graalvm.wasm.memory.WasmMemory;
import org.graalvm.wasm.memory.WasmMemoryFactory;

public class WebAssembly
extends Dictionary {
    private final WasmContext currentContext;
    private final boolean refTypes;

    public WebAssembly(WasmContext currentContext) {
        this.currentContext = currentContext;
        this.refTypes = currentContext.getContextOptions().supportBulkMemoryAndRefTypes();
        this.addMember("module_decode", new Executable(this::moduleDecode));
        this.addMember("module_instantiate", new Executable(this::moduleInstantiate));
        this.addMember("module_validate", new Executable(this::moduleValidate));
        this.addMember("table_alloc", new Executable(this::tableAlloc));
        this.addMember("table_grow", new Executable(WebAssembly::tableGrow));
        this.addMember("table_read", new Executable(WebAssembly::tableRead));
        this.addMember("table_write", new Executable(this::tableWrite));
        this.addMember("table_size", new Executable(WebAssembly::tableSize));
        this.addMember("func_type", new Executable(WebAssembly::funcType));
        this.addMember("is_func", new Executable(WebAssembly::isFunc));
        this.addMember("mem_alloc", new Executable(WebAssembly::memAlloc));
        this.addMember("mem_grow", new Executable(WebAssembly::memGrow));
        this.addMember("mem_set_grow_callback", new Executable(WebAssembly::memSetGrowCallback));
        this.addMember("mem_as_byte_buffer", new Executable(WebAssembly::memAsByteBuffer));
        this.addMember("mem_set_notify_callback", new Executable(WebAssembly::memSetNotifyCallback));
        this.addMember("mem_set_wait_callback", new Executable(WebAssembly::memSetWaitCallback));
        this.addMember("global_alloc", new Executable(this::globalAlloc));
        this.addMember("global_read", new Executable(WebAssembly::globalRead));
        this.addMember("global_write", new Executable(this::globalWrite));
        this.addMember("module_imports", new Executable(WebAssembly::moduleImports));
        this.addMember("module_exports", new Executable(WebAssembly::moduleExports));
        this.addMember("custom_sections", new Executable(WebAssembly::customSections));
        this.addMember("instance_export", new Executable(WebAssembly::instanceExport));
        this.addMember("embedder_data_get", new Executable(WebAssembly::embedderDataGet));
        this.addMember("embedder_data_set", new Executable(WebAssembly::embedderDataSet));
        this.addMember("ref_null", WasmConstant.NULL);
    }

    public WasmInstance moduleInstantiate(Object[] args) {
        WebAssembly.checkArgumentCount(args, 2);
        WasmModule source = WebAssembly.toModule(args);
        Object importObject = args[1];
        return this.moduleInstantiate(source, importObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WasmInstance moduleInstantiate(WasmModule module, Object importObject) {
        CompilerAsserts.neverPartOfCompilation();
        TruffleContext innerTruffleContext = this.currentContext.environment().newInnerContextBuilder(new String[0]).initializeCreatorContext(true).build();
        Object prev = innerTruffleContext.enter(null);
        try {
            WasmContext instanceContext = WasmContext.get(null);
            instanceContext.inheritCallbacksFromParentContext(this.currentContext);
            WasmInstance instance = WebAssembly.instantiateModule(module, instanceContext);
            Function<ImportDescriptor, Object> imports = WebAssembly.resolveModuleImports(module, instanceContext, importObject);
            instanceContext.linker().tryLink(instance, imports);
            WasmInstance wasmInstance = instance;
            return wasmInstance;
        }
        finally {
            innerTruffleContext.leave(null, prev);
        }
    }

    private static WasmInstance instantiateModule(WasmModule module, WasmContext context) {
        return context.readInstance(module);
    }

    private static Function<ImportDescriptor, Object> resolveModuleImports(WasmModule module, WasmContext context, Object importObject) {
        CompilerAsserts.neverPartOfCompilation();
        ArrayList<Object> resolvedImports = new ArrayList<Object>(module.numImportedSymbols());
        if (!module.importedSymbols().isEmpty()) {
            WebAssembly.requireImportObject(importObject);
        }
        for (ImportDescriptor descriptor : module.importedSymbols()) {
            int listIndex = resolvedImports.size();
            assert (listIndex == descriptor.importedSymbolIndex());
            Object member = WebAssembly.getImportObjectMemberInParentContext(importObject, descriptor, context);
            resolvedImports.add(switch (descriptor.identifier()) {
                case 0 -> WebAssembly.requireCallableInParentContext(member, descriptor, context);
                case 1 -> WebAssembly.requireWasmTable(member, descriptor);
                case 2 -> WebAssembly.requireWasmMemory(member, descriptor);
                case 3 -> WebAssembly.requireWasmGlobal(member, descriptor);
                default -> throw WasmException.create(Failure.UNSPECIFIED_INTERNAL, "Unknown import descriptor type: " + descriptor.identifier());
            });
        }
        assert (resolvedImports.size() == module.numImportedSymbols());
        return importDesc -> resolvedImports.get(importDesc.importedSymbolIndex());
    }

    private static Object requireImportObject(Object importObject) {
        InteropLibrary interop = InteropLibrary.getUncached((Object)importObject);
        if (interop.isNull(importObject) || !interop.hasMembers(importObject)) {
            throw new WasmJsApiException(WasmJsApiException.Kind.TypeError, "Module requires imports, but import object is undefined.");
        }
        return importObject;
    }

    private static Object getImportObjectMemberInParentContext(Object importObject, ImportDescriptor descriptor, WasmContext context) {
        TruffleContext parentContext = context.environment().getContext().getParent();
        Object prev = parentContext.enter(null);
        try {
            InteropLibrary importObjectInterop = InteropLibrary.getUncached((Object)importObject);
            if (!importObjectInterop.isMemberReadable(importObject, descriptor.moduleName())) {
                throw WasmJsApiException.format(WasmJsApiException.Kind.TypeError, "Import object does not contain module \"%s\".", (Object)descriptor.moduleName());
            }
            Object importedModuleObject = importObjectInterop.readMember(importObject, descriptor.moduleName());
            InteropLibrary moduleObjectInterop = InteropLibrary.getUncached((Object)importedModuleObject);
            if (!moduleObjectInterop.isMemberReadable(importedModuleObject, descriptor.memberName())) {
                throw WasmJsApiException.format(WasmJsApiException.Kind.LinkError, "Import module object \"%s\" does not contain \"%s\".", descriptor.moduleName(), descriptor.memberName());
            }
            Object object = moduleObjectInterop.readMember(importedModuleObject, descriptor.memberName());
            return object;
        }
        catch (UnknownIdentifierException | UnsupportedMessageException e) {
            throw WasmException.create(Failure.UNSPECIFIED_INTERNAL, "Unexpected state.");
        }
        finally {
            parentContext.leave(null, prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object requireCallableInParentContext(Object member, ImportDescriptor importDescriptor, WasmContext context) {
        Object executable;
        TruffleContext parentContext = context.environment().getContext().getParent();
        Object prev = parentContext.enter(null);
        try {
            executable = WebAssembly.requireCallable(member, importDescriptor);
        }
        finally {
            parentContext.leave(null, prev);
        }
        return executable;
    }

    private static Object requireCallable(Object member, ImportDescriptor importDescriptor) {
        if (!(member instanceof WasmFunctionInstance) && !InteropLibrary.getUncached().isExecutable(member)) {
            throw new WasmJsApiException(WasmJsApiException.Kind.LinkError, "Member " + String.valueOf(member) + " " + String.valueOf(importDescriptor) + " is not callable.");
        }
        return member;
    }

    private static WasmMemory requireWasmMemory(Object member, ImportDescriptor importDescriptor) {
        if (!(member instanceof WasmMemory)) {
            throw new WasmJsApiException(WasmJsApiException.Kind.LinkError, "Member " + String.valueOf(member) + " " + String.valueOf(importDescriptor) + " is not a valid memory.");
        }
        WasmMemory memory = (WasmMemory)member;
        return memory;
    }

    private static WasmTable requireWasmTable(Object member, ImportDescriptor importDescriptor) {
        if (!(member instanceof WasmTable)) {
            throw new WasmJsApiException(WasmJsApiException.Kind.LinkError, "Member " + String.valueOf(member) + " " + String.valueOf(importDescriptor) + " is not a valid table.");
        }
        WasmTable table = (WasmTable)member;
        return table;
    }

    private static WasmGlobal requireWasmGlobal(Object member, ImportDescriptor importDescriptor) {
        if (!(member instanceof WasmGlobal)) {
            throw new WasmJsApiException(WasmJsApiException.Kind.LinkError, "Member " + String.valueOf(member) + " " + String.valueOf(importDescriptor) + " is not a valid global.");
        }
        WasmGlobal global = (WasmGlobal)member;
        return global;
    }

    private static String makeModuleName(byte[] data) {
        return "js:module-" + Integer.toHexString(Arrays.hashCode(data));
    }

    private WasmModuleWithSource moduleDecodeImpl(byte[] data) {
        String moduleName = WebAssembly.makeModuleName(data);
        Source source = Source.newBuilder((String)"wasm", (ByteSequence)ByteSequence.create((byte[])data), (String)moduleName).build();
        CallTarget parseResult = this.currentContext.environment().parsePublic(source, WasmLanguage.PARSE_JS_MODULE_ARGS);
        WasmModule module = WasmLanguage.getParsedModule(parseResult);
        assert (module.limits().equals(JsConstants.JS_LIMITS));
        return new WasmModuleWithSource(module, source);
    }

    public Object moduleDecode(Object[] args) {
        WebAssembly.checkArgumentCount(args, 1);
        return this.moduleDecodeImpl(WebAssembly.toBytes(args[0]));
    }

    public WasmModule moduleDecode(byte[] source) {
        return this.moduleDecodeImpl(source).module();
    }

    private boolean moduleValidate(Object[] args) {
        WebAssembly.checkArgumentCount(args, 1);
        return this.moduleValidate(WebAssembly.toBytes(args[0]));
    }

    public boolean moduleValidate(byte[] bytes) {
        try {
            this.moduleDecode(bytes);
            return true;
        }
        catch (WasmException ex) {
            return false;
        }
    }

    private static void checkArgumentCount(Object[] args, int requiredCount) {
        if (args.length < requiredCount) {
            throw new WasmJsApiException(WasmJsApiException.Kind.TypeError, "Insufficient number of arguments");
        }
    }

    private static byte[] toBytes(Object source) {
        InteropLibrary interop = InteropLibrary.getUncached((Object)source);
        try {
            long size;
            if (interop.hasBufferElements(source)) {
                long size2 = interop.getBufferSize(source);
                if (size2 == (long)((int)size2)) {
                    byte[] bytes = new byte[(int)size2];
                    interop.readBuffer(source, 0L, bytes, 0, (int)size2);
                    return bytes;
                }
            } else if (interop.hasArrayElements(source) && (size = interop.getArraySize(source)) == (long)((int)size)) {
                byte[] bytes = new byte[(int)size];
                for (int i = 0; i < bytes.length; ++i) {
                    Object element = interop.readArrayElement(source, (long)i);
                    bytes[i] = element instanceof Number ? ((Number)element).byteValue() : InteropLibrary.getUncached((Object)element).asByte(element);
                }
                return bytes;
            }
        }
        catch (InteropException iex) {
            throw WebAssembly.cannotConvertToBytesError(iex);
        }
        throw WebAssembly.cannotConvertToBytesError(null);
    }

    private static WasmJsApiException cannotConvertToBytesError(Throwable cause) {
        WasmJsApiException.Kind kind = WasmJsApiException.Kind.TypeError;
        String message = "Cannot convert to bytes";
        return cause == null ? new WasmJsApiException(kind, message) : new WasmJsApiException(kind, message, cause);
    }

    private static WasmModule toModule(Object[] args) {
        WebAssembly.checkArgumentCount(args, 1);
        Object object = args[0];
        if (object instanceof WasmModuleWithSource) {
            WasmModuleWithSource moduleObject = (WasmModuleWithSource)object;
            return moduleObject.module();
        }
        throw new WasmJsApiException(WasmJsApiException.Kind.TypeError, "First argument must be wasm module");
    }

    private static Object moduleExports(Object[] args) {
        WasmModule module = WebAssembly.toModule(args);
        return WebAssembly.moduleExports(module);
    }

    public static Sequence<ModuleExportDescriptor> moduleExports(WasmModule module) {
        CompilerAsserts.neverPartOfCompilation();
        ArrayList<ModuleExportDescriptor> list = new ArrayList<ModuleExportDescriptor>();
        for (String name : module.exportedSymbols()) {
            WasmFunction f = (WasmFunction)module.exportedFunctions().get((Object)name);
            Integer globalIndex = (Integer)module.exportedGlobals().get((Object)name);
            Integer tableIndex = (Integer)module.exportedTables().get((Object)name);
            Integer memoryIndex = (Integer)module.exportedMemories().get((Object)name);
            if (memoryIndex != null) {
                String shared = module.memoryIsShared(memoryIndex) ? "shared" : "single";
                list.add(new ModuleExportDescriptor(name, ImportExportKind.memory.name(), shared));
                continue;
            }
            if (tableIndex != null) {
                list.add(new ModuleExportDescriptor(name, ImportExportKind.table.name(), TableKind.toString(module.tableElementType(tableIndex))));
                continue;
            }
            if (f != null) {
                list.add(new ModuleExportDescriptor(name, ImportExportKind.function.name(), WebAssembly.functionTypeToString(f)));
                continue;
            }
            if (globalIndex != null) {
                String valueType = ValueType.fromByteValue(module.globalValueType(globalIndex)).toString();
                String mutability = module.isGlobalMutable(globalIndex) ? "mut" : "con";
                list.add(new ModuleExportDescriptor(name, ImportExportKind.global.name(), valueType + " " + mutability));
                continue;
            }
            throw WasmException.create(Failure.UNSPECIFIED_INTERNAL, "Exported symbol list does not match the actual exports.");
        }
        return new Sequence<ModuleExportDescriptor>(list);
    }

    private static Object moduleImports(Object[] args) {
        WasmModule module = WebAssembly.toModule(args);
        return WebAssembly.moduleImports(module);
    }

    public static Sequence<ModuleImportDescriptor> moduleImports(WasmModule module) {
        return new Sequence<ModuleImportDescriptor>(WebAssembly.moduleImportsAsList(module));
    }

    public static List<ModuleImportDescriptor> moduleImportsAsList(WasmModule module) {
        CompilerAsserts.neverPartOfCompilation();
        EconomicMap<ImportDescriptor, Integer> importedGlobalDescriptors = module.importedGlobalDescriptors();
        EconomicMap<ImportDescriptor, Integer> importedTableDescriptors = module.importedTableDescriptors();
        EconomicMap<ImportDescriptor, Integer> importedMemoryDescriptors = module.importedMemoryDescriptors();
        ArrayList<ModuleImportDescriptor> list = new ArrayList<ModuleImportDescriptor>();
        block6: for (ImportDescriptor descriptor : module.importedSymbols()) {
            switch (descriptor.identifier()) {
                case 0: {
                    WasmFunction f = module.importedFunction(descriptor);
                    list.add(new ModuleImportDescriptor(f.importedModuleName(), f.importedFunctionName(), ImportExportKind.function.name(), WebAssembly.functionTypeToString(f)));
                    continue block6;
                }
                case 1: {
                    Integer tableIndex = (Integer)importedTableDescriptors.get((Object)descriptor);
                    if (tableIndex != null) {
                        list.add(new ModuleImportDescriptor(descriptor.moduleName(), descriptor.memberName(), ImportExportKind.table.name(), TableKind.toString(module.tableElementType(tableIndex))));
                        continue block6;
                    }
                    throw WasmException.create(Failure.UNSPECIFIED_INTERNAL, "Table import inconsistent.");
                }
                case 2: {
                    Integer memoryIndex = (Integer)importedMemoryDescriptors.get((Object)descriptor);
                    if (memoryIndex != null) {
                        list.add(new ModuleImportDescriptor(descriptor.moduleName(), descriptor.memberName(), ImportExportKind.memory.name(), null));
                        continue block6;
                    }
                    throw WasmException.create(Failure.UNSPECIFIED_INTERNAL, "Memory import inconsistent.");
                }
                case 3: {
                    Integer index = (Integer)importedGlobalDescriptors.get((Object)descriptor);
                    String valueType = ValueType.fromByteValue(module.globalValueType(index)).toString();
                    list.add(new ModuleImportDescriptor(descriptor.moduleName(), descriptor.memberName(), ImportExportKind.global.name(), valueType));
                    continue block6;
                }
            }
            throw WasmException.create(Failure.UNSPECIFIED_INTERNAL, "Unknown import descriptor type: " + descriptor.identifier());
        }
        return List.copyOf(list);
    }

    private static Object customSections(Object[] args) {
        WebAssembly.checkArgumentCount(args, 2);
        WasmModule module = WebAssembly.toModule(args);
        return WebAssembly.customSections(module, args[1]);
    }

    public static Sequence<ByteArrayBuffer> customSections(WasmModule module, Object sectionName) {
        String name;
        try {
            name = InteropLibrary.getUncached().asString(sectionName);
        }
        catch (UnsupportedMessageException e) {
            throw new WasmJsApiException(WasmJsApiException.Kind.TypeError, "Section name must be a string");
        }
        ArrayList<ByteArrayBuffer> sections = new ArrayList<ByteArrayBuffer>();
        for (WasmCustomSection section : module.customSections()) {
            if (!section.name().equals(name)) continue;
            sections.add(new ByteArrayBuffer(module.customData(), section.offset(), section.length()));
        }
        return new Sequence<ByteArrayBuffer>(sections);
    }

    private Object tableAlloc(Object[] args) {
        int initialSize;
        if (this.refTypes) {
            WebAssembly.checkArgumentCount(args, 2);
        } else {
            WebAssembly.checkArgumentCount(args, 1);
        }
        int maximumSize = -1;
        TableKind elementKind = TableKind.anyfunc;
        Object initialValue = WasmConstant.NULL;
        InteropLibrary lib = InteropLibrary.getUncached();
        try {
            initialSize = lib.asInt(args[0]);
        }
        catch (UnsupportedMessageException e) {
            throw new WasmJsApiException(WasmJsApiException.Kind.TypeError, "Initial size must be convertible to int");
        }
        int state = args.length == 1 ? -1 : (lib.fitsInInt(args[1]) ? 0 : (args.length >= 3 ? 1 : 2));
        int i = 1;
        while (state != -1) {
            Object value = args[i];
            switch (state) {
                case 0: {
                    try {
                        maximumSize = lib.asInt(value);
                    }
                    catch (UnsupportedMessageException e) {
                        throw new WasmJsApiException(WasmJsApiException.Kind.TypeError, "Maximum size must be convertible to int");
                    }
                    if (args.length == 2) {
                        state = -1;
                        break;
                    }
                    if (args.length >= 4) {
                        state = 1;
                        break;
                    }
                    state = 2;
                    break;
                }
                case 1: {
                    try {
                        elementKind = TableKind.valueOf(lib.asString(value));
                    }
                    catch (UnsupportedMessageException e) {
                        throw new WasmJsApiException(WasmJsApiException.Kind.TypeError, "Element kind must be one of externref or anyfunc");
                    }
                    state = 2;
                    break;
                }
                case 2: {
                    initialValue = value;
                    state = -1;
                }
            }
            ++i;
        }
        return this.tableAlloc(initialSize, maximumSize, elementKind, initialValue);
    }

    public WasmTable tableAlloc(int initial, int maximum, TableKind elemKind, Object initialValue) {
        if (Integer.compareUnsigned(initial, maximum) > 0) {
            throw new WasmJsApiException(WasmJsApiException.Kind.RangeError, "Min table size exceeds max memory size");
        }
        if (Integer.compareUnsigned(initial, JsConstants.JS_LIMITS.tableInstanceSizeLimit()) > 0) {
            throw new WasmJsApiException(WasmJsApiException.Kind.RangeError, "Min table size exceeds implementation limit");
        }
        if (elemKind != TableKind.externref && elemKind != TableKind.anyfunc) {
            throw new WasmJsApiException(WasmJsApiException.Kind.TypeError, "Element type must be a reftype");
        }
        if (!this.refTypes && elemKind == TableKind.externref) {
            throw new WasmJsApiException(WasmJsApiException.Kind.TypeError, "Element type must be anyfunc. Enable reference types to support externref");
        }
        int maxAllowedSize = WasmMath.minUnsigned(maximum, JsConstants.JS_LIMITS.tableInstanceSizeLimit());
        return new WasmTable(initial, maximum, maxAllowedSize, elemKind.byteValue(), initialValue);
    }

    private static Object tableGrow(Object[] args) {
        WebAssembly.checkArgumentCount(args, 2);
        if (!(args[0] instanceof WasmTable)) {
            throw new WasmJsApiException(WasmJsApiException.Kind.TypeError, "First argument must be wasm table");
        }
        if (!(args[1] instanceof Integer)) {
            throw new WasmJsApiException(WasmJsApiException.Kind.TypeError, "Second argument must be integer");
        }
        WasmTable table = (WasmTable)args[0];
        int delta = (Integer)args[1];
        if (args.length > 2) {
            return WebAssembly.tableGrow(table, delta, args[2]);
        }
        return WebAssembly.tableGrow(table, delta, WasmConstant.NULL);
    }

    public static int tableGrow(WasmTable table, int delta, Object ref) {
        int result = table.grow(delta, ref);
        if (result == -1) {
            throw new WasmJsApiException(WasmJsApiException.Kind.RangeError, "Cannot grow table above max limit");
        }
        return result;
    }

    private static Object tableRead(Object[] args) {
        WebAssembly.checkArgumentCount(args, 2);
        if (!(args[0] instanceof WasmTable)) {
            throw new WasmJsApiException(WasmJsApiException.Kind.TypeError, "First argument must be wasm table");
        }
        if (!(args[1] instanceof Integer)) {
            throw new WasmJsApiException(WasmJsApiException.Kind.TypeError, "Second argument must be integer");
        }
        WasmTable table = (WasmTable)args[0];
        int index = (Integer)args[1];
        return WebAssembly.tableRead(table, index);
    }

    public static Object tableRead(WasmTable table, int index) {
        try {
            return table.get(index);
        }
        catch (IndexOutOfBoundsException e) {
            throw new WasmJsApiException(WasmJsApiException.Kind.RangeError, "Table index out of bounds: " + e.getMessage());
        }
    }

    private Object tableWrite(Object[] args) {
        WebAssembly.checkArgumentCount(args, 3);
        if (!(args[0] instanceof WasmTable)) {
            throw new WasmJsApiException(WasmJsApiException.Kind.TypeError, "First argument must be wasm table");
        }
        if (!(args[1] instanceof Integer)) {
            throw new WasmJsApiException(WasmJsApiException.Kind.TypeError, "Second argument must be integer");
        }
        WasmTable table = (WasmTable)args[0];
        int index = (Integer)args[1];
        return this.tableWrite(table, index, args[2]);
    }

    public Object tableWrite(WasmTable table, int index, Object element) {
        Object elem;
        if (element instanceof WasmFunctionInstance) {
            elem = element;
        } else if (element == WasmConstant.NULL) {
            elem = WasmConstant.NULL;
        } else {
            if (!this.currentContext.getContextOptions().supportBulkMemoryAndRefTypes()) {
                throw new WasmJsApiException(WasmJsApiException.Kind.TypeError, "Invalid table element");
            }
            if (table.elemType() == 112) {
                throw new WasmJsApiException(WasmJsApiException.Kind.TypeError, "Invalid table element");
            }
            elem = element;
        }
        try {
            table.set(index, elem);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new WasmJsApiException(WasmJsApiException.Kind.RangeError, "Table index out of bounds: " + e.getMessage());
        }
        return WasmConstant.VOID;
    }

    private static Object tableSize(Object[] args) {
        WebAssembly.checkArgumentCount(args, 1);
        if (!(args[0] instanceof WasmTable)) {
            throw new WasmJsApiException(WasmJsApiException.Kind.TypeError, "First argument must be wasm table");
        }
        WasmTable table = (WasmTable)args[0];
        return WebAssembly.tableSize(table);
    }

    public static int tableSize(WasmTable table) {
        return table.size();
    }

    private static Object funcType(Object[] args) {
        WebAssembly.checkArgumentCount(args, 1);
        if (args[0] instanceof WasmFunctionInstance) {
            WasmFunction fn = ((WasmFunctionInstance)args[0]).function();
            return WebAssembly.functionTypeToString(fn);
        }
        throw new WasmJsApiException(WasmJsApiException.Kind.TypeError, "First argument must be wasm function");
    }

    private static Object isFunc(Object[] args) {
        WebAssembly.checkArgumentCount(args, 1);
        return args[0] instanceof WasmFunctionInstance;
    }

    public static String functionTypeToString(WasmFunction f) {
        CompilerAsserts.neverPartOfCompilation();
        StringBuilder typeInfo = new StringBuilder();
        typeInfo.append(f.index());
        typeInfo.append('(');
        int paramCount = f.paramCount();
        for (int i = 0; i < paramCount; ++i) {
            if (i != 0) {
                typeInfo.append(' ');
            }
            typeInfo.append((Object)ValueType.fromByteValue(f.paramTypeAt(i)));
        }
        typeInfo.append(')');
        int resultCount = f.resultCount();
        for (int i = 0; i < resultCount; ++i) {
            if (i != 0) {
                typeInfo.append(' ');
            }
            typeInfo.append((Object)ValueType.fromByteValue(f.resultTypeAt(i)));
        }
        return typeInfo.toString();
    }

    private static Object memAlloc(Object[] args) {
        boolean shared;
        int maximumSize;
        int initialSize;
        WebAssembly.checkArgumentCount(args, 1);
        InteropLibrary lib = InteropLibrary.getUncached();
        try {
            initialSize = lib.asInt(args[0]);
        }
        catch (UnsupportedMessageException e) {
            throw new WasmJsApiException(WasmJsApiException.Kind.TypeError, "Initial size must be convertible to int");
        }
        if (args.length > 1) {
            try {
                maximumSize = lib.asInt(args[1]);
            }
            catch (UnsupportedMessageException e) {
                throw new WasmJsApiException(WasmJsApiException.Kind.TypeError, "Maximum size must be convertible to int");
            }
        } else {
            maximumSize = -1;
        }
        if (args.length > 2) {
            try {
                shared = lib.asBoolean(args[2]);
            }
            catch (UnsupportedMessageException e) {
                throw new WasmJsApiException(WasmJsApiException.Kind.TypeError, "Shared flag must be convertible to boolean");
            }
        } else {
            shared = false;
        }
        return WebAssembly.memAlloc(initialSize, maximumSize, shared);
    }

    public static WasmMemory memAlloc(int initial, int maximum, boolean shared) {
        if (Integer.compareUnsigned(initial, maximum) > 0) {
            throw new WasmJsApiException(WasmJsApiException.Kind.RangeError, "Min memory size exceeds max memory size");
        }
        if (Long.compareUnsigned(initial, JsConstants.JS_LIMITS.memoryInstanceSizeLimit()) > 0) {
            throw new WasmJsApiException(WasmJsApiException.Kind.RangeError, "Min memory size exceeds implementation limit");
        }
        long maxAllowedSize = WasmMath.minUnsigned((long)maximum, JsConstants.JS_LIMITS.memoryInstanceSizeLimit());
        WasmContext context = WasmContext.get(null);
        return WasmMemoryFactory.createMemory(initial, maximum, maxAllowedSize, false, shared, context.getContextOptions().useUnsafeMemory());
    }

    private static Object memGrow(Object[] args) {
        WebAssembly.checkArgumentCount(args, 2);
        if (!(args[0] instanceof WasmMemory)) {
            throw new WasmJsApiException(WasmJsApiException.Kind.TypeError, "First argument must be wasm memory");
        }
        if (!(args[1] instanceof Integer)) {
            throw new WasmJsApiException(WasmJsApiException.Kind.TypeError, "Second argument must be integer");
        }
        WasmMemory memory = (WasmMemory)args[0];
        int delta = (Integer)args[1];
        return WebAssembly.memGrow(memory, delta);
    }

    public static long memGrow(WasmMemory memory, int delta) {
        long previousSize = memory.grow(delta);
        if (previousSize == -1L) {
            throw new WasmJsApiException(WasmJsApiException.Kind.RangeError, "Cannot grow memory above max limit");
        }
        return previousSize;
    }

    private static Object memSetGrowCallback(Object[] args) {
        WebAssembly.checkArgumentCount(args, 1);
        InteropLibrary lib = InteropLibrary.getUncached();
        if (args.length > 1) {
            if (!(args[0] instanceof WasmMemory)) {
                throw new WasmJsApiException(WasmJsApiException.Kind.TypeError, "First argument must be executable");
            }
            if (!lib.isExecutable(args[1])) {
                throw new WasmJsApiException(WasmJsApiException.Kind.TypeError, "Second argument must be executable");
            }
            return WebAssembly.memSetGrowCallback(args[1]);
        }
        if (!lib.isExecutable(args[0])) {
            throw new WasmJsApiException(WasmJsApiException.Kind.TypeError, "Argument must be executable");
        }
        return WebAssembly.memSetGrowCallback(args[0]);
    }

    private static Object memSetGrowCallback(Object callback) {
        WasmContext context = WasmContext.get(null);
        context.setMemGrowCallback(callback);
        return WasmConstant.VOID;
    }

    public static void invokeMemGrowCallback(WasmMemory memory) {
        WasmContext context = WasmContext.get(null);
        Object callback = context.getMemGrowCallback();
        if (callback != null) {
            InteropLibrary lib = InteropLibrary.getUncached();
            try {
                lib.execute(callback, new Object[]{memory});
            }
            catch (InteropException e) {
                throw new WasmJsApiException(WasmJsApiException.Kind.TypeError, "Unable to call memory grow callback", e);
            }
        }
    }

    private static Object memSetNotifyCallback(Object[] args) {
        WebAssembly.checkArgumentCount(args, 1);
        InteropLibrary lib = InteropLibrary.getUncached();
        if (args.length > 1) {
            if (!(args[0] instanceof WasmMemory)) {
                throw new WasmJsApiException(WasmJsApiException.Kind.TypeError, "First argument must be executable");
            }
            if (!lib.isExecutable(args[1])) {
                throw new WasmJsApiException(WasmJsApiException.Kind.TypeError, "Second argument must be executable");
            }
            return WebAssembly.memSetNotifyCallback(args[1]);
        }
        if (!lib.isExecutable(args[0])) {
            throw new WasmJsApiException(WasmJsApiException.Kind.TypeError, "Argument must be executable");
        }
        return WebAssembly.memSetNotifyCallback(args[0]);
    }

    private static Object memSetNotifyCallback(Object callback) {
        WasmContext context = WasmContext.get(null);
        context.setMemNotifyCallback(callback);
        return WasmConstant.VOID;
    }

    public static int invokeMemNotifyCallback(Node node, WasmMemory memory, long address, int count) {
        WasmContext context = WasmContext.get(node);
        Object callback = context.getMemNotifyCallback();
        if (callback != null) {
            InteropLibrary lib = InteropLibrary.getUncached();
            try {
                return (Integer)lib.execute(callback, new Object[]{memory, address, count});
            }
            catch (InteropException e) {
                throw new WasmJsApiException(WasmJsApiException.Kind.TypeError, "Unable to call memory notify callback", e);
            }
        }
        throw WasmException.create(Failure.UNSPECIFIED_INTERNAL, "Notify instruction used from Wasm not instantiated via JS.");
    }

    private static Object memSetWaitCallback(Object[] args) {
        WebAssembly.checkArgumentCount(args, 1);
        InteropLibrary lib = InteropLibrary.getUncached();
        if (args.length > 1) {
            if (!(args[0] instanceof WasmMemory)) {
                throw new WasmJsApiException(WasmJsApiException.Kind.TypeError, "First argument must be executable");
            }
            if (!lib.isExecutable(args[1])) {
                throw new WasmJsApiException(WasmJsApiException.Kind.TypeError, "Second argument must be executable");
            }
            return WebAssembly.memSetWaitCallback(args[1]);
        }
        if (!lib.isExecutable(args[0])) {
            throw new WasmJsApiException(WasmJsApiException.Kind.TypeError, "Argument must be executable");
        }
        return WebAssembly.memSetWaitCallback(args[0]);
    }

    private static Object memSetWaitCallback(Object callback) {
        WasmContext context = WasmContext.get(null);
        context.setMemWaitCallback(callback);
        return WasmConstant.VOID;
    }

    public static int invokeMemWaitCallback(Node node, WasmMemory memory, long address, long expected, long timeout, boolean is64) {
        WasmContext context = WasmContext.get(node);
        Object callback = context.getMemWaitCallback();
        if (callback != null) {
            InteropLibrary lib = InteropLibrary.getUncached();
            try {
                return (Integer)lib.execute(callback, new Object[]{memory, address, expected, timeout, is64});
            }
            catch (InteropException e) {
                throw new WasmJsApiException(WasmJsApiException.Kind.TypeError, "Unable to call memory wait callback", e);
            }
        }
        throw WasmException.create(Failure.UNSPECIFIED_INTERNAL, "Wait instruction used from Wasm not instantiated via JS.");
    }

    private static Object memAsByteBuffer(Object[] args) {
        WasmMemory memory;
        ByteBuffer buffer;
        WebAssembly.checkArgumentCount(args, 1);
        if (args[0] instanceof WasmMemory && (buffer = (memory = (WasmMemory)args[0]).asByteBuffer()) != null) {
            return WasmContext.get(null).environment().asGuestValue((Object)buffer);
        }
        return WasmConstant.VOID;
    }

    private Object globalAlloc(Object[] args) {
        boolean mutable;
        ValueType valueType;
        WebAssembly.checkArgumentCount(args, 2);
        InteropLibrary lib = InteropLibrary.getUncached();
        try {
            String valueTypeString = lib.asString(args[0]);
            valueType = ValueType.valueOf(valueTypeString);
        }
        catch (UnsupportedMessageException e) {
            throw new WasmJsApiException(WasmJsApiException.Kind.TypeError, "First argument (value type) must be convertible to String");
        }
        catch (IllegalArgumentException ex) {
            throw new WasmJsApiException(WasmJsApiException.Kind.TypeError, "Invalid value type");
        }
        try {
            mutable = lib.asBoolean(args[1]);
        }
        catch (UnsupportedMessageException e) {
            throw new WasmJsApiException(WasmJsApiException.Kind.TypeError, "First argument (mutable) must be convertible to boolean");
        }
        return this.globalAlloc(valueType, mutable, args[2]);
    }

    public WasmGlobal globalAlloc(ValueType valueType, boolean mutable, Object value) {
        InteropLibrary valueInterop = InteropLibrary.getUncached((Object)value);
        try {
            switch (valueType) {
                case i32: {
                    return new DefaultWasmGlobal(valueType, mutable, valueInterop.asInt(value));
                }
                case i64: {
                    return new DefaultWasmGlobal(valueType, mutable, valueInterop.asLong(value));
                }
                case f32: {
                    return new DefaultWasmGlobal(valueType, mutable, Float.floatToRawIntBits(valueInterop.asFloat(value)));
                }
                case f64: {
                    return new DefaultWasmGlobal(valueType, mutable, Double.doubleToRawLongBits(valueInterop.asDouble(value)));
                }
                case anyfunc: {
                    if (!this.refTypes || value != WasmConstant.NULL && !(value instanceof WasmFunctionInstance)) {
                        throw new WasmJsApiException(WasmJsApiException.Kind.TypeError, "Invalid value type");
                    }
                    return new DefaultWasmGlobal(valueType, mutable, value);
                }
                case externref: {
                    if (!this.refTypes) {
                        throw new WasmJsApiException(WasmJsApiException.Kind.TypeError, "Invalid value type");
                    }
                    return new DefaultWasmGlobal(valueType, mutable, value);
                }
            }
            throw new WasmJsApiException(WasmJsApiException.Kind.TypeError, "Invalid value type");
        }
        catch (UnsupportedMessageException ex) {
            throw new WasmJsApiException(WasmJsApiException.Kind.TypeError, "Cannot convert value to the specified value type");
        }
    }

    private static Object globalRead(Object[] args) {
        WebAssembly.checkArgumentCount(args, 1);
        if (!(args[0] instanceof WasmGlobal)) {
            throw new WasmJsApiException(WasmJsApiException.Kind.TypeError, "First argument must be wasm global");
        }
        WasmGlobal global = (WasmGlobal)args[0];
        return WebAssembly.globalRead(global);
    }

    public static Object globalRead(WasmGlobal global) {
        switch (global.getValueType()) {
            case i32: {
                return global.loadAsInt();
            }
            case i64: {
                return global.loadAsLong();
            }
            case f32: {
                return Float.valueOf(Float.intBitsToFloat(global.loadAsInt()));
            }
            case f64: {
                return Double.longBitsToDouble(global.loadAsLong());
            }
            case anyfunc: 
            case externref: {
                return global.loadAsObject();
            }
        }
        throw new WasmJsApiException(WasmJsApiException.Kind.TypeError, "Incorrect internal Global type");
    }

    private Object globalWrite(Object[] args) {
        WebAssembly.checkArgumentCount(args, 2);
        if (!(args[0] instanceof WasmGlobal)) {
            throw new WasmJsApiException(WasmJsApiException.Kind.TypeError, "First argument must be wasm global");
        }
        WasmGlobal global = (WasmGlobal)args[0];
        return this.globalWrite(global, args[1]);
    }

    public Object globalWrite(WasmGlobal global, Object value) {
        if (!global.isMutable()) {
            throw WasmJsApiException.format(WasmJsApiException.Kind.TypeError, "Global is not mutable.");
        }
        ValueType valueType = global.getValueType();
        switch (valueType) {
            case i32: {
                if (!(value instanceof Integer)) {
                    throw WasmJsApiException.format(WasmJsApiException.Kind.TypeError, "Global type %s, value: %s", new Object[]{valueType, value});
                }
                global.storeInt((Integer)value);
                break;
            }
            case i64: {
                if (!(value instanceof Long)) {
                    throw WasmJsApiException.format(WasmJsApiException.Kind.TypeError, "Global type %s, value: %s", new Object[]{valueType, value});
                }
                global.storeLong((Long)value);
                break;
            }
            case f32: {
                if (!(value instanceof Float)) {
                    throw WasmJsApiException.format(WasmJsApiException.Kind.TypeError, "Global type %s, value: %s", new Object[]{valueType, value});
                }
                global.storeInt(Float.floatToRawIntBits(((Float)value).floatValue()));
                break;
            }
            case f64: {
                if (!(value instanceof Double)) {
                    throw WasmJsApiException.format(WasmJsApiException.Kind.TypeError, "Global type %s, value: %s", new Object[]{valueType, value});
                }
                global.storeLong(Double.doubleToRawLongBits((Double)value));
                break;
            }
            case anyfunc: {
                if (!this.refTypes) {
                    throw WasmJsApiException.format(WasmJsApiException.Kind.TypeError, "Invalid value type. Reference types are not enabled");
                }
                if (value != WasmConstant.NULL && !(value instanceof WasmFunctionInstance)) {
                    throw WasmJsApiException.format(WasmJsApiException.Kind.TypeError, "Global type %s, value: %s", new Object[]{valueType, value});
                }
                global.storeObject(value);
                break;
            }
            case externref: {
                if (!this.refTypes) {
                    throw WasmJsApiException.format(WasmJsApiException.Kind.TypeError, "Invalid value type. Reference types are not enabled");
                }
                global.storeObject(value);
            }
        }
        return WasmConstant.VOID;
    }

    private static Object instanceExport(Object[] args) {
        WebAssembly.checkArgumentCount(args, 2);
        if (!(args[0] instanceof WasmInstance)) {
            throw new WasmJsApiException(WasmJsApiException.Kind.TypeError, "First argument must be wasm instance");
        }
        if (!(args[1] instanceof String)) {
            throw new WasmJsApiException(WasmJsApiException.Kind.TypeError, "Second argument must be string");
        }
        WasmInstance instance = (WasmInstance)args[0];
        String name = (String)args[1];
        return WebAssembly.instanceExport(instance, name);
    }

    public static Object instanceExport(WasmInstance instance, String name) {
        CompilerAsserts.neverPartOfCompilation();
        WasmFunction function = (WasmFunction)instance.module().exportedFunctions().get((Object)name);
        Integer globalIndex = (Integer)instance.module().exportedGlobals().get((Object)name);
        Integer tableIndex = (Integer)instance.module().exportedTables().get((Object)name);
        Integer memoryIndex = (Integer)instance.module().exportedMemories().get((Object)name);
        if (function != null) {
            return instance.functionInstance(function);
        }
        if (globalIndex != null) {
            int index = globalIndex;
            int address = instance.globalAddress(index);
            if (address < 0) {
                return instance.context().globals().externalGlobal(address);
            }
            ValueType valueType = ValueType.fromByteValue(instance.symbolTable().globalValueType(index));
            boolean mutable = instance.symbolTable().isGlobalMutable(index);
            return new ExportedWasmGlobal(valueType, mutable, instance.context().globals(), address);
        }
        if (memoryIndex != null) {
            return instance.memory(memoryIndex);
        }
        if (tableIndex != null) {
            int address = instance.tableAddress(tableIndex);
            return instance.context().tables().table(address);
        }
        throw new WasmJsApiException(WasmJsApiException.Kind.TypeError, name + " is not a exported name of the given instance");
    }

    public static Object embedderDataSet(Object[] args) {
        WebAssembly.checkArgumentCount(args, 2);
        WebAssembly.getEmbedderDataHolder(args).setEmbedderData(args[1]);
        return WasmConstant.VOID;
    }

    public static Object embedderDataGet(Object[] args) {
        WebAssembly.checkArgumentCount(args, 1);
        return WebAssembly.getEmbedderDataHolder(args).getEmbedderData();
    }

    private static EmbedderDataHolder getEmbedderDataHolder(Object[] args) {
        if (!(args[0] instanceof EmbedderDataHolder)) {
            throw new WasmJsApiException(WasmJsApiException.Kind.TypeError, "First argument is an object that cannot hold embedder data");
        }
        return (EmbedderDataHolder)args[0];
    }
}

