/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.debugging.data;

import org.graalvm.wasm.collection.IntArrayList;
import org.graalvm.wasm.debugging.parser.DebugData;
import org.graalvm.wasm.debugging.parser.DebugParserContext;

public final class DebugDataUtil {
    private DebugDataUtil() {
    }

    public static int[] readPcsOrNull(DebugData data, DebugParserContext context) {
        int lowPc = data.asI32OrDefault(17, -1);
        if (lowPc == -1) {
            return null;
        }
        int highPc = data.asI32OrDefault(18, -1);
        if (highPc != -1) {
            if (data.isConstant(18)) {
                highPc = lowPc + highPc;
            }
        } else {
            int rangeOffset = data.asI32OrDefault(85, -1);
            if (rangeOffset == -1) {
                return null;
            }
            IntArrayList ranges = context.readRangeSectionOrNull(rangeOffset);
            if (ranges == null || ranges.size() < 2) {
                return null;
            }
            lowPc = ranges.get(0);
            highPc = ranges.get(ranges.size() - 1);
        }
        return new int[]{lowPc, highPc};
    }
}

