/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.debugging.data.objects;

import org.graalvm.wasm.debugging.DebugLocation;
import org.graalvm.wasm.debugging.data.DebugContext;
import org.graalvm.wasm.debugging.data.DebugObject;

public class DebugLink
extends DebugObject {
    private final String typeName;
    private final DebugObject reference;

    public DebugLink(String typeName, DebugObject reference) {
        assert (reference != null) : "the reference of a debug link (type reference) must not be null";
        this.typeName = typeName;
        this.reference = reference;
    }

    @Override
    public String toDisplayString() {
        return this.reference.toDisplayString();
    }

    @Override
    public DebugLocation getLocation(DebugLocation location) {
        return this.reference.getLocation(location);
    }

    @Override
    public DebugContext getContext(DebugContext context) {
        return context;
    }

    @Override
    public String asTypeName() {
        return this.typeName;
    }

    @Override
    public int valueLength() {
        return this.reference.valueLength();
    }

    @Override
    public boolean isVisible(int sourceCodeLocation) {
        return this.reference.isVisible(sourceCodeLocation);
    }

    @Override
    public boolean isValue() {
        return this.reference.isValue();
    }

    @Override
    public Object asValue(DebugContext context, DebugLocation location) {
        return this.reference.asValue(context, location);
    }

    @Override
    public boolean isDebugObject() {
        return this.reference.isDebugObject();
    }

    @Override
    public DebugObject asDebugObject(DebugContext context, DebugLocation location) {
        return this.reference.asDebugObject(context, location);
    }

    @Override
    public boolean isLocation() {
        return this.reference.isLocation();
    }

    @Override
    public DebugLocation asLocation(DebugContext context, DebugLocation location) {
        return this.reference.asLocation(context, location);
    }

    @Override
    public boolean fitsIntoInt() {
        return this.reference.fitsIntoInt();
    }

    @Override
    public int asInt(DebugContext context, DebugLocation location) {
        return this.reference.asInt(context, location);
    }

    @Override
    public boolean fitsIntoLong() {
        return this.reference.fitsIntoLong();
    }

    @Override
    public long asLong(DebugContext context, DebugLocation location) {
        return this.reference.asLong(context, location);
    }

    @Override
    public boolean hasMembers() {
        return this.reference.hasMembers();
    }

    @Override
    public int memberCount() {
        return this.reference.memberCount();
    }

    @Override
    public DebugObject readMember(DebugContext context, DebugLocation location, int index) {
        return this.reference.readMember(context, location, index);
    }

    @Override
    public boolean hasArrayElements() {
        return this.reference.hasArrayElements();
    }

    @Override
    public int arrayDimensionCount() {
        return this.reference.arrayDimensionCount();
    }

    @Override
    public int arrayDimensionSize(int dimension) {
        return this.reference.arrayDimensionSize(dimension);
    }

    @Override
    public DebugObject readArrayElement(DebugContext context, DebugLocation location, int index) {
        return this.reference.readArrayElement(context, location, index);
    }

    @Override
    public String toString() {
        return this.typeName;
    }
}

