/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.debugging.languages.rust;

import org.graalvm.wasm.debugging.DebugLocation;
import org.graalvm.wasm.debugging.data.DebugContext;
import org.graalvm.wasm.debugging.data.DebugObject;
import org.graalvm.wasm.debugging.data.DebugType;
import org.graalvm.wasm.debugging.representation.DebugConstantDisplayValue;

public class RustString
extends DebugType {
    public static final String STRING_LENGTH = "length";
    public static final String STRING_DATA = "data_ptr";
    private final String name;
    private final DebugObject lengthMember;
    private final DebugObject dataMember;

    public RustString(String name, DebugObject[] members) {
        assert (members != null) : "the members (length, buffer) of a rust string object must not be null";
        this.name = name;
        DebugObject lengthObject = null;
        DebugObject dataObject = null;
        for (DebugObject member : members) {
            if (STRING_LENGTH.equals(member.toDisplayString())) {
                lengthObject = member;
            }
            if (!STRING_DATA.equals(member.toDisplayString())) continue;
            dataObject = member;
        }
        this.lengthMember = lengthObject;
        this.dataMember = dataObject;
    }

    @Override
    public String asTypeName() {
        return this.name;
    }

    @Override
    public int valueLength() {
        return this.lengthMember.valueLength() + this.dataMember.valueLength();
    }

    @Override
    public boolean isValue() {
        return true;
    }

    @Override
    public Object asValue(DebugContext context, DebugLocation location) {
        if (this.lengthMember == null || !this.lengthMember.fitsIntoLong()) {
            return DebugConstantDisplayValue.UNSUPPORTED;
        }
        long length = this.lengthMember.asLong(context, this.lengthMember.getLocation(location));
        if (this.dataMember == null || !this.dataMember.isLocation() || length > Integer.MAX_VALUE) {
            return DebugConstantDisplayValue.UNSUPPORTED;
        }
        DebugLocation address = this.dataMember.asLocation(context, this.dataMember.getLocation(location));
        return address.loadString((int)length);
    }
}

