/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.memory;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.memory.ByteArraySupport;
import com.oracle.truffle.api.nodes.Node;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.graalvm.wasm.api.Vector128;
import org.graalvm.wasm.exception.Failure;
import org.graalvm.wasm.exception.WasmException;
import org.graalvm.wasm.memory.WasmMemory;

final class ByteArrayWasmMemory
extends WasmMemory {
    private byte[] dynamicBuffer;

    private ByteArrayWasmMemory(long declaredMinSize, long declaredMaxSize, long initialSize, long maxAllowedSize, boolean indexType64, boolean shared) {
        super(declaredMinSize, declaredMaxSize, initialSize, maxAllowedSize, indexType64, shared);
        this.dynamicBuffer = ByteArrayWasmMemory.allocateStatic(initialSize * 65536L);
    }

    ByteArrayWasmMemory(long declaredMinSize, long declaredMaxSize, long maxAllowedSize, boolean indexType64, boolean shared) {
        this(declaredMinSize, declaredMaxSize, declaredMinSize, maxAllowedSize, indexType64, shared);
    }

    private byte[] buffer() {
        return this.dynamicBuffer;
    }

    @Override
    public long size() {
        return this.byteSize() / 65536L;
    }

    @Override
    public long byteSize() {
        return this.buffer().length;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public synchronized long grow(long extraPageSize) {
        long previousSize = this.size();
        if (extraPageSize == 0L) {
            this.invokeGrowCallback();
            return previousSize;
        }
        if (Long.compareUnsigned(extraPageSize, this.maxAllowedSize) <= 0 && Long.compareUnsigned(this.size() + extraPageSize, this.maxAllowedSize) <= 0) {
            long targetByteSize = StrictMath.multiplyExact(StrictMath.addExact(this.size(), extraPageSize), 65536);
            byte[] currentBuffer = this.buffer();
            this.allocate(targetByteSize);
            System.arraycopy(currentBuffer, 0, this.buffer(), 0, currentBuffer.length);
            this.currentMinSize = this.size() + extraPageSize;
            this.invokeGrowCallback();
            return previousSize;
        }
        return -1L;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public void reset() {
        this.allocate(this.declaredMinSize * 65536L);
        this.currentMinSize = this.declaredMinSize;
    }

    @Override
    public int load_i32(Node node, long address) {
        try {
            return ByteArraySupport.littleEndian().getInt(this.buffer(), address);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 4);
        }
    }

    @Override
    public long load_i64(Node node, long address) {
        try {
            return ByteArraySupport.littleEndian().getLong(this.buffer(), address);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 8);
        }
    }

    @Override
    public float load_f32(Node node, long address) {
        try {
            return ByteArraySupport.littleEndian().getFloat(this.buffer(), address);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 4);
        }
    }

    @Override
    public double load_f64(Node node, long address) {
        try {
            return ByteArraySupport.littleEndian().getDouble(this.buffer(), address);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 8);
        }
    }

    @Override
    public int load_i32_8s(Node node, long address) {
        try {
            return ByteArraySupport.littleEndian().getByte(this.buffer(), address);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 1);
        }
    }

    @Override
    public int load_i32_8u(Node node, long address) {
        try {
            return 0xFF & ByteArraySupport.littleEndian().getByte(this.buffer(), address);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 1);
        }
    }

    @Override
    public int load_i32_16s(Node node, long address) {
        try {
            return ByteArraySupport.littleEndian().getShort(this.buffer(), address);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 2);
        }
    }

    @Override
    public int load_i32_16u(Node node, long address) {
        try {
            return 0xFFFF & ByteArraySupport.littleEndian().getShort(this.buffer(), address);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 2);
        }
    }

    @Override
    public long load_i64_8s(Node node, long address) {
        try {
            return ByteArraySupport.littleEndian().getByte(this.buffer(), address);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 1);
        }
    }

    @Override
    public long load_i64_8u(Node node, long address) {
        try {
            return 0xFFL & (long)ByteArraySupport.littleEndian().getByte(this.buffer(), address);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 1);
        }
    }

    @Override
    public long load_i64_16s(Node node, long address) {
        try {
            return ByteArraySupport.littleEndian().getShort(this.buffer(), address);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 2);
        }
    }

    @Override
    public long load_i64_16u(Node node, long address) {
        try {
            return 0xFFFFL & (long)ByteArraySupport.littleEndian().getShort(this.buffer(), address);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 2);
        }
    }

    @Override
    public long load_i64_32s(Node node, long address) {
        try {
            return ByteArraySupport.littleEndian().getInt(this.buffer(), address);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 4);
        }
    }

    @Override
    public long load_i64_32u(Node node, long address) {
        try {
            return 0xFFFFFFFFL & (long)ByteArraySupport.littleEndian().getInt(this.buffer(), address);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 4);
        }
    }

    @Override
    public Vector128 load_i128(Node node, long address) {
        if (ByteArraySupport.littleEndian().inBounds(this.buffer(), address, 16L)) {
            return new Vector128(Arrays.copyOfRange(this.buffer(), (int)address, (int)address + 16));
        }
        throw this.trapOutOfBounds(node, address, 16);
    }

    @Override
    public void store_i32(Node node, long address, int value) {
        try {
            ByteArraySupport.littleEndian().putInt(this.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 4);
        }
    }

    @Override
    public void store_i64(Node node, long address, long value) {
        try {
            ByteArraySupport.littleEndian().putLong(this.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 8);
        }
    }

    @Override
    public void store_f32(Node node, long address, float value) {
        try {
            ByteArraySupport.littleEndian().putFloat(this.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 4);
        }
    }

    @Override
    public void store_f64(Node node, long address, double value) {
        try {
            ByteArraySupport.littleEndian().putDouble(this.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 8);
        }
    }

    @Override
    public void store_i32_8(Node node, long address, byte value) {
        try {
            ByteArraySupport.littleEndian().putByte(this.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 1);
        }
    }

    @Override
    public void store_i32_16(Node node, long address, short value) {
        try {
            ByteArraySupport.littleEndian().putShort(this.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 2);
        }
    }

    @Override
    public void store_i64_8(Node node, long address, byte value) {
        try {
            ByteArraySupport.littleEndian().putByte(this.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 1);
        }
    }

    @Override
    public void store_i64_16(Node node, long address, short value) {
        try {
            ByteArraySupport.littleEndian().putShort(this.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 2);
        }
    }

    @Override
    public void store_i64_32(Node node, long address, int value) {
        try {
            ByteArraySupport.littleEndian().putInt(this.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 4);
        }
    }

    @Override
    public void store_i128(Node node, long address, Vector128 value) {
        if (!ByteArraySupport.littleEndian().inBounds(this.buffer(), address, 16L)) {
            throw this.trapOutOfBounds(node, address, 16);
        }
        System.arraycopy(value.getBytes(), 0, this.buffer(), (int)address, 16);
    }

    private static void validateAtomicAddress(Node node, long address, int length) {
        if ((address & (long)(length - 1)) != 0L) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw ByteArrayWasmMemory.trapUnalignedAtomic(node, address, length);
        }
    }

    @Override
    public int atomic_load_i32(Node node, long address) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 4);
        try {
            return ByteArraySupport.littleEndian().getIntVolatile(this.buffer(), address);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 4);
        }
    }

    @Override
    public long atomic_load_i64(Node node, long address) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 8);
        try {
            return ByteArraySupport.littleEndian().getLongVolatile(this.buffer(), address);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 8);
        }
    }

    @Override
    public int atomic_load_i32_8u(Node node, long address) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 1);
        try {
            return 0xFF & ByteArraySupport.littleEndian().getByteVolatile(this.buffer(), address);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 1);
        }
    }

    @Override
    public int atomic_load_i32_16u(Node node, long address) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 2);
        try {
            return 0xFFFF & ByteArraySupport.littleEndian().getShortVolatile(this.buffer(), address);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 2);
        }
    }

    @Override
    public long atomic_load_i64_8u(Node node, long address) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 1);
        try {
            return 0xFFL & (long)ByteArraySupport.littleEndian().getByteVolatile(this.buffer(), address);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 1);
        }
    }

    @Override
    public long atomic_load_i64_16u(Node node, long address) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 2);
        try {
            return 0xFFFFL & (long)ByteArraySupport.littleEndian().getShortVolatile(this.buffer(), address);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 2);
        }
    }

    @Override
    public long atomic_load_i64_32u(Node node, long address) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 4);
        try {
            return 0xFFFFFFFFL & (long)ByteArraySupport.littleEndian().getIntVolatile(this.buffer(), address);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 4);
        }
    }

    @Override
    public void atomic_store_i32(Node node, long address, int value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 4);
        try {
            ByteArraySupport.littleEndian().putIntVolatile(this.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 4);
        }
    }

    @Override
    public void atomic_store_i64(Node node, long address, long value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 8);
        try {
            ByteArraySupport.littleEndian().putLongVolatile(this.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 8);
        }
    }

    @Override
    public void atomic_store_i32_8(Node node, long address, byte value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 1);
        try {
            ByteArraySupport.littleEndian().putByteVolatile(this.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 1);
        }
    }

    @Override
    public void atomic_store_i32_16(Node node, long address, short value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 2);
        try {
            ByteArraySupport.littleEndian().putShortVolatile(this.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 2);
        }
    }

    @Override
    public void atomic_store_i64_8(Node node, long address, byte value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 1);
        try {
            ByteArraySupport.littleEndian().putByteVolatile(this.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 1);
        }
    }

    @Override
    public void atomic_store_i64_16(Node node, long address, short value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 2);
        try {
            ByteArraySupport.littleEndian().putShortVolatile(this.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 2);
        }
    }

    @Override
    public void atomic_store_i64_32(Node node, long address, int value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 4);
        try {
            ByteArraySupport.littleEndian().putIntVolatile(this.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 4);
        }
    }

    @Override
    public int atomic_rmw_add_i32_8u(Node node, long address, byte value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 1);
        try {
            return 0xFF & ByteArraySupport.littleEndian().getAndAddByte(this.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 1);
        }
    }

    @Override
    public int atomic_rmw_add_i32_16u(Node node, long address, short value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 2);
        try {
            return 0xFFFF & ByteArraySupport.littleEndian().getAndAddShort(this.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 2);
        }
    }

    @Override
    public int atomic_rmw_add_i32(Node node, long address, int value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 4);
        try {
            return ByteArraySupport.littleEndian().getAndAddInt(this.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 4);
        }
    }

    @Override
    public long atomic_rmw_add_i64_8u(Node node, long address, byte value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 1);
        try {
            return 0xFFL & (long)ByteArraySupport.littleEndian().getAndAddByte(this.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 1);
        }
    }

    @Override
    public long atomic_rmw_add_i64_16u(Node node, long address, short value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 2);
        try {
            return 0xFFFFL & (long)ByteArraySupport.littleEndian().getAndAddShort(this.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 2);
        }
    }

    @Override
    public long atomic_rmw_add_i64_32u(Node node, long address, int value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 4);
        try {
            return 0xFFFFFFFFL & (long)ByteArraySupport.littleEndian().getAndAddInt(this.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 4);
        }
    }

    @Override
    public long atomic_rmw_add_i64(Node node, long address, long value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 8);
        try {
            return ByteArraySupport.littleEndian().getAndAddLong(this.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 8);
        }
    }

    @Override
    public int atomic_rmw_sub_i32_8u(Node node, long address, byte value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 1);
        try {
            return 0xFF & ByteArraySupport.littleEndian().getAndAddByte(this.buffer(), address, -value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 1);
        }
    }

    @Override
    public int atomic_rmw_sub_i32_16u(Node node, long address, short value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 2);
        try {
            return 0xFFFF & ByteArraySupport.littleEndian().getAndAddShort(this.buffer(), address, -value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 2);
        }
    }

    @Override
    public int atomic_rmw_sub_i32(Node node, long address, int value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 4);
        try {
            return ByteArraySupport.littleEndian().getAndAddInt(this.buffer(), address, -value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 4);
        }
    }

    @Override
    public long atomic_rmw_sub_i64_8u(Node node, long address, byte value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 1);
        try {
            return 0xFFL & (long)ByteArraySupport.littleEndian().getAndAddByte(this.buffer(), address, -value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 1);
        }
    }

    @Override
    public long atomic_rmw_sub_i64_16u(Node node, long address, short value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 2);
        try {
            return 0xFFFFL & (long)ByteArraySupport.littleEndian().getAndAddShort(this.buffer(), address, -value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 2);
        }
    }

    @Override
    public long atomic_rmw_sub_i64_32u(Node node, long address, int value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 4);
        try {
            return 0xFFFFFFFFL & (long)ByteArraySupport.littleEndian().getAndAddInt(this.buffer(), address, -value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 4);
        }
    }

    @Override
    public long atomic_rmw_sub_i64(Node node, long address, long value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 8);
        try {
            return ByteArraySupport.littleEndian().getAndAddLong(this.buffer(), address, -value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 8);
        }
    }

    @Override
    public int atomic_rmw_and_i32_8u(Node node, long address, byte value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 1);
        try {
            return 0xFF & ByteArraySupport.littleEndian().getAndBitwiseAndByte(this.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 1);
        }
    }

    @Override
    public int atomic_rmw_and_i32_16u(Node node, long address, short value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 2);
        try {
            return 0xFFFF & ByteArraySupport.littleEndian().getAndBitwiseAndShort(this.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 2);
        }
    }

    @Override
    public int atomic_rmw_and_i32(Node node, long address, int value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 4);
        try {
            return ByteArraySupport.littleEndian().getAndBitwiseAndInt(this.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 4);
        }
    }

    @Override
    public long atomic_rmw_and_i64_8u(Node node, long address, byte value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 1);
        try {
            return 0xFFL & (long)ByteArraySupport.littleEndian().getAndBitwiseAndByte(this.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 1);
        }
    }

    @Override
    public long atomic_rmw_and_i64_16u(Node node, long address, short value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 2);
        try {
            return 0xFFFFL & (long)ByteArraySupport.littleEndian().getAndBitwiseAndShort(this.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 2);
        }
    }

    @Override
    public long atomic_rmw_and_i64_32u(Node node, long address, int value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 4);
        try {
            return 0xFFFFFFFFL & (long)ByteArraySupport.littleEndian().getAndBitwiseAndInt(this.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 4);
        }
    }

    @Override
    public long atomic_rmw_and_i64(Node node, long address, long value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 8);
        try {
            return ByteArraySupport.littleEndian().getAndBitwiseAndLong(this.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 8);
        }
    }

    @Override
    public int atomic_rmw_or_i32_8u(Node node, long address, byte value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 1);
        try {
            return 0xFF & ByteArraySupport.littleEndian().getAndBitwiseOrByte(this.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 1);
        }
    }

    @Override
    public int atomic_rmw_or_i32_16u(Node node, long address, short value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 2);
        try {
            return 0xFFFF & ByteArraySupport.littleEndian().getAndBitwiseOrShort(this.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 2);
        }
    }

    @Override
    public int atomic_rmw_or_i32(Node node, long address, int value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 4);
        try {
            return ByteArraySupport.littleEndian().getAndBitwiseOrInt(this.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 4);
        }
    }

    @Override
    public long atomic_rmw_or_i64_8u(Node node, long address, byte value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 1);
        try {
            return 0xFFL & (long)ByteArraySupport.littleEndian().getAndBitwiseOrByte(this.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 1);
        }
    }

    @Override
    public long atomic_rmw_or_i64_16u(Node node, long address, short value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 2);
        try {
            return 0xFFFFL & (long)ByteArraySupport.littleEndian().getAndBitwiseOrShort(this.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 2);
        }
    }

    @Override
    public long atomic_rmw_or_i64_32u(Node node, long address, int value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 4);
        try {
            return 0xFFFFFFFFL & (long)ByteArraySupport.littleEndian().getAndBitwiseOrInt(this.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 4);
        }
    }

    @Override
    public long atomic_rmw_or_i64(Node node, long address, long value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 8);
        try {
            return ByteArraySupport.littleEndian().getAndBitwiseOrLong(this.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 8);
        }
    }

    @Override
    public int atomic_rmw_xor_i32_8u(Node node, long address, byte value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 1);
        try {
            return 0xFF & ByteArraySupport.littleEndian().getAndBitwiseXorByte(this.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 1);
        }
    }

    @Override
    public int atomic_rmw_xor_i32_16u(Node node, long address, short value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 2);
        try {
            return 0xFFFF & ByteArraySupport.littleEndian().getAndBitwiseXorShort(this.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 2);
        }
    }

    @Override
    public int atomic_rmw_xor_i32(Node node, long address, int value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 4);
        try {
            return ByteArraySupport.littleEndian().getAndBitwiseXorInt(this.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 4);
        }
    }

    @Override
    public long atomic_rmw_xor_i64_8u(Node node, long address, byte value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 1);
        try {
            return 0xFFL & (long)ByteArraySupport.littleEndian().getAndBitwiseXorByte(this.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 1);
        }
    }

    @Override
    public long atomic_rmw_xor_i64_16u(Node node, long address, short value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 2);
        try {
            return 0xFFFFL & (long)ByteArraySupport.littleEndian().getAndBitwiseXorShort(this.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 2);
        }
    }

    @Override
    public long atomic_rmw_xor_i64_32u(Node node, long address, int value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 4);
        try {
            return 0xFFFFFFFFL & (long)ByteArraySupport.littleEndian().getAndBitwiseXorInt(this.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 4);
        }
    }

    @Override
    public long atomic_rmw_xor_i64(Node node, long address, long value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 8);
        try {
            return ByteArraySupport.littleEndian().getAndBitwiseXorLong(this.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 8);
        }
    }

    @Override
    public int atomic_rmw_xchg_i32_8u(Node node, long address, byte value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 1);
        try {
            return 0xFF & ByteArraySupport.littleEndian().getAndSetByte(this.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 1);
        }
    }

    @Override
    public int atomic_rmw_xchg_i32_16u(Node node, long address, short value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 2);
        try {
            return 0xFFFF & ByteArraySupport.littleEndian().getAndSetShort(this.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 2);
        }
    }

    @Override
    public int atomic_rmw_xchg_i32(Node node, long address, int value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 4);
        try {
            return ByteArraySupport.littleEndian().getAndSetInt(this.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 4);
        }
    }

    @Override
    public long atomic_rmw_xchg_i64_8u(Node node, long address, byte value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 1);
        try {
            return 0xFFL & (long)ByteArraySupport.littleEndian().getAndSetByte(this.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 1);
        }
    }

    @Override
    public long atomic_rmw_xchg_i64_16u(Node node, long address, short value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 2);
        try {
            return 0xFFFFL & (long)ByteArraySupport.littleEndian().getAndSetShort(this.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 2);
        }
    }

    @Override
    public long atomic_rmw_xchg_i64_32u(Node node, long address, int value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 4);
        try {
            return 0xFFFFFFFFL & (long)ByteArraySupport.littleEndian().getAndSetInt(this.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 4);
        }
    }

    @Override
    public long atomic_rmw_xchg_i64(Node node, long address, long value) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 8);
        try {
            return ByteArraySupport.littleEndian().getAndSetLong(this.buffer(), address, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 8);
        }
    }

    @Override
    public int atomic_rmw_cmpxchg_i32_8u(Node node, long address, byte expected, byte replacement) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 1);
        try {
            return 0xFF & ByteArraySupport.littleEndian().compareAndExchangeByte(this.buffer(), address, expected, replacement);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 1);
        }
    }

    @Override
    public int atomic_rmw_cmpxchg_i32_16u(Node node, long address, short expected, short replacement) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 2);
        try {
            return 0xFFFF & ByteArraySupport.littleEndian().compareAndExchangeShort(this.buffer(), address, expected, replacement);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 2);
        }
    }

    @Override
    public int atomic_rmw_cmpxchg_i32(Node node, long address, int expected, int replacement) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 4);
        try {
            return ByteArraySupport.littleEndian().compareAndExchangeInt(this.buffer(), address, expected, replacement);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 4);
        }
    }

    @Override
    public long atomic_rmw_cmpxchg_i64_8u(Node node, long address, byte expected, byte replacement) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 1);
        try {
            return 0xFFL & (long)ByteArraySupport.littleEndian().compareAndExchangeByte(this.buffer(), address, expected, replacement);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 1);
        }
    }

    @Override
    public long atomic_rmw_cmpxchg_i64_16u(Node node, long address, short expected, short replacement) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 2);
        try {
            return 0xFFFFL & (long)ByteArraySupport.littleEndian().compareAndExchangeShort(this.buffer(), address, expected, replacement);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 2);
        }
    }

    @Override
    public long atomic_rmw_cmpxchg_i64_32u(Node node, long address, int expected, int replacement) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 4);
        try {
            return 0xFFFFFFFFL & (long)ByteArraySupport.littleEndian().compareAndExchangeInt(this.buffer(), address, expected, replacement);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 4);
        }
    }

    @Override
    public long atomic_rmw_cmpxchg_i64(Node node, long address, long expected, long replacement) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 8);
        try {
            return ByteArraySupport.littleEndian().compareAndExchangeLong(this.buffer(), address, expected, replacement);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.trapOutOfBounds(node, address, 8);
        }
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public int atomic_notify(Node node, long address, int count) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 4);
        if (this.outOfBounds(address, 4L)) {
            throw this.trapOutOfBounds(node, address, 4);
        }
        if (!this.isShared()) {
            return 0;
        }
        return this.invokeNotifyCallback(node, address, count);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public int atomic_wait32(Node node, long address, int expected, long timeout) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 4);
        if (this.outOfBounds(address, 4L)) {
            throw this.trapOutOfBounds(node, address, 4);
        }
        if (!this.isShared()) {
            throw this.trapUnsharedMemory(node);
        }
        return this.invokeWaitCallback(node, address, expected, timeout, false);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public int atomic_wait64(Node node, long address, long expected, long timeout) {
        ByteArrayWasmMemory.validateAtomicAddress(node, address, 8);
        if (this.outOfBounds(address, 8L)) {
            throw this.trapOutOfBounds(node, address, 8);
        }
        if (!this.isShared()) {
            throw this.trapUnsharedMemory(node);
        }
        return this.invokeWaitCallback(node, address, expected, timeout, true);
    }

    @Override
    public void initialize(byte[] source, int sourceOffset, long destinationOffset, int length) {
        assert (destinationOffset + (long)length <= this.byteSize());
        System.arraycopy(source, sourceOffset, this.buffer(), (int)destinationOffset, length);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public void fill(long offset, long length, byte value) {
        assert (offset + length <= this.byteSize());
        Arrays.fill(this.buffer(), (int)offset, (int)(offset + length), value);
    }

    @Override
    public void copyFrom(WasmMemory source, long sourceOffset, long destinationOffset, long length) {
        assert (source instanceof ByteArrayWasmMemory);
        assert (destinationOffset < this.byteSize());
        ByteArrayWasmMemory s = (ByteArrayWasmMemory)source;
        System.arraycopy(s.buffer(), (int)sourceOffset, this.buffer(), (int)destinationOffset, (int)length);
    }

    @Override
    public WasmMemory duplicate() {
        ByteArrayWasmMemory other = new ByteArrayWasmMemory(this.declaredMinSize, this.declaredMaxSize, this.size(), this.maxAllowedSize, this.indexType64, this.shared);
        System.arraycopy(this.buffer(), 0, other.buffer(), 0, (int)this.byteSize());
        return other;
    }

    @Override
    public void close() {
        this.dynamicBuffer = null;
    }

    @Override
    public ByteBuffer asByteBuffer() {
        return null;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public int copyFromStream(Node node, InputStream stream, int offset, int length) throws IOException {
        if (this.outOfBounds(offset, length)) {
            throw this.trapOutOfBounds(node, offset, length);
        }
        return stream.read(this.buffer(), offset, length);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public void copyToStream(Node node, OutputStream stream, int offset, int length) throws IOException {
        if (this.outOfBounds(offset, length)) {
            throw this.trapOutOfBounds(node, offset, length);
        }
        stream.write(this.buffer(), offset, length);
    }

    @Override
    public void copyToBuffer(Node node, byte[] dst, long srcOffset, int dstOffset, int length) {
        if (this.outOfBounds(srcOffset, (long)length)) {
            throw this.trapOutOfBounds(node, srcOffset, length);
        }
        System.arraycopy(this.buffer(), (int)srcOffset, dst, dstOffset, length);
    }

    @CompilerDirectives.TruffleBoundary
    private void allocate(long byteSize) {
        this.dynamicBuffer = null;
        this.dynamicBuffer = ByteArrayWasmMemory.allocateStatic(byteSize);
    }

    @CompilerDirectives.TruffleBoundary
    private static byte[] allocateStatic(long byteSize) {
        assert (byteSize <= Integer.MAX_VALUE) : byteSize;
        int effectiveByteSize = (int)byteSize;
        try {
            return new byte[effectiveByteSize];
        }
        catch (OutOfMemoryError error) {
            throw WasmException.create(Failure.MEMORY_ALLOCATION_FAILED);
        }
    }
}

