/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.predefined.wasi;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import java.util.Random;
import org.graalvm.wasm.WasmArguments;
import org.graalvm.wasm.WasmContext;
import org.graalvm.wasm.WasmInstance;
import org.graalvm.wasm.WasmLanguage;
import org.graalvm.wasm.WasmModule;
import org.graalvm.wasm.memory.WasmMemory;
import org.graalvm.wasm.predefined.WasmBuiltinRootNode;
import org.graalvm.wasm.predefined.wasi.SuppressFBWarnings;
import org.graalvm.wasm.predefined.wasi.types.Errno;

public class WasiConstantRandomGetNode
extends WasmBuiltinRootNode {
    private static final int SEED = 12345;

    public WasiConstantRandomGetNode(WasmLanguage language, WasmModule module) {
        super(language, module);
    }

    @Override
    public Object executeWithContext(VirtualFrame frame, WasmContext context, WasmInstance instance) {
        Object[] args = frame.getArguments();
        return WasiConstantRandomGetNode.randomGet(this.memory(frame), (Integer)WasmArguments.getArgument(args, 0), (Integer)WasmArguments.getArgument(args, 1));
    }

    @CompilerDirectives.TruffleBoundary
    @SuppressFBWarnings(value={"DMI_RANDOM_USED_ONLY_ONCE"}, justification="This is a testing class only")
    private static int randomGet(WasmMemory memory, int buf, int size) {
        byte[] randomData = new byte[size];
        new Random(12345L).nextBytes(randomData);
        memory.initialize(randomData, 0, buf, size);
        return Errno.Success.ordinal();
    }

    @Override
    public String builtinNodeName() {
        return "__wasi_random_get";
    }
}

