/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.predefined.wasi;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import java.util.Map;
import org.graalvm.wasm.WasmArguments;
import org.graalvm.wasm.WasmContext;
import org.graalvm.wasm.WasmInstance;
import org.graalvm.wasm.WasmLanguage;
import org.graalvm.wasm.WasmModule;
import org.graalvm.wasm.memory.WasmMemory;
import org.graalvm.wasm.predefined.WasmBuiltinRootNode;
import org.graalvm.wasm.predefined.wasi.types.Errno;

public final class WasiEnvironGetNode
extends WasmBuiltinRootNode {
    public WasiEnvironGetNode(WasmLanguage language, WasmModule module) {
        super(language, module);
    }

    @Override
    public Object executeWithContext(VirtualFrame frame, WasmContext context, WasmInstance instance) {
        Object[] args = frame.getArguments();
        return this.environGet(this.memory(frame), (Integer)WasmArguments.getArgument(args, 0), (Integer)WasmArguments.getArgument(args, 1));
    }

    @CompilerDirectives.TruffleBoundary
    private int environGet(WasmMemory memory, int envInitialPointer, int bufInitialPointer) {
        int bufPointer = bufInitialPointer;
        int envPointer = envInitialPointer;
        Map env = this.getContext().environment().getEnvironment();
        for (Map.Entry entry : env.entrySet()) {
            memory.store_i32((Node)this, envPointer, bufPointer);
            envPointer += 4;
            bufPointer += memory.writeString((Node)this, (String)entry.getKey() + "=" + (String)entry.getValue(), bufPointer);
            memory.store_i32_8((Node)this, bufPointer, (byte)0);
            ++bufPointer;
        }
        return Errno.Success.ordinal();
    }

    @Override
    public String builtinNodeName() {
        return "__wasi_environ_get";
    }
}

