/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.predefined.wasi;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import org.graalvm.wasm.WasmArguments;
import org.graalvm.wasm.WasmContext;
import org.graalvm.wasm.WasmInstance;
import org.graalvm.wasm.WasmLanguage;
import org.graalvm.wasm.WasmModule;
import org.graalvm.wasm.memory.WasmMemory;
import org.graalvm.wasm.predefined.WasmBuiltinRootNode;
import org.graalvm.wasm.predefined.wasi.fd.Fd;
import org.graalvm.wasm.predefined.wasi.types.Errno;

public class WasiPathRenameNode
extends WasmBuiltinRootNode {
    public WasiPathRenameNode(WasmLanguage language, WasmModule module) {
        super(language, module);
    }

    @Override
    public Object executeWithContext(VirtualFrame frame, WasmContext context, WasmInstance instance) {
        Object[] args = frame.getArguments();
        return this.pathRename(context, this.memory(frame), (Integer)WasmArguments.getArgument(args, 0), (Integer)WasmArguments.getArgument(args, 1), (Integer)WasmArguments.getArgument(args, 2), (Integer)WasmArguments.getArgument(args, 3), (Integer)WasmArguments.getArgument(args, 4), (Integer)WasmArguments.getArgument(args, 5));
    }

    @CompilerDirectives.TruffleBoundary
    private int pathRename(WasmContext context, WasmMemory memory, int oldFd, int oldPathAddress, int oldPathLength, int newFd, int newPathAddress, int newPathLength) {
        Fd oldHandle = context.fdManager().get(oldFd);
        Fd newHandle = context.fdManager().get(newFd);
        if (oldHandle == null || newHandle == null) {
            return Errno.Badf.ordinal();
        }
        return oldHandle.pathRename((Node)this, memory, oldPathAddress, oldPathLength, newHandle, newPathAddress, newPathLength).ordinal();
    }

    @Override
    public String builtinNodeName() {
        return "__wasi_path_rename";
    }
}

