/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.predefined.wasi.fd;

import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.nodes.Node;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.LinkOption;
import java.nio.file.attribute.FileTime;
import java.util.concurrent.TimeUnit;
import org.graalvm.wasm.memory.WasmMemory;
import org.graalvm.wasm.predefined.wasi.types.Dirent;
import org.graalvm.wasm.predefined.wasi.types.Errno;
import org.graalvm.wasm.predefined.wasi.types.Fdstat;
import org.graalvm.wasm.predefined.wasi.types.Filestat;
import org.graalvm.wasm.predefined.wasi.types.Filetype;
import org.graalvm.wasm.predefined.wasi.types.Iovec;

final class FdUtils {
    private FdUtils() {
    }

    static Errno writeToStream(Node node, WasmMemory memory, OutputStream stream, int iovecArrayAddress, int iovecCount, int sizeAddress) {
        if (stream == null) {
            return Errno.Acces;
        }
        int totalBytesWritten = 0;
        try {
            for (int i = 0; i < iovecCount; ++i) {
                int iovecAddress = iovecArrayAddress + i * 8;
                int start = Iovec.readBuf(node, memory, iovecAddress);
                int len = Iovec.readBufLen(node, memory, iovecAddress);
                memory.copyToStream(node, stream, start, len);
                totalBytesWritten += len;
            }
        }
        catch (IOException e) {
            return Errno.Io;
        }
        memory.store_i32(node, sizeAddress, totalBytesWritten);
        return Errno.Success;
    }

    static Errno readFromStream(Node node, WasmMemory memory, InputStream stream, int iovecArrayAddress, int iovecCount, int sizeAddress) {
        if (stream == null) {
            return Errno.Acces;
        }
        int totalBytesRead = 0;
        try {
            int len;
            int iovecAddress;
            int start;
            int bytesRead;
            for (int i = 0; i < iovecCount && (bytesRead = memory.copyFromStream(node, stream, start = Iovec.readBuf(node, memory, iovecAddress = iovecArrayAddress + i * 8), len = Iovec.readBufLen(node, memory, iovecAddress))) != -1; ++i) {
                totalBytesRead += bytesRead;
            }
        }
        catch (IOException e) {
            return Errno.Io;
        }
        memory.store_i32(node, sizeAddress, totalBytesRead);
        return Errno.Success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Errno writeToStreamAt(Node node, WasmMemory memory, OutputStream stream, int iovecArrayAddress, int iovecCount, SeekableByteChannel channel, long offset, int sizeAddress) {
        Errno errno;
        long currentOffset = channel.position();
        try {
            channel.position(offset);
            errno = FdUtils.writeToStream(node, memory, stream, iovecArrayAddress, iovecCount, sizeAddress);
        }
        catch (Throwable throwable) {
            try {
                channel.position(currentOffset);
                throw throwable;
            }
            catch (IOException e) {
                return Errno.Io;
            }
        }
        channel.position(currentOffset);
        return errno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Errno readFromStreamAt(Node node, WasmMemory memory, InputStream stream, int iovecArrayAddress, int iovecCount, SeekableByteChannel channel, long offset, int sizeAddress) {
        Errno errno;
        long currentOffset = channel.position();
        try {
            channel.position(offset);
            errno = FdUtils.readFromStream(node, memory, stream, iovecArrayAddress, iovecCount, sizeAddress);
        }
        catch (Throwable throwable) {
            try {
                channel.position(currentOffset);
                throw throwable;
            }
            catch (IOException e) {
                return Errno.Io;
            }
        }
        channel.position(currentOffset);
        return errno;
    }

    static Errno writeFdstat(Node node, WasmMemory memory, int address, Filetype type, short fsFlags, long fsRightsBase, long fsRightsInherting) {
        Fdstat.writeFsFiletype(node, memory, address, type);
        Fdstat.writeFsFlags(node, memory, address, fsFlags);
        Fdstat.writeFsRightsBase(node, memory, address, fsRightsBase);
        Fdstat.writeFsRightsInheriting(node, memory, address, fsRightsInherting);
        return Errno.Success;
    }

    static Errno writeFilestat(Node node, WasmMemory memory, int address, TruffleFile file) {
        try {
            Filestat.writeFiletype(node, memory, address, FdUtils.getType(file));
            Filestat.writeSize(node, memory, address, (Long)file.getAttribute(TruffleFile.SIZE, new LinkOption[0]));
            Filestat.writeAtim(node, memory, address, ((FileTime)file.getAttribute(TruffleFile.LAST_ACCESS_TIME, new LinkOption[0])).to(TimeUnit.NANOSECONDS));
            Filestat.writeMtim(node, memory, address, ((FileTime)file.getAttribute(TruffleFile.LAST_MODIFIED_TIME, new LinkOption[0])).to(TimeUnit.NANOSECONDS));
            try {
                Filestat.writeDev(node, memory, address, (Long)file.getAttribute(TruffleFile.UNIX_DEV, new LinkOption[0]));
                Filestat.writeIno(node, memory, address, (Long)file.getAttribute(TruffleFile.UNIX_INODE, new LinkOption[0]));
                Filestat.writeNlink(node, memory, address, ((Integer)file.getAttribute(TruffleFile.UNIX_NLINK, new LinkOption[0])).intValue());
                Filestat.writeCtim(node, memory, address, ((FileTime)file.getAttribute(TruffleFile.UNIX_CTIME, new LinkOption[0])).to(TimeUnit.NANOSECONDS));
            }
            catch (UnsupportedOperationException unsupportedOperationException) {}
        }
        catch (IOException e) {
            return Errno.Io;
        }
        catch (SecurityException e) {
            return Errno.Acces;
        }
        return Errno.Success;
    }

    static int writeDirent(Node node, WasmMemory memory, int address, TruffleFile file, int nameLength, long offset) throws IOException {
        Dirent.writeDNext(node, memory, address, offset);
        try {
            Dirent.writeDIno(node, memory, address, (Long)file.getAttribute(TruffleFile.UNIX_INODE, new LinkOption[0]));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        Dirent.writeDNamlen(node, memory, address, nameLength);
        Dirent.writeDType(node, memory, address, FdUtils.getType(file));
        return 24;
    }

    static byte[] writeDirentToByteArray(TruffleFile file, int nameLength, long offset) throws IOException {
        byte[] buffer = new byte[24];
        Dirent.writeDNextToByteArray(buffer, 0, offset);
        try {
            Dirent.writeDInoToByteArray(buffer, 0, (Long)file.getAttribute(TruffleFile.UNIX_INODE, new LinkOption[0]));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        Dirent.writeDNamlen(buffer, 0, nameLength);
        Dirent.writeDType(buffer, 0, FdUtils.getType(file));
        return buffer;
    }

    static Filetype getType(TruffleFile file) throws IOException {
        if (((Boolean)file.getAttribute(TruffleFile.IS_DIRECTORY, new LinkOption[0])).booleanValue()) {
            return Filetype.Directory;
        }
        if (((Boolean)file.getAttribute(TruffleFile.IS_REGULAR_FILE, new LinkOption[0])).booleanValue()) {
            return Filetype.RegularFile;
        }
        if (((Boolean)file.getAttribute(TruffleFile.IS_SYMBOLIC_LINK, new LinkOption[0])).booleanValue()) {
            return Filetype.SymbolicLink;
        }
        return Filetype.Unknown;
    }
}

