/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.predefined.wasi.types;

import com.oracle.truffle.api.nodes.Node;
import org.graalvm.wasm.memory.WasmMemory;
import org.graalvm.wasm.predefined.wasi.types.Clockid;

public final class SubscriptionClock {
    public static final int BYTES = 32;

    private SubscriptionClock() {
    }

    public static Clockid readId(Node node, WasmMemory memory, int address) {
        return Clockid.fromValue(memory.load_i32(node, address + 0));
    }

    public static void writeId(Node node, WasmMemory memory, int address, Clockid value) {
        memory.store_i32(node, address + 0, value.toValue());
    }

    public static long readTimeout(Node node, WasmMemory memory, int address) {
        return memory.load_i64(node, address + 8);
    }

    public static void writeTimeout(Node node, WasmMemory memory, int address, long value) {
        memory.store_i64(node, address + 8, value);
    }

    public static long readPrecision(Node node, WasmMemory memory, int address) {
        return memory.load_i64(node, address + 16);
    }

    public static void writePrecision(Node node, WasmMemory memory, int address, long value) {
        memory.store_i64(node, address + 16, value);
    }

    public static short readFlags(Node node, WasmMemory memory, int address) {
        return (short)memory.load_i32_16u(node, address + 24);
    }

    public static void writeFlags(Node node, WasmMemory memory, int address, short value) {
        memory.store_i32_16(node, address + 24, value);
    }
}

