/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.debugging.data.objects;

import org.graalvm.wasm.debugging.DebugLocation;
import org.graalvm.wasm.debugging.data.DebugContext;
import org.graalvm.wasm.debugging.data.DebugType;
import org.graalvm.wasm.debugging.data.objects.DebugBinding;
import org.graalvm.wasm.debugging.parser.DebugParser;

public class DebugParameter
extends DebugBinding {
    private final String name;
    private final byte[] locationExpression;

    public DebugParameter(String name, DebugType type, byte[] locationExpression) {
        super(type);
        this.name = name;
        this.locationExpression = locationExpression;
    }

    private DebugLocation parameterLocation(DebugLocation baseLocation) {
        if (this.locationExpression != null) {
            return DebugParser.readExpression(this.locationExpression, baseLocation);
        }
        return baseLocation.invalidate();
    }

    @Override
    public String toDisplayString() {
        return this.name;
    }

    @Override
    public DebugLocation getLocation(DebugLocation location) {
        return this.parameterLocation(location);
    }

    @Override
    public DebugContext getContext(DebugContext context) {
        return context.with(this.name);
    }
}

