/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.debugging.data.types;

import java.util.Objects;
import java.util.StringJoiner;
import org.graalvm.wasm.debugging.DebugLocation;
import org.graalvm.wasm.debugging.data.DebugContext;
import org.graalvm.wasm.debugging.data.DebugType;
import org.graalvm.wasm.debugging.representation.DebugConstantDisplayValue;

public class DebugSubroutineType
extends DebugType {
    protected final String name;
    protected final DebugType returnType;
    protected final DebugType[] parameterTypes;

    public DebugSubroutineType(String name, DebugType returnType, DebugType[] parameterTypes) {
        assert (parameterTypes != null) : "the parameter types of the parameters of a debug subroutine type (function) must not be null";
        this.name = name;
        this.returnType = returnType;
        this.parameterTypes = parameterTypes;
    }

    @Override
    public String asTypeName() {
        StringBuilder builder = new StringBuilder();
        if (this.returnType != null) {
            builder.append(this.returnType.asTypeName());
        } else {
            builder.append("void");
        }
        builder.append(' ');
        builder.append(Objects.requireNonNullElse(this.name, "function"));
        builder.append("(");
        StringJoiner joiner = new StringJoiner(", ");
        for (DebugType parameterType : this.parameterTypes) {
            joiner.add(parameterType.asTypeName());
        }
        builder.append(joiner);
        builder.append(")");
        return builder.toString();
    }

    @Override
    public int valueLength() {
        return 0;
    }

    @Override
    public boolean isValue() {
        return true;
    }

    @Override
    public Object asValue(DebugContext context, DebugLocation location) {
        return new DebugConstantDisplayValue(this.asTypeName());
    }
}

