/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.memory;

import org.graalvm.wasm.Assert;
import org.graalvm.wasm.exception.Failure;
import org.graalvm.wasm.memory.ByteArrayWasmMemory;
import org.graalvm.wasm.memory.NativeWasmMemory;
import org.graalvm.wasm.memory.UnsafeWasmMemory;
import org.graalvm.wasm.memory.WasmMemory;

public class WasmMemoryFactory {
    public static WasmMemory createMemory(long declaredMinSize, long declaredMaxSize, boolean indexType64, boolean shared, boolean unsafeMemory, boolean directByteBufferMemoryAccess) {
        if (directByteBufferMemoryAccess) {
            Assert.assertTrue(unsafeMemory, "DirectByteBufferMemoryAccess is only supported when UseUnsafeMemory flag is set.", Failure.SHARED_MEMORY_WITHOUT_UNSAFE);
        }
        if (shared) {
            Assert.assertTrue(unsafeMemory, "Shared memories are only supported when UseUnsafeMemory flag is set.", Failure.SHARED_MEMORY_WITHOUT_UNSAFE);
        }
        if (unsafeMemory) {
            if (directByteBufferMemoryAccess || shared) {
                return new UnsafeWasmMemory(declaredMinSize, declaredMaxSize, indexType64, shared);
            }
            if (declaredMaxSize > 32767L) {
                return new NativeWasmMemory(declaredMinSize, declaredMaxSize, indexType64);
            }
        }
        return new ByteArrayWasmMemory(declaredMinSize, declaredMaxSize, indexType64);
    }

    public static long getMaximumAllowedSize(boolean shared, boolean unsafeMemory, boolean directByteBufferMemoryAccess) {
        if (unsafeMemory) {
            if (directByteBufferMemoryAccess || shared) {
                return 32767L;
            }
            return 976562500L;
        }
        return 32767L;
    }
}

