/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.parser.validation;

import org.graalvm.wasm.collection.IntArrayList;
import org.graalvm.wasm.exception.Failure;
import org.graalvm.wasm.exception.WasmException;
import org.graalvm.wasm.parser.bytecode.RuntimeBytecodeGen;
import org.graalvm.wasm.parser.validation.ControlFrame;
import org.graalvm.wasm.parser.validation.ParserState;

class BlockFrame
extends ControlFrame {
    private final IntArrayList branches = new IntArrayList();

    BlockFrame(byte[] paramTypes, byte[] resultTypes, int initialStackSize, boolean unreachable) {
        super(paramTypes, resultTypes, initialStackSize, unreachable);
    }

    @Override
    byte[] labelTypes() {
        return this.resultTypes();
    }

    @Override
    void enterElse(ParserState state, RuntimeBytecodeGen bytecode) {
        throw WasmException.create(Failure.TYPE_MISMATCH, "Expected then branch. Else branch requires preceding then branch.");
    }

    @Override
    void exit(RuntimeBytecodeGen bytecode) {
        if (this.branches.size() == 0) {
            return;
        }
        int location = bytecode.addLabel(this.resultTypeLength(), this.initialStackSize(), this.commonResultType());
        for (int branchLocation : this.branches.toArray()) {
            bytecode.patchLocation(branchLocation, location);
        }
    }

    @Override
    void addBranch(RuntimeBytecodeGen bytecode) {
        this.branches.add(bytecode.addBranchLocation());
    }

    @Override
    void addBranchIf(RuntimeBytecodeGen bytecode) {
        this.branches.add(bytecode.addBranchIfLocation());
    }

    @Override
    void addBranchTableItem(RuntimeBytecodeGen bytecode) {
        this.branches.add(bytecode.addBranchTableItemLocation());
    }
}

