/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.parser.validation;

import org.graalvm.wasm.parser.validation.ControlFrame;

public class ControlStack {
    private ControlFrame[] stack = new ControlFrame[4];
    private int size = 0;

    private void ensureSize() {
        if (this.size == this.stack.length) {
            ControlFrame[] nStack = new ControlFrame[this.stack.length * 2];
            System.arraycopy(this.stack, 0, nStack, 0, this.size);
            this.stack = nStack;
        }
    }

    public void push(ControlFrame frame) {
        this.ensureSize();
        this.stack[this.size] = frame;
        ++this.size;
    }

    public void pop() {
        assert (this.size > 0) : "cannot pop from empty stack";
        --this.size;
    }

    public ControlFrame peek() {
        assert (this.size > 0) : "cannot peek empty stack";
        return this.stack[this.size - 1];
    }

    public ControlFrame get(int index) {
        assert (this.size - index - 1 >= 0 && this.size - index - 1 < this.size) : "invalid element index";
        return this.stack[this.size - index - 1];
    }

    public ControlFrame getFirst() {
        return this.stack[0];
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int size() {
        return this.size;
    }
}

