/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.predefined.wasi;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import org.graalvm.wasm.WasmArguments;
import org.graalvm.wasm.WasmContext;
import org.graalvm.wasm.WasmInstance;
import org.graalvm.wasm.WasmLanguage;
import org.graalvm.wasm.WasmModule;
import org.graalvm.wasm.exception.Failure;
import org.graalvm.wasm.exception.WasmException;
import org.graalvm.wasm.memory.WasmMemory;
import org.graalvm.wasm.predefined.WasmBuiltinRootNode;
import org.graalvm.wasm.predefined.wasi.types.Clockid;
import org.graalvm.wasm.predefined.wasi.types.Errno;

public final class WasiClockResGetNode
extends WasmBuiltinRootNode {
    private static final long CLOCK_RESOLUTION_NANOS = 1000L;

    public WasiClockResGetNode(WasmLanguage language, WasmModule module) {
        super(language, module);
    }

    @Override
    public Object executeWithContext(VirtualFrame frame, WasmContext context, WasmInstance instance) {
        Object[] args = frame.getArguments();
        assert (WasmArguments.getArgumentCount(args) == 3);
        return this.clockResGet(this.memory(frame), (Integer)WasmArguments.getArgument(args, 0), (Integer)WasmArguments.getArgument(args, 1));
    }

    @CompilerDirectives.TruffleBoundary
    private Object clockResGet(WasmMemory memory, int clockIdValue, int resultAddress) {
        Clockid clockId = Clockid.values()[clockIdValue];
        switch (clockId) {
            case Realtime: 
            case Monotonic: {
                this.memoryLib.store_i64(memory, (Node)this, resultAddress, 1000L);
                break;
            }
            case ProcessCputimeId: 
            case ThreadCputimeId: {
                throw WasiClockResGetNode.unimplementedClock(clockId);
            }
        }
        return Errno.Success.ordinal();
    }

    @CompilerDirectives.TruffleBoundary
    private static WasmException unimplementedClock(Clockid clockId) {
        throw WasmException.create(Failure.UNSPECIFIED_INTERNAL, "Unimplemented ClockID: " + clockId.name());
    }

    @Override
    public String builtinNodeName() {
        return "__wasi_clock_res_get";
    }
}

